/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections4.iterators.NodeListIterator;
import org.geoserver.rest.catalog.NamedMap;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Component
public class MapXMLConverter
extends BaseMessageConverter<Map<?, ?>> {
    public MapXMLConverter() {
        super(new MediaType[]{MediaType.TEXT_XML, MediaType.APPLICATION_XML});
    }

    protected boolean supports(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz) && !Properties.class.isAssignableFrom(clazz);
    }

    public Map<?, ?> readInternal(Class<? extends Map<?, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Document dom;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setEntityResolver(this.catalog.getResourcePool().getEntityResolver());
            dom = builder.parse(inputMessage.getBody());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IOException("Error building document", e);
        }
        Element elem = dom.getDocumentElement();
        Object result = this.convert(elem);
        return (Map)result;
    }

    public void writeInternal(Map<?, ?> map, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Element root;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            root = doc.createElement(this.getMapName(map));
            doc.appendChild(root);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Error building document", e);
        }
        this.insert(root, map);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult outputTarget = new StreamResult(outputMessage.getBody());
            transformer.transform(new DOMSource(root), outputTarget);
        }
        catch (TransformerException e) {
            throw new IOException("Error writing document", e);
        }
    }

    protected String getMapName(Map<?, ?> map) {
        if (map instanceof NamedMap) {
            return ((NamedMap)map).getName();
        }
        return "root";
    }

    protected Object convert(Element elem) {
        List<Element> children = this.getChildren(elem);
        if (children.isEmpty()) {
            String content = elem.getTextContent();
            if (null == content || content.isEmpty()) {
                return null;
            }
            return content;
        }
        if (children.get(0) instanceof Element) {
            Element child = children.get(0);
            if (child.getNodeName().equals("entry")) {
                ArrayList<Object> l = new ArrayList<Object>();
                for (Node node : children) {
                    if (!(node instanceof Element) || !"entry".equals(node.getNodeName())) continue;
                    Element curr = (Element)node;
                    l.add(this.convert(curr));
                }
                return l;
            }
            NamedMap m = new NamedMap(child.getNodeName());
            for (Element element : children) {
                m.put(element.getNodeName(), this.convert(element));
            }
            return m;
        }
        throw new RuntimeException("Unable to parse XML");
    }

    private List<Element> getChildren(Element elem) {
        return Streams.stream((Iterator)new NodeListIterator((Node)elem)).filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList());
    }

    protected void insert(Element elem, Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                Element newElem = elem.getOwnerDocument().createElement(entry.getKey().toString());
                this.insert(newElem, entry.getValue());
                elem.appendChild(newElem);
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object entry : collection) {
                Element newElem = elem.getOwnerDocument().createElement("entry");
                this.insert(newElem, entry);
                elem.appendChild(newElem);
            }
        } else {
            String text = object == null ? "" : object.toString();
            elem.setTextContent(text);
        }
    }
}

