/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.rest.catalog.SequentialExecutionController;
import org.geoserver.rest.security.xml.JaxbRoleList;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="rolesRestController")
@RequestMapping(path={"/rest/security/roles"})
public class RolesRestController
implements SequentialExecutionController {
    protected GeoServerSecurityManager securityManager;

    public RolesRestController(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public void somethingNotFound(IllegalArgumentException exception, HttpServletResponse response) throws IOException {
        response.sendError(404, exception.getMessage());
    }

    @GetMapping(value={""}, produces={"application/xml", "application/json"})
    public JaxbRoleList get() throws IOException {
        return this.get(this.securityManager.getActiveRoleService());
    }

    @GetMapping(value={"/user/{user}"}, produces={"application/xml", "application/json"})
    protected JaxbRoleList getUser(@PathVariable(value="user") String userName) throws IOException {
        return this.getUser(this.securityManager.getActiveRoleService(), userName);
    }

    @GetMapping(value={"/group/{group}"}, produces={"application/xml", "application/json"})
    protected JaxbRoleList getGroup(@PathVariable(value="group") String groupName) throws IOException {
        return this.getGroup(this.securityManager.getActiveRoleService(), groupName);
    }

    @PostMapping(value={"/role/{role}"}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void insert(@PathVariable(value="role") String roleName) throws IOException {
        this.insert(this.securityManager.getActiveRoleService(), roleName);
    }

    @DeleteMapping(value={"/role/{role}"}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable(value="role") String roleName) throws IOException {
        this.delete(this.securityManager.getActiveRoleService(), roleName);
    }

    @PostMapping(value={"/role/{role}/user/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void associateUser(@PathVariable(value="role") String roleName, @PathVariable(value="user") String userName) throws IOException {
        this.associateUser(this.securityManager.getActiveRoleService(), roleName, userName);
    }

    @DeleteMapping(value={"/role/{role}/user/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void disassociateUser(@PathVariable(value="role") String roleName, @PathVariable(value="user") String userName) throws IOException {
        this.disassociateUser(this.securityManager.getActiveRoleService(), roleName, userName);
    }

    @PostMapping(value={"/role/{role}/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void associateGroup(@PathVariable(value="role") String roleName, @PathVariable(value="group") String groupName) throws IOException {
        this.associateToGroup(this.securityManager.getActiveRoleService(), roleName, groupName);
    }

    @DeleteMapping(value={"/role/{role}/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void disassociateGroup(@PathVariable(value="role") String roleName, @PathVariable(value="group") String groupName) throws IOException {
        this.disassociateToGroup(this.securityManager.getActiveRoleService(), roleName, groupName);
    }

    @GetMapping(value={"/service/{serviceName}"}, produces={"application/xml", "application/json"})
    protected JaxbRoleList get(@PathVariable(value="serviceName") String serviceName) throws IOException {
        return this.get(this.getService(serviceName));
    }

    @GetMapping(value={"/service/{serviceName}/user/{user}"}, produces={"application/xml", "application/json"})
    protected JaxbRoleList getUser(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="user") String userName) throws IOException {
        return this.getUser(this.getService(serviceName), userName);
    }

    @GetMapping(value={"/service/{serviceName}/group/{group}"}, produces={"application/xml", "application/json"})
    protected JaxbRoleList getGroup(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="group") String groupName) throws IOException {
        return this.getGroup(this.getService(serviceName), groupName);
    }

    @PostMapping(value={"/service/{serviceName}/role/{role}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void insert(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="role") String roleName) throws IOException {
        this.insert(this.getService(serviceName), roleName);
    }

    @DeleteMapping(value={"/service/{serviceName}/role/{role}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="role") String roleName) throws IOException {
        this.delete(this.getService(serviceName), roleName);
    }

    @PostMapping(value={"/service/{serviceName}/role/{role}/user/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void associateUser(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="role") String roleName, @PathVariable(value="user") String userName) throws IOException {
        this.associateUser(this.getService(serviceName), roleName, userName);
    }

    @DeleteMapping(value={"/service/{serviceName}/role/{role}/user/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void disassociateUser(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="role") String roleName, @PathVariable(value="user") String userName) throws IOException {
        this.disassociateUser(this.getService(serviceName), roleName, userName);
    }

    @PostMapping(value={"/service/{serviceName}/role/{role}/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void associateGroup(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="role") String roleName, @PathVariable(value="group") String groupName) throws IOException {
        this.associateToGroup(this.getService(serviceName), roleName, groupName);
    }

    @DeleteMapping(value={"/service/{serviceName}/role/{role}/group/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void disassociateGroup(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="role") String roleName, @PathVariable(value="user") String groupName) throws IOException {
        this.disassociateToGroup(this.getService(serviceName), roleName, groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associateToGroup(GeoServerRoleService roleService, String roleName, String groupName) throws IOException {
        GeoServerRoleStore store = this.getStore(roleService);
        try {
            store.associateRoleToGroup(this.getRole((GeoServerRoleService)store, roleName), groupName);
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disassociateToGroup(GeoServerRoleService roleService, String roleName, String groupName) throws IOException {
        GeoServerRoleStore store = this.getStore(roleService);
        try {
            store.disAssociateRoleFromGroup(this.getRole((GeoServerRoleService)store, roleName), groupName);
        }
        finally {
            store.store();
        }
    }

    protected JaxbRoleList getUser(GeoServerRoleService roleService, String userName) throws IOException {
        return JaxbRoleList.fromGS(roleService.getRolesForUser(userName));
    }

    protected JaxbRoleList getGroup(GeoServerRoleService roleService, String groupName) throws IOException {
        return JaxbRoleList.fromGS(roleService.getRolesForGroup(groupName));
    }

    protected JaxbRoleList get(GeoServerRoleService roleService) throws IOException {
        return JaxbRoleList.fromGS(roleService.getRoles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(GeoServerRoleService roleService, String roleName) throws IOException {
        GeoServerRoleStore store = this.getStore(roleService);
        try {
            store.addRole(new GeoServerRole(roleName));
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(GeoServerRoleService roleService, String roleName) throws IOException {
        GeoServerRoleStore store = this.getStore(roleService);
        try {
            store.removeRole(this.getRole((GeoServerRoleService)store, roleName));
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associateUser(GeoServerRoleService roleService, String roleName, String userName) throws IOException {
        GeoServerRoleStore store = this.getStore(roleService);
        try {
            store.associateRoleToUser(this.getRole((GeoServerRoleService)store, roleName), userName);
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disassociateUser(GeoServerRoleService roleService, String roleName, String userName) throws IOException {
        GeoServerRoleStore store = this.getStore(roleService);
        try {
            store.disAssociateRoleFromUser(this.getRole((GeoServerRoleService)store, roleName), userName);
        }
        finally {
            store.store();
        }
    }

    protected GeoServerRoleStore getStore(GeoServerRoleService roleService) throws IOException {
        if (roleService.canCreateStore()) {
            return roleService.createStore();
        }
        throw new IOException("Provided roleservice is read-only: " + roleService.getName());
    }

    protected GeoServerRoleService getService(String serviceName) throws IOException {
        GeoServerRoleService roleService = this.securityManager.loadRoleService(serviceName);
        if (roleService == null) {
            throw new IllegalArgumentException("Provided roleservice does not exist: " + serviceName);
        }
        return roleService;
    }

    protected GeoServerRole getRole(GeoServerRoleService service, String roleName) throws IOException {
        GeoServerRole role = service.getRoleByName(roleName);
        if (role == null) {
            throw new IllegalArgumentException("Provided role does not exist: " + roleName);
        }
        return role;
    }
}

