/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.StringWriter;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AboutControllerTest
extends GeoServerSystemTestSupport {
    private static String BASEPATH = "/rest";

    @Test
    public void testEmptyListHTMLTemplate() throws Exception {
        try {
            this.getAsDOM(BASEPATH + "/about/version?manifest=NOTEXISTS.*");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void testGetVersionsAsXML() throws Exception {
        Document dom = this.getAsDOM(BASEPATH + "/about/version.xml");
        this.checkXMLModel(dom);
    }

    @Test
    public void testGetManifestsAsXML() throws Exception {
        Document dom = this.getAsDOM(BASEPATH + "/about/manifest.xml");
        this.checkXMLModel(dom);
    }

    @Test
    public void testGetAsVersionsHTML() throws Exception {
        Document dom = this.getAsDOM(BASEPATH + "/about/version");
        this.checkHTMLModel(dom);
    }

    @Test
    public void testGetAsManifestsHTML() throws Exception {
        Document dom = this.getAsDOM(BASEPATH + "/about/manifest?manifest=freemarker.*");
        this.checkHTMLModel(dom);
    }

    @Test
    public void testGetAsVersionsJSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON(BASEPATH + "/about/version.json");
        this.checkJSONModel(json);
    }

    @Test
    public void testGetAsManifestsJSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON(BASEPATH + "/about/manifest.json");
        this.checkJSONModel(json);
    }

    @Test
    public void testGetStatusAsHTML() throws Exception {
        System.setProperty("badString", "\u0007\b\u001b[46m");
        Document dom = this.getAsDOM(BASEPATH + "/about/status");
        this.checkHTMLModel(dom);
        Document dom2 = this.getAsDOM(BASEPATH + "/about/status.html");
        this.checkHTMLModel(dom2);
    }

    @Test
    public void testGetStatusAsJSON() throws Exception {
        this.getAsJSON(BASEPATH + "/about/status.json");
    }

    @Test
    public void testGetStatusAsXML() throws Exception {
        this.getAsDOM(BASEPATH + "/about/status.xml");
    }

    private void checkHTMLModel(Document dom) {
        Element resource = this.getFirstElementByTagName(dom, "h2");
        Assert.assertTrue((boolean)resource.getTextContent().equalsIgnoreCase("About:"));
        Assert.assertNotNull((Object)resource);
        try {
            AboutControllerTest.serializeXML(dom);
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    private void checkJSONModel(JSONObject json) {
        LOGGER.info("JSON model: " + json.toString(2));
        Assert.assertNotNull((Object)json);
        Object obj = json.get("about");
        Assert.assertTrue((boolean)(obj instanceof JSONObject));
        JSONObject about = (JSONObject)obj;
        obj = about.get("resource");
        Assert.assertTrue((boolean)(obj instanceof JSONArray));
    }

    private void checkXMLModel(Document dom) {
        Element resource = this.getFirstElementByTagName(dom, "resource");
        Assert.assertNotNull((Object)resource);
        Assert.assertFalse((boolean)resource.getAttribute("name").isEmpty());
    }

    protected static void serializeXML(Document domDoc) throws TransformerException {
        try {
            DOMSource domSrc = new DOMSource(domDoc);
            Transformer txformer = TransformerFactory.newInstance().newTransformer();
            txformer.setOutputProperty("omit-xml-declaration", "no");
            txformer.setOutputProperty("method", "xml");
            txformer.setOutputProperty("encoding", "UTF-8");
            txformer.setOutputProperty("indent", "yes");
            txformer.setOutputProperty("standalone", "yes");
            txformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            txformer.transform(domSrc, sr);
        }
        catch (TransformerException | TransformerFactoryConfigurationError ex) {
            LOGGER.log(Level.WARNING, "", ex);
            throw ex;
        }
    }
}

