/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.DispatcherServlet;

public class RestConcurrencyTest
extends CatalogRESTTestSupport {
    static volatile Exception exception;
    volatile DispatcherServlet dispatcher;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        exception = null;
    }

    protected void addPropertyDataStores(int typeCount) throws Exception {
        ByteArrayOutputStream zbytes = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(zbytes);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (int i = 0; i < typeCount; ++i) {
            String name = "pds" + i;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bytes));
            writer.write("_=name:String,pointProperty:Point\n");
            writer.write(name + ".0='zero'|POINT(0 0)\n");
            writer.write(name + ".1='one'|POINT(1 1)\n");
            writer.flush();
            zout.putNextEntry(new ZipEntry(name + ".properties"));
            zout.write(bytes.toByteArray());
            bytes.reset();
        }
        zout.flush();
        zout.close();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties?configure=none", zbytes.toByteArray(), "application/zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DispatcherServlet getDispatcher() throws Exception {
        if (this.dispatcher == null) {
            RestConcurrencyTest restConcurrencyTest = this;
            synchronized (restConcurrencyTest) {
                if (this.dispatcher == null) {
                    this.dispatcher = super.getDispatcher();
                }
            }
        }
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureTypeConcurrency() throws Exception {
        int typeCount = 5;
        this.addPropertyDataStores(typeCount);
        ExecutorService es = Executors.newCachedThreadPool();
        try {
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
            for (int i = 0; i < typeCount; ++i) {
                futures.add(es.submit(new AddRemoveFeatureTypeWorker("gs", "pds", "pds" + i, 5)));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            es.shutdownNow();
        }
    }

    class AddRemoveFeatureTypeWorker
    implements Callable<Integer> {
        final Logger LOGGER = Logging.getLogger(RestConcurrencyTest.class);
        String typeName;
        String workspace;
        String store;
        int loops;

        public AddRemoveFeatureTypeWorker(String workspace, String store, String typeName, int loops) {
            this.typeName = typeName;
            this.workspace = workspace;
            this.store = store;
            this.loops = loops;
        }

        @Override
        public Integer call() throws Exception {
            try {
                this.callInternal();
            }
            catch (Exception e) {
                exception = e;
                throw e;
            }
            return this.loops;
        }

        private void callInternal() throws Exception {
            RestConcurrencyTest.this.login();
            String threadId = Thread.currentThread().getId() + " ";
            for (int i = 0; i < this.loops && exception == null; ++i) {
                String base = "/rest/workspaces/" + this.workspace + "/datastores/" + this.store + "/featuretypes";
                String xml = "<featureType><name>" + this.typeName + "</name><nativeName>" + this.typeName + "</nativeName><srs>EPSG:4326</srs><nativeCRS>EPSG:4326</nativeCRS><nativeBoundingBox><minx>0.0</minx><maxx>1.0</maxx><miny>0.0</miny><maxy>1.0</maxy><crs>EPSG:4326</crs></nativeBoundingBox><store>" + this.store + "</store></featureType>";
                this.LOGGER.info(threadId + "Adding " + this.typeName);
                MockHttpServletResponse response = RestConcurrencyTest.this.postAsServletResponse(base, xml, "text/xml");
                Assert.assertEquals((long)201L, (long)response.getStatus());
                Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
                Assert.assertNotNull((Object)response.getHeader("Location"));
                Assert.assertTrue((boolean)response.getHeader("Location").endsWith(base + "/" + this.typeName));
                this.LOGGER.info(threadId + "Checking " + this.typeName);
                String resourcePath = "/rest/layers/" + this.workspace + ":" + this.typeName;
                response = RestConcurrencyTest.this.getAsServletResponse(resourcePath + ".xml");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                this.LOGGER.info(threadId + "Reloading catalog");
                Assert.assertEquals((long)200L, (long)RestConcurrencyTest.this.postAsServletResponse("/rest/reload", "").getStatus());
                this.LOGGER.info(threadId + "Removing layer");
                String deletePath = resourcePath + "?recurse=true";
                Assert.assertEquals((long)200L, (long)RestConcurrencyTest.this.deleteAsServletResponse(deletePath).getStatus());
            }
        }
    }
}

