/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.geoserver.rest.security.AuthenticationFilterChainRestController;
import org.geoserver.rest.security.xml.AuthFilterChain;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.HtmlLoginFilterChain;
import org.geoserver.test.GeoServerTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.util.UriComponentsBuilder;

public class AuthenticationFilterChainRestControllerTest
extends GeoServerTestSupport {
    private static final String DEFAULT_CHAIN_NAME = "default";
    private static final String TEST_CHAIN_NAME_PREFIX = "TEST-";
    public static final String ROLE_FILTER_NAME = null;
    private static final List<String> TEST_FILTERS = List.of("basic", "anonymous");
    public static final boolean ALLOW_SESSION_CREATION_FLAG = true;
    public static final boolean DISABLED_FLAG = true;
    public static final boolean REQUIRE_SSL_FLAG = true;
    public static final String CLASS_NAME = HtmlLoginFilterChain.class.getName();
    public static final Set<String> HTTP_METHODS = Set.of("GET", "POST");
    public static final Set<String> NEW_HTTP_METHODS = Set.of("GET");
    public static final List<String> PATTERNS = List.of("/test/path1/*", "/test/path2/*");
    public static final int POSITION = 1;
    public static final int NEW_POSITION = 2;
    public static final boolean MATCH_HTTP_METHOD_FLAG = true;
    public static final String NEW_ROLE_FILTER_NAME = null;
    private static final List<String> NEW_TEST_FILTERS = List.of("basic");
    private static final List<String> NEW_PATTERNS = List.of("/test/path1/*");
    private AuthenticationFilterChainRestController controller;

    @Before
    public void oneTimeSetUp() throws Exception {
        this.setValidating(true);
        super.oneTimeSetUp();
        GeoServerSecurityManager securityManager = (GeoServerSecurityManager)applicationContext.getBean(GeoServerSecurityManager.class);
        this.controller = new AuthenticationFilterChainRestController(securityManager);
    }

    public void setUser() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"admin", (Object)"password", Collections.singletonList(new SimpleGrantedAuthority("ROLE_ADMINISTRATOR")));
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
    }

    private void clearUser() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void testListFilterChains() {
        this.setUser();
        try {
            RestWrapper response = this.controller.list();
            List authFilterChainList = (List)Objects.requireNonNull(response).getObject();
            Assert.assertNotNull((Object)authFilterChainList);
            authFilterChainList.stream().filter(chain -> chain.getName().equals(DEFAULT_CHAIN_NAME)).findFirst().ifPresentOrElse(authFilterChain -> Assert.assertEquals((Object)DEFAULT_CHAIN_NAME, (Object)authFilterChain.getName()), () -> Assert.fail((String)"No default message"));
        }
        finally {
            this.clearUser();
        }
    }

    @Test
    public void testViewFilterChain() {
        this.setUser();
        try {
            RestWrapper response = this.controller.view(DEFAULT_CHAIN_NAME);
            AuthFilterChain authFilterChain = (AuthFilterChain)Objects.requireNonNull(response.getObject());
            Assert.assertNotNull((Object)authFilterChain);
            Assert.assertEquals((Object)DEFAULT_CHAIN_NAME, (Object)authFilterChain.getName());
        }
        finally {
            this.clearUser();
        }
    }

    @Test(expected=AuthenticationFilterChainRestController.FilterChainNotFound.class)
    public void testViewFilterChain_Unknown() {
        this.setUser();
        try {
            this.controller.view("UnknownName");
        }
        finally {
            this.clearUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateFilterChain() {
        this.setUser();
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
            AuthFilterChain authFilterChain = AuthenticationFilterChainRestControllerTest.createNewAuthFilterChain();
            this.controller.create(authFilterChain, builder);
            RestWrapper viewResponse = this.controller.view(authFilterChain.getName());
            AuthFilterChain viewFilterChain = (AuthFilterChain)Objects.requireNonNull(viewResponse.getObject());
            Assert.assertNotNull((Object)viewFilterChain);
            Assert.assertEquals((Object)authFilterChain.getName(), (Object)viewFilterChain.getName());
            Assert.assertEquals((Object)authFilterChain.getFilters(), (Object)viewFilterChain.getFilters());
            Assert.assertEquals((Object)authFilterChain.getRoleFilterName(), (Object)viewFilterChain.getRoleFilterName());
            Assert.assertEquals((Object)authFilterChain.getClassName(), (Object)viewFilterChain.getClassName());
            Assert.assertEquals((Object)authFilterChain.getHttpMethods(), (Object)viewFilterChain.getHttpMethods());
            Assert.assertEquals((Object)authFilterChain.getPatterns(), (Object)viewFilterChain.getPatterns());
            Assert.assertEquals((long)authFilterChain.getPosition(), (long)viewFilterChain.getPosition());
            Assert.assertEquals((Object)authFilterChain.isAllowSessionCreation(), (Object)viewFilterChain.isAllowSessionCreation());
            Assert.assertEquals((Object)authFilterChain.isDisabled(), (Object)viewFilterChain.isDisabled());
            Assert.assertEquals((Object)authFilterChain.isRequireSSL(), (Object)viewFilterChain.isRequireSSL());
            Assert.assertEquals((Object)authFilterChain.isMatchHTTPMethod(), (Object)viewFilterChain.isMatchHTTPMethod());
        }
        finally {
            this.clearUser();
        }
    }

    @Test(expected=AuthenticationFilterChainRestController.DuplicateChainName.class)
    public void testCreateFilterChain_duplicateName() {
        this.setUser();
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
            AuthFilterChain authFilterChain = AuthenticationFilterChainRestControllerTest.createNewAuthFilterChain();
            this.controller.create(authFilterChain, builder);
            this.controller.create(authFilterChain, builder);
        }
        finally {
            this.clearUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateFilterChain() {
        this.setUser();
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
            AuthFilterChain authFilterChain = AuthenticationFilterChainRestControllerTest.createNewAuthFilterChain();
            this.controller.create(authFilterChain, builder);
            AuthFilterChain updatedAuthFilterChain = AuthenticationFilterChainRestControllerTest.updateAuthFilterChain(authFilterChain);
            this.controller.update(updatedAuthFilterChain.getName(), updatedAuthFilterChain);
            RestWrapper responseFilterChainWrapper = this.controller.view(updatedAuthFilterChain.getName());
            AuthFilterChain responseFilterChain = (AuthFilterChain)Objects.requireNonNull(responseFilterChainWrapper.getObject());
            Assert.assertEquals((Object)updatedAuthFilterChain.getName(), (Object)responseFilterChain.getName());
            Assert.assertEquals((Object)updatedAuthFilterChain.getFilters(), (Object)responseFilterChain.getFilters());
            Assert.assertEquals((Object)updatedAuthFilterChain.getRoleFilterName(), (Object)responseFilterChain.getRoleFilterName());
            Assert.assertEquals((Object)updatedAuthFilterChain.getClassName(), (Object)responseFilterChain.getClassName());
            Assert.assertEquals((Object)updatedAuthFilterChain.getHttpMethods(), (Object)responseFilterChain.getHttpMethods());
            Assert.assertEquals((Object)updatedAuthFilterChain.getPatterns(), (Object)responseFilterChain.getPatterns());
            Assert.assertEquals((long)updatedAuthFilterChain.getPosition(), (long)responseFilterChain.getPosition());
            Assert.assertEquals((Object)updatedAuthFilterChain.isAllowSessionCreation(), (Object)responseFilterChain.isAllowSessionCreation());
            Assert.assertEquals((Object)updatedAuthFilterChain.isDisabled(), (Object)responseFilterChain.isDisabled());
            Assert.assertEquals((Object)updatedAuthFilterChain.isRequireSSL(), (Object)responseFilterChain.isRequireSSL());
            Assert.assertEquals((Object)updatedAuthFilterChain.isMatchHTTPMethod(), (Object)responseFilterChain.isMatchHTTPMethod());
        }
        finally {
            this.clearUser();
        }
    }

    @Test(expected=AuthenticationFilterChainRestController.BadRequest.class)
    public void testUpdateFilterChain_MismatchName() {
        this.setUser();
        try {
            AuthFilterChain authFilterChain = AuthenticationFilterChainRestControllerTest.createNewAuthFilterChain();
            this.controller.update("unKnown", authFilterChain);
        }
        finally {
            this.clearUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFilterChain() {
        this.setUser();
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
            AuthFilterChain authFilterChain = AuthenticationFilterChainRestControllerTest.createNewAuthFilterChain();
            this.controller.create(authFilterChain, builder);
            this.controller.delete(authFilterChain.getName());
            try {
                this.controller.view(authFilterChain.getName());
                Assert.fail((String)"Expected there to not exist");
            }
            catch (AuthenticationFilterChainRestController.FilterChainNotFound filterChainNotFound) {
                // empty catch block
            }
        }
        finally {
            this.clearUser();
        }
    }

    @Test(expected=AuthenticationFilterChainRestController.NothingToDelete.class)
    public void testDeleteFilterChain_Unknown() {
        this.setUser();
        try {
            this.controller.delete("UnknownName");
        }
        finally {
            this.clearUser();
        }
    }

    @Test(expected=AuthenticationFilterChainRestController.BadRequest.class)
    public void testDeleteFilterChain_cannotBeRemoved() {
        this.setUser();
        try {
            this.controller.delete("webLogout");
        }
        finally {
            this.clearUser();
        }
    }

    public static AuthFilterChain createNewAuthFilterChain() {
        AuthFilterChain authFilterChain = new AuthFilterChain();
        authFilterChain.setName(TEST_CHAIN_NAME_PREFIX + UUID.randomUUID());
        authFilterChain.setRoleFilterName(ROLE_FILTER_NAME);
        authFilterChain.setFilters(TEST_FILTERS);
        authFilterChain.setAllowSessionCreation(true);
        authFilterChain.setDisabled(true);
        authFilterChain.setRequireSSL(true);
        authFilterChain.setClassName(CLASS_NAME);
        authFilterChain.setHttpMethods(HTTP_METHODS);
        authFilterChain.setPatterns(PATTERNS);
        authFilterChain.setPosition(1);
        authFilterChain.setMatchHTTPMethod(true);
        return authFilterChain;
    }

    public static AuthFilterChain updateAuthFilterChain(AuthFilterChain authFilterChain) {
        authFilterChain.setRoleFilterName(NEW_ROLE_FILTER_NAME);
        authFilterChain.setFilters(NEW_TEST_FILTERS);
        authFilterChain.setAllowSessionCreation(false);
        authFilterChain.setDisabled(false);
        authFilterChain.setRequireSSL(false);
        authFilterChain.setHttpMethods(NEW_HTTP_METHODS);
        authFilterChain.setPatterns(NEW_PATTERNS);
        authFilterChain.setPosition(2);
        authFilterChain.setMatchHTTPMethod(false);
        return authFilterChain;
    }
}

