/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RestException;
import org.geoserver.security.GeoServerSecurityManager;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/acl/catalog"})
public class CatalogSecurityController {
    GeoServerSecurityManager getSecurityManager() {
        return (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
    }

    protected void checkUserIsAdmin() {
        if (!this.getSecurityManager().checkAuthenticationForAdminRole()) {
            throw new RestException("Administrative privileges required", HttpStatus.FORBIDDEN);
        }
    }

    @RequestMapping(value={"/reload"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void reloadCatalogSecurity() throws Exception {
        this.checkUserIsAdmin();
        this.getSecurityManager().reload();
    }
}

