/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.Map;
import org.geoserver.rest.security.AbstractAclController;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/acl/layers"})
public class DataAccessController
extends AbstractAclController<DataAccessRule, DataAccessRuleDAO> {
    DataAccessController() {
        super(DataAccessRuleDAO.get());
    }

    @Override
    protected void addRuleToMap(DataAccessRule rule, Map<String, String> map) {
        map.put(rule.getKey(), rule.getValue());
    }

    @Override
    protected String keyFor(DataAccessRule rule) {
        return rule.getKey();
    }

    private String[] parseElements(String path) {
        return path.split("\\s*\\.\\s*");
    }

    @Override
    protected DataAccessRule convertEntryToRule(Map.Entry entry) {
        String[] parts = this.parseElements((String)entry.getKey());
        AccessMode accessMode = AccessMode.getByAlias((String)parts[2]);
        return new DataAccessRule(parts[0], parts[1], accessMode, this.parseRoles((String)entry.getValue()));
    }

    @Override
    protected String validateRuleKey(String ruleKey) {
        String[] elements = this.parseElements(ruleKey);
        if (elements.length != 3) {
            return "Invalid rule " + ruleKey + ", the expected format is workspace.layer.mode=role1,role2,...";
        }
        String workspace = elements[0];
        String layerName = elements[1];
        String modeAlias = elements[2];
        AccessMode mode = AccessMode.getByAlias((String)modeAlias);
        if (mode == null) {
            return "Unknown access mode " + modeAlias + " in " + ruleKey;
        }
        if ("*".equals(workspace) && !"*".equals(layerName)) {
            return "Invalid rule " + ruleKey + ", when namespace is * then also layer must be *.";
        }
        if (mode == AccessMode.ADMIN && !"*".equals(layerName)) {
            return "Invalid rule " + ruleKey + ", admin (a) privileges may only be applied globally to a workspace, layer must be *.";
        }
        return null;
    }

    @Override
    protected String getBasePath() {
        return "/security/acl/layers";
    }
}

