/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.Map;
import org.geoserver.rest.security.AbstractAclController;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/acl/services"})
public class ServiceAccessController
extends AbstractAclController<ServiceAccessRule, ServiceAccessRuleDAO> {
    public ServiceAccessController() {
        super(ServiceAccessRuleDAO.get());
    }

    @Override
    protected void addRuleToMap(ServiceAccessRule rule, Map<String, String> map) {
        map.put(rule.getKey(), rule.getValue());
    }

    @Override
    protected String keyFor(ServiceAccessRule rule) {
        return rule.getKey();
    }

    @Override
    protected ServiceAccessRule convertEntryToRule(Map.Entry<String, String> entry) {
        String[] parts = this.parseElements(entry.getKey());
        return new ServiceAccessRule(parts[0], parts[1], this.parseRoles(entry.getValue()));
    }

    @Override
    protected String validateRuleKey(String ruleKey) {
        String[] elements = this.parseElements(ruleKey);
        if (elements.length != 2) {
            return "Invalid rule " + ruleKey + ", the expected format is service.method=role1,role2,...";
        }
        if ("*".equals(elements[0]) && !"*".equals(elements[1])) {
            return "Invalid rule " + ruleKey + ", when namespace is * then also layer must be *.";
        }
        return null;
    }

    private String[] parseElements(String path) {
        return path.split("\\s*\\.\\s*");
    }

    @Override
    protected String getBasePath() {
        return "/security/acl/services";
    }
}

