/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.IOException;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vfny.geoserver.util.WCSUtils;

public class WCSUtilsTest
extends GeoServerSystemTestSupport {
    private static final double EPS = 1.0E-6;

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefaultRasterLayers();
    }

    @Before
    public void resetLayers() throws IOException {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.TASMANIA_DEM, this.getCatalog());
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.ROTATED_CAD, this.getCatalog());
    }

    @Test
    public void fitEnvelopeOutside() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_DEM));
        ReferencedEnvelope configured = new ReferencedEnvelope(144.96, 146.06, -43.1, -40.9, ci.getCRS());
        ci.setNativeBoundingBox(configured);
        this.getCatalog().save((ResourceInfo)ci);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        ReferencedEnvelope fitted = WCSUtils.fitEnvelope((CoverageInfo)ci, (GridCoverage2DReader)reader);
        Assert.assertEquals((double)144.9583333, (double)fitted.getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)146.0583333, (double)fitted.getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)-43.09999999, (double)fitted.getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)-40.89999999, (double)fitted.getMaximum(1), (double)1.0E-6);
    }

    @Test
    public void fitEnvelopeInside() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_DEM));
        ReferencedEnvelope configured = new ReferencedEnvelope(145.07, 145.93, -42.92, -41.06, ci.getCRS());
        ci.setNativeBoundingBox(configured);
        this.getCatalog().save((ResourceInfo)ci);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        ReferencedEnvelope fitted = WCSUtils.fitEnvelope((CoverageInfo)ci, (GridCoverage2DReader)reader);
        Assert.assertEquals((double)145.0666666, (double)fitted.getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)145.9333333, (double)fitted.getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)-42.91666666, (double)fitted.getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)-41.05833333, (double)fitted.getMaximum(1), (double)1.0E-6);
    }

    @Test
    public void fitEnvelopeTooSmall() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_DEM));
        ReferencedEnvelope configured = new ReferencedEnvelope(145.0, 145.001, -43.0, -42.999, ci.getCRS());
        ci.setNativeBoundingBox(configured);
        this.getCatalog().save((ResourceInfo)ci);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        ReferencedEnvelope fitted = WCSUtils.fitEnvelope((CoverageInfo)ci, (GridCoverage2DReader)reader);
        Assert.assertEquals((double)144.9999999, (double)fitted.getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)145.0083333, (double)fitted.getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)-42.99999999, (double)fitted.getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)-42.99166666, (double)fitted.getMaximum(1), (double)1.0E-6);
    }

    @Test
    public void fitGridGeometry() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_DEM));
        ReferencedEnvelope configured = new ReferencedEnvelope(145.0, 145.001, -43.0, -42.999, ci.getCRS());
        ci.setNativeBoundingBox(configured);
        this.getCatalog().save((ResourceInfo)ci);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        GridGeometry2D fgg = WCSUtils.fitGridGeometry((CoverageInfo)ci, (GridCoverage2DReader)reader);
        GridEnvelope2D gridRange = fgg.getGridRange2D();
        Assert.assertEquals((long)1L, (long)gridRange.getSpan(0));
        Assert.assertEquals((long)1L, (long)gridRange.getSpan(1));
        AffineTransform2D at = (AffineTransform2D)fgg.getGridToCRS(PixelInCell.CELL_CENTER);
        Assert.assertEquals((double)144.9999999, (double)at.getTranslateX(), (double)1.0E-6);
        Assert.assertEquals((double)-42.99166666, (double)at.getTranslateY(), (double)1.0E-6);
        Assert.assertEquals((double)0.00833333333333, (double)at.getScaleX(), (double)1.0E-6);
        Assert.assertEquals((double)-0.00833333333333, (double)at.getScaleY(), (double)1.0E-6);
    }

    @Test
    public void fitGridGeometryRotated() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.ROTATED_CAD));
        ci.setNativeBoundingBox(new ReferencedEnvelope(1402800.0, 1402900.0, 5000000.0, 5000100.0, ci.getNativeCRS()));
        this.getCatalog().save((ResourceInfo)ci);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        GridGeometry2D fgg = WCSUtils.fitGridGeometry((CoverageInfo)ci, (GridCoverage2DReader)reader);
        AffineTransform2D at = (AffineTransform2D)fgg.getGridToCRS(PixelInCell.CELL_CENTER);
        Assert.assertEquals((double)1402800.0, (double)at.getTranslateX(), (double)1.0E-6);
        Assert.assertEquals((double)5000100.0, (double)at.getTranslateY(), (double)1.0E-6);
        Assert.assertEquals((double)0.1128513, (double)at.getScaleX(), (double)1.0E-6);
        Assert.assertEquals((double)-0.1128513, (double)at.getScaleY(), (double)1.0E-6);
        GridEnvelope2D gridRange = fgg.getGridRange2D();
        Assert.assertEquals((long)886L, (long)gridRange.getSpan(0));
        Assert.assertEquals((long)886L, (long)gridRange.getSpan(1));
    }

    @Test
    public void fitReprojected() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_DEM));
        ci.setSRS("EPSG:3857");
        ci.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
        ReferencedEnvelope forcedEnvelope = new ReferencedEnvelope(1.6141326E7, 1.6252645E7, -5311971.0, -5012341.0, CRS.decode((String)"EPSG:3857"));
        ci.setNativeBoundingBox(forcedEnvelope);
        ci.setNativeCRS(CRS.decode((String)"EPSG:3857"));
        this.getCatalog().save((ResourceInfo)ci);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        ReferencedEnvelope envelope = WCSUtils.fitEnvelope((CoverageInfo)ci, (GridCoverage2DReader)reader);
        Assert.assertEquals((Object)forcedEnvelope, (Object)envelope);
        GridGeometry2D fgg = WCSUtils.fitGridGeometry((CoverageInfo)ci, (GridCoverage2DReader)reader);
        AffineTransform2D fg2w = (AffineTransform2D)fgg.getGridToCRS();
        Assert.assertEquals((double)1.6141326E7, (double)fg2w.getTranslateX(), (double)1.0);
        Assert.assertEquals((double)-5012341.0, (double)fg2w.getTranslateY(), (double)1.0);
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:3857"));
        double nativeRes = 0.00833333333333;
        double[] points = new double[]{145.0, -41.0, 145.0 + nativeRes, -41.0 + nativeRes};
        mt.transform(points, 0, points, 0, 2);
        Assert.assertEquals((double)(points[2] - points[0]), (double)fg2w.getScaleX(), (double)20.0);
        Assert.assertEquals((double)(points[3] - points[1]), (double)(-fg2w.getScaleY()), (double)20.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGridSize() throws IOException {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_DEM));
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        GridCoverage2D coverage = reader.read(null);
        try {
            long size = WCSUtils.getReadCoverageSize((GridCoverage2D)coverage);
            long expected = 57600L;
            Assert.assertEquals((long)expected, (long)size);
        }
        finally {
            CoverageCleanerCallback.disposeCoverage((GridCoverage)coverage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGridSizeCropped() throws IOException {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_DEM));
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        GridCoverage2D coverage = reader.read(null);
        ReferencedEnvelope envelope = coverage.getEnvelope2D();
        double cropWidth = envelope.getWidth() / 4.0;
        GridCoverage2D cropped = WCSUtils.crop((GridCoverage2D)coverage, (Bounds)new ReferencedEnvelope(envelope.getCenterX() - cropWidth, envelope.getCenterX() + cropWidth, envelope.getMaxY(), envelope.getMaxY() - envelope.getHeight() * 50.0 / 240.0, ci.getCRS()));
        try {
            long size = WCSUtils.getReadCoverageSize((GridCoverage2D)cropped);
            long expected = 16320L;
            Assert.assertEquals((long)expected, (long)size);
        }
        finally {
            CoverageCleanerCallback.disposeCoverage((GridCoverage)cropped);
            CoverageCleanerCallback.disposeCoverage((GridCoverage)coverage);
        }
    }
}

