/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.wcs.test.CoverageTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WCSTestSupport
extends CoverageTestSupport {
    protected static XpathEngine xpath;
    protected static final boolean IS_WINDOWS;
    protected static final Schema WCS10_GETCAPABILITIES_SCHEMA;
    protected static final Schema WCS10_GETCOVERAGE_SCHEMA;
    protected static final Schema WCS10_DESCRIBECOVERAGE_SCHEMA;

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpRasterLayer(WATTEMP, "watertemp.zip", null, null, TestData.class);
        testData.setUpRasterLayer(TIMERANGES, "timeranges.zip", null, null, TestData.class);
        testData.setupIAULayers(true, false);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wcs", "http://www.opengis.net/wcs");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xpath = XMLUnit.newXpathEngine();
    }

    protected boolean isMemoryCleanRequired() {
        return IS_WINDOWS;
    }

    protected String checkOws11Exception(Document dom) throws Exception {
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"1.2.0", (Object)dom.getFirstChild().getAttributes().getNamedItem("version").getNodeValue());
        XMLAssert.assertXpathEvaluatesTo((String)"1.2.0", (String)"/ServiceExceptionReport/@version", (Document)dom);
        Node root = xpath.getMatchingNodes("/ServiceExceptionReport", dom).item(0);
        Assert.assertNotNull((Object)root);
        NodeList nodes = dom.getElementsByTagName("ows:ExceptionText");
        if (nodes.getLength() > 0) {
            return nodes.item(0).getNodeValue();
        }
        return null;
    }

    protected void setupRasterDimension(QName layer, String metadata, DimensionPresentation presentation, Double resolution) {
        CoverageInfo info = this.getCatalog().getCoverageByName(layer.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(presentation);
        if (resolution != null) {
            di.setResolution(BigDecimal.valueOf(resolution));
        }
        info.getMetadata().put(metadata, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void checkGeotiffResponse(MockHttpServletResponse response, ThrowingConsumer<GridCoverage2D> consumer) throws Exception {
        try (MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(new ByteArrayInputStream(response.getContentAsByteArray()));){
            GridCoverage2D coverage = new GeoTiffReader((Object)stream).read(null);
            consumer.accept(coverage);
        }
    }

    static {
        SchemaFactory factory;
        try {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            WCS10_GETCAPABILITIES_SCHEMA = factory.newSchema(new File("./schemas/wcs/1.0.0/wcsCapabilities.xsd"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse the WCS 1.0.0 schemas", e);
        }
        try {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            WCS10_GETCOVERAGE_SCHEMA = factory.newSchema(new File("./schemas/wcs/1.0.0/getCoverage.xsd"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse the WCS 1.0.0 schemas", e);
        }
        try {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            WCS10_DESCRIBECOVERAGE_SCHEMA = factory.newSchema(new File("./schemas/wcs/1.0.0/describeCoverage.xsd"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse the WCS 1.0.0 schemas", e);
        }
        boolean windows = false;
        try {
            windows = System.getProperty("os.name").matches(".*Windows.*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_WINDOWS = windows;
    }

    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

