/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml;

import java.io.Reader;
import java.io.StringReader;
import net.opengis.gml.GridType;
import net.opengis.wcs10.AxisSubsetType;
import net.opengis.wcs10.GetCoverageType;
import net.opengis.wcs10.IntervalType;
import net.opengis.wcs10.RangeSubsetType;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geoserver.wcs.xml.v1_0_0.WcsXmlReader;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.GeneralBounds;
import org.geotools.wcs.WCSConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vfny.geoserver.wcs.WcsException;

public class GetCoverageXmlParserTest
extends WCSTestSupport {
    private WCSConfiguration configuration;
    private WcsXmlReader reader;

    @Before
    public void setUp() {
        this.configuration = new WCSConfiguration();
        this.reader = new WcsXmlReader("GetCoverage", "1.0.0", this.configuration, EntityResolverProvider.RESOLVE_DISABLED_PROVIDER);
    }

    @Test
    public void testInvalid() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<GetCoverage service=\"WCS\" version=\"1.0.0\"  xmlns=\"http://www.opengis.net/wcs\"   xmlns:nurc=\"http://www.nurc.nato.int\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"   xsi:schemaLocation=\"http://www.opengis.net/wcs schemas/wcs/1.0.0/getCoverage.xsd\"> <sourceCoverage>nurc:Pk50095</sourceCoverage></GetCoverage>";
        try {
            GetCoverageType cov = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
            Assert.fail((String)"This request is not valid!!!");
        }
        catch (WcsException wcsException) {
            // empty catch block
        }
    }

    @Test
    public void testBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<GetCoverage service=\"WCS\" version=\"1.0.0\"  xmlns=\"http://www.opengis.net/wcs\"   xmlns:nurc=\"http://www.nurc.nato.int\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"   xsi:schemaLocation=\"http://www.opengis.net/wcs schemas/wcs/1.0.0/getCoverage.xsd\">  <sourceCoverage>nurc:Pk50095</sourceCoverage>    <domainSubset>      <spatialSubset>        <gml:Envelope srsName=\"EPSG:32633\">          <gml:pos>347649.93086859107 5176214.082539256</gml:pos>          <gml:pos>370725.976428591 5196961.352859256</gml:pos>        </gml:Envelope>        <gml:Grid dimension=\"2\" srsName=\"EPSG:4326\">          <gml:limits>            <gml:GridEnvelope>              <gml:low>0 0</gml:low>              <gml:high>545 490</gml:high>            </gml:GridEnvelope>          </gml:limits>          <gml:axisName>Lon</gml:axisName>          <gml:axisName>Lat</gml:axisName>        </gml:Grid>      </spatialSubset>    </domainSubset>    <output>      <crs>EPSG:4326</crs>      <format>TIFF</format>    </output></GetCoverage>";
        GetCoverageType gc = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        Assert.assertEquals((Object)"WCS", (Object)gc.getService());
        Assert.assertEquals((Object)"1.0.0", (Object)gc.getVersion());
        Assert.assertEquals((Object)"nurc:Pk50095", (Object)gc.getSourceCoverage());
        GeneralBounds envelope = (GeneralBounds)gc.getDomainSubset().getSpatialSubset().getEnvelope().get(0);
        Assert.assertEquals((Object)"EPSG:32633", (Object)ResourcePool.lookupIdentifier((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem(), (boolean)true));
        Assert.assertEquals((double)347649.93086859107, (double)envelope.getLowerCorner().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)5176214.082539256, (double)envelope.getLowerCorner().getOrdinate(1), (double)0.0);
        Assert.assertEquals((double)370725.976428591, (double)envelope.getUpperCorner().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)5196961.352859256, (double)envelope.getUpperCorner().getOrdinate(1), (double)0.0);
        Assert.assertNotNull((Object)gc.getOutput().getCrs());
        Assert.assertEquals((Object)"EPSG:4326", (Object)gc.getOutput().getCrs().getValue());
        Assert.assertNotNull((Object)gc.getOutput().getFormat());
        Assert.assertEquals((Object)"TIFF", (Object)gc.getOutput().getFormat().getValue());
    }

    @Test
    public void testRangeSubsetKeys() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<GetCoverage service=\"WCS\" version=\"1.0.0\"  xmlns=\"http://www.opengis.net/wcs\"   xmlns:nurc=\"http://www.nurc.nato.int\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"   xsi:schemaLocation=\"http://www.opengis.net/wcs schemas/wcs/1.0.0/getCoverage.xsd\">  <sourceCoverage>nurc:Pk50095</sourceCoverage>    <domainSubset>      <spatialSubset>        <gml:Envelope srsName=\"EPSG:32633\">          <gml:pos>347649.93086859107 5176214.082539256</gml:pos>          <gml:pos>370725.976428591 5196961.352859256</gml:pos>        </gml:Envelope>        <gml:Grid dimension=\"2\" srsName=\"EPSG:4326\">          <gml:limits>            <gml:GridEnvelope>              <gml:low>0 0</gml:low>              <gml:high>545 490</gml:high>            </gml:GridEnvelope>          </gml:limits>          <gml:axisName>Column</gml:axisName>          <gml:axisName>Row</gml:axisName>        </gml:Grid>      </spatialSubset>    </domainSubset>    <rangeSubset>       <axisSubset name=\"Band\">          <interval atomic=\"false\">               <min>1</min>               <max>3</max>               <res>1</res>          </interval>       </axisSubset>    </rangeSubset>    <output>      <crs>EPSG:4326</crs>      <format>TIFF</format>    </output></GetCoverage>";
        GetCoverageType gc = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        Assert.assertEquals((long)1L, (long)gc.getRangeSubset().getAxisSubset().size());
        GridType grid = (GridType)gc.getDomainSubset().getSpatialSubset().getGrid().get(0);
        Assert.assertEquals((Object)grid.getSrsName(), (Object)"EPSG:4326");
        Assert.assertEquals((Object)grid.getAxisName().get(0), (Object)"Column");
        Assert.assertEquals((Object)grid.getAxisName().get(1), (Object)"Row");
        GridEnvelope gridLimits = grid.getLimits();
        Assert.assertEquals((long)0L, (long)gridLimits.getLow(0));
        Assert.assertEquals((long)0L, (long)gridLimits.getLow(1));
        Assert.assertEquals((long)544L, (long)gridLimits.getHigh(0));
        Assert.assertEquals((long)489L, (long)gridLimits.getHigh(1));
        RangeSubsetType rangeSet = gc.getRangeSubset();
        AxisSubsetType axisSubset = (AxisSubsetType)rangeSet.getAxisSubset().get(0);
        Assert.assertEquals((Object)"Band", (Object)axisSubset.getName());
        Assert.assertEquals((long)axisSubset.getSingleValue().size(), (long)0L);
        Assert.assertEquals((long)axisSubset.getInterval().size(), (long)1L);
        IntervalType interval = (IntervalType)axisSubset.getInterval().get(0);
        Assert.assertEquals((Object)"1", (Object)interval.getMin().getValue());
        Assert.assertEquals((Object)"3", (Object)interval.getMax().getValue());
        Assert.assertEquals((Object)"1", (Object)interval.getRes().getValue());
    }
}

