/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.util.List;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.Service;
import org.geoserver.wcs.response.LegacyServiceExceptionHandler;

public class WCS10ServiceExceptionHandler
extends LegacyServiceExceptionHandler {
    static final String WCS10_NAMESPACE = "http://www.opengis.net/wcs";

    public WCS10ServiceExceptionHandler(Service service, GeoServer geoServer) {
        super(service, geoServer);
    }

    public boolean canHandle(Service service, Request request) {
        List supportedVersions;
        if (request.isGet() && "WCS".equalsIgnoreCase(request.getService()) && !"GetCapabilities".equalsIgnoreCase(request.getRequest()) && !(supportedVersions = RequestUtils.getSupportedVersions((String)"WCS")).contains(request.getVersion())) {
            return request.getRawKvp().containsKey("coverage");
        }
        return super.canHandle(service, request) || WCS10_NAMESPACE.equals(request.getNamespace());
    }
}

