/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.vfny.geoserver.wcs.WcsException;

public class CoverageKvpParser
extends KvpParser {
    private Catalog catalog;

    public CoverageKvpParser(Catalog catalog) {
        super("coverage", Collection.class);
        this.setService("wcs");
        this.catalog = catalog;
    }

    public Object parse(String value) throws Exception {
        ArrayList<String> coverages = new ArrayList<String>();
        List identifiers = KvpUtils.readFlat((String)value);
        if (identifiers == null || identifiers.isEmpty()) {
            throw new WcsException("Required paramer, coverage, missing", WcsException.WcsExceptionCode.MissingParameterValue, "coverage");
        }
        for (String coverage : identifiers) {
            LayerInfo layer = this.catalog.getLayerByName(coverage);
            if (layer == null || layer.getType() != PublishedType.RASTER) {
                throw new WcsException("Could not find coverage '" + coverage + "'", WcsException.WcsExceptionCode.InvalidParameterValue, "coverage");
            }
            coverages.add(coverage);
        }
        return coverages;
    }
}

