/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.xml.namespace.QName;
import net.opengis.wcs10.GetCoverageType;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService100;
import org.geoserver.wcs.kvp.Wcs10GetCoverageRequestReader;
import org.geoserver.wcs.responses.GeoTIFFCoverageResponseDelegate;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geoserver.wcs.xml.v1_0_0.WcsXmlReader;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.operation.MultiplyConst;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.wcs.WCSConfiguration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetCoverageTest
extends WCSTestSupport {
    private Wcs10GetCoverageRequestReader kvpreader;
    private WebCoverageService100 service;
    private WCSConfiguration configuration;
    private WcsXmlReader xmlReader;
    private Catalog catalog;
    private static final QName MOSAIC = new QName(MockData.SF_URI, "rasterFilter", MockData.SF_PREFIX);
    private static final QName SPATIO_TEMPORAL = new QName(MockData.SF_URI, "spatio-temporal", MockData.SF_PREFIX);

    @Before
    public void setUp() {
        this.kvpreader = (Wcs10GetCoverageRequestReader)applicationContext.getBean("wcs100GetCoverageRequestReader");
        this.service = (WebCoverageService100)applicationContext.getBean("wcs100ServiceTarget");
        this.configuration = new WCSConfiguration();
        this.catalog = (Catalog)applicationContext.getBean("catalog");
        this.xmlReader = new WcsXmlReader("GetCoverage", "1.0.0", this.configuration, EntityResolverProvider.RESOLVE_DISABLED_PROVIDER);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(MOSAIC, "raster-filter-test.zip", null, this.getCatalog());
        testData.addRasterLayer(SPATIO_TEMPORAL, "spatio-temporal.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addRasterLayer(new QName(MockData.WCS_URI, "category", MockData.WCS_PREFIX), "category.tiff", null, this.getCatalog());
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null);
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null);
    }

    private Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.0.0");
        raw.put("request", "GetCoverage");
        return raw;
    }

    @Test
    public void testDomainSubsetRxRy() throws Exception {
        GridCoverage baseCoverage = this.catalog.getCoverageByName(MockData.TASMANIA_BM.getLocalPart()).getGridCoverage(null, null);
        AffineTransform2D expectedTx = (AffineTransform2D)baseCoverage.getGridGeometry().getGridToCRS();
        GeneralBounds originalEnvelope = (GeneralBounds)baseCoverage.getEnvelope();
        GeneralBounds newEnvelope = new GeneralBounds((Bounds)originalEnvelope);
        newEnvelope.setEnvelope(new double[]{originalEnvelope.getMinimum(0), originalEnvelope.getMaximum(1) - originalEnvelope.getSpan(1) / 2.0, originalEnvelope.getMinimum(0) + originalEnvelope.getSpan(0) / 2.0, originalEnvelope.getMaximum(1)});
        MathTransform cornerWorldToGrid = PixelTranslation.translate((MathTransform)expectedTx, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
        GeneralGridEnvelope expectedGridEnvelope = new GeneralGridEnvelope((Bounds)CRS.transform((MathTransform)cornerWorldToGrid.inverse(), (Bounds)newEnvelope), PixelInCell.CELL_CORNER, false);
        StringBuilder envelopeBuilder = new StringBuilder();
        envelopeBuilder.append(newEnvelope.getMinimum(0)).append(",");
        envelopeBuilder.append(newEnvelope.getMinimum(1)).append(",");
        envelopeBuilder.append(newEnvelope.getMaximum(0)).append(",");
        envelopeBuilder.append(newEnvelope.getMaximum(1));
        Map<String, Object> raw = this.baseMap();
        String layerID = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("sourcecoverage", layerID);
        raw.put("version", "1.0.0");
        raw.put("format", "image/geotiff");
        raw.put("BBox", envelopeBuilder.toString());
        raw.put("crs", "EPSG:4326");
        raw.put("resx", Double.toString(expectedTx.getScaleX()));
        raw.put("resy", Double.toString(Math.abs(expectedTx.getScaleY())));
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GridCoverage2D result = (GridCoverage2D)coverages[0];
        Assert.assertEquals((long)1L, (long)coverages.length);
        AffineTransform2D tx = (AffineTransform2D)result.getGridGeometry().getGridToCRS();
        Assert.assertEquals((String)"resx", (double)expectedTx.getScaleX(), (double)tx.getScaleX(), (double)1.0E-6);
        Assert.assertEquals((String)"resx", (double)Math.abs(expectedTx.getScaleY()), (double)Math.abs(tx.getScaleY()), (double)1.0E-6);
        GridEnvelope gridEnvelope = result.getGridGeometry().getGridRange();
        Assert.assertEquals((String)"w", (long)180L, (long)gridEnvelope.getSpan(0));
        Assert.assertEquals((String)"h", (long)180L, (long)gridEnvelope.getSpan(1));
        Assert.assertEquals((String)"grid envelope", (Object)expectedGridEnvelope, (Object)gridEnvelope);
        CoverageCleanerCallback.disposeCoverage((GridCoverage)baseCoverage);
        CoverageCleanerCallback.disposeCoverage((GridCoverage)coverages[0]);
    }

    @Test
    public void testDeferredLoading() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(SPATIO_TEMPORAL);
        raw.put("sourcecoverage", getLayerId);
        raw.put("format", "image/tiff");
        raw.put("BBox", "-90,-180,90,180");
        raw.put("crs", "EPSG:4326");
        raw.put("resx", "0.001");
        raw.put("resy", "0.001");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Assert.assertEquals((long)1L, (long)coverages.length);
        this.assertDeferredLoading(coverages[0].getRenderedImage());
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
        MockHttpServletResponse response = this.getAsServletResponse("wcs?sourcecoverage=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
        Assert.assertTrue((boolean)response.getContentType().startsWith("image/tiff"));
        Document dom = this.getAsDOM("cdf/wcs?sourcecoverage=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testFormatIsCaseSensitive() throws Exception {
        GeoTIFFCoverageResponseDelegate rp = (GeoTIFFCoverageResponseDelegate)GeoServerExtensions.bean(GeoTIFFCoverageResponseDelegate.class);
        for (String format : rp.getOutputFormats()) {
            String mime = rp.getMimeType(format);
            this.testFormatSupported(format, mime);
        }
        String queryString = "wcs?sourcecoverage=" + this.getLayerId(MOSAIC) + "&request=getcoverage&service=wcs&version=1.0.0&format=iMaGe/GeOtIfF&crs=EPSG:4326&bbox=0,0,1,1&width=50&height=60";
        Document dom = this.getAsDOM(queryString);
        this.checkLegacyException(dom, "InvalidParameterValue", "format");
    }

    private void testFormatSupported(String format, String mime) throws Exception {
        String queryString = "wcs?sourcecoverage=" + this.getLayerId(MOSAIC) + "&request=getcoverage&service=wcs&version=1.0.0&format=" + format + "&crs=EPSG:4326&bbox=0,0,1,1&width=50&height=60";
        MockHttpServletResponse response = this.getAsServletResponse(queryString);
        Assert.assertEquals((Object)mime, (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=sf:rasterFilter.tif", (Object)response.getHeader("Content-Disposition"));
        this.checkGeotiffResponse(response, coverage -> {
            Assert.assertEquals((long)50L, (long)coverage.getRenderedImage().getWidth());
            Assert.assertEquals((long)60L, (long)coverage.getRenderedImage().getHeight());
        });
    }

    @Test
    public void testNonExistentCoverage() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
        Document dom = this.getAsDOM("wcs?sourcecoverage=NotThere" + queryString);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"/ServiceExceptionReport/ServiceException/@code", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sourcecoverage", (String)"/ServiceExceptionReport/ServiceException/@locator", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestDisabledResource() throws Exception {
        Catalog catalog = this.getCatalog();
        ResourceInfo tazbm = catalog.getResourceByName(this.getLayerId(MockData.TASMANIA_BM), ResourceInfo.class);
        try {
            tazbm.setEnabled(false);
            catalog.save(tazbm);
            String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
            Document dom = this.getAsDOM("wcs?sourcecoverage=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
            Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        }
        finally {
            tazbm.setEnabled(true);
            catalog.save(tazbm);
        }
    }

    @Test
    public void testLayerQualified() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
        MockHttpServletResponse response = this.getAsServletResponse("wcs/BlueMarble/wcs?sourcecoverage=BlueMarble" + queryString);
        Assert.assertTrue((boolean)response.getContentType().startsWith("image/tiff"));
        String disposition = response.getHeader("Content-Disposition");
        Assert.assertTrue((boolean)disposition.endsWith("BlueMarble.tif"));
        Document dom = this.getAsDOM("wcs/DEM/wcs?sourcecoverage=BlueMarble" + queryString);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    GridCoverage[] executeGetCoverageKvp(Map<String, Object> raw) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.kvpreader.read(this.kvpreader.createRequest(), this.parseKvp(raw), raw);
        return this.service.getCoverage(getCoverage);
    }

    GridCoverage[] executeGetCoverageXml(String request) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.xmlReader.read(null, (Reader)new StringReader(request), null);
        return this.service.getCoverage(getCoverage);
    }

    @Test
    public void testBboxOutsideCoverage() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=-147,44,-146,45&crs=EPSG:4326&width=150&height=150";
        Document dom = this.getAsDOM("wcs?sourcecoverage=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        String error = xpath.evaluate("/ServiceExceptionReport/ServiceException/text()", dom).trim();
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Exception")));
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"/ServiceExceptionReport/ServiceException/@code", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"bbox", (String)"/ServiceExceptionReport/ServiceException/@locator", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInputLimits() throws Exception {
        try {
            this.setInputLimit(1);
            String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
            Document dom = this.getAsDOM("wcs/BlueMarble/wcs?sourcecoverage=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
            String error = xpath.evaluate("/ServiceExceptionReport/ServiceException/text()", dom).trim();
            Assert.assertTrue((boolean)error.matches(".*read too much data.*"));
        }
        finally {
            this.setInputLimit(0);
        }
    }

    @Test
    public void testInputLimitsBounds() throws Exception {
        try {
            String url = "wcs/BlueMarble/wcs?sourcecoverage=" + this.getLayerId(MockData.TASMANIA_BM) + "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0,-43.3,180,-43.29&crs=EPSG:4326&resx=0.00417&resy=0.00417";
            this.setInputLimit(30);
            MockHttpServletResponse response = this.getAsServletResponse(url);
            MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/vnd.ogc.se_xml"));
            this.setInputLimit(400);
            response = this.getAsServletResponse(url);
            MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.containsString((String)"image/tiff"));
        }
        finally {
            this.setInputLimit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutputLimits() throws Exception {
        try {
            this.setOutputLimit(1);
            String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
            Document dom = this.getAsDOM("wcs/BlueMarble/wcs?sourcecoverage=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
            String error = xpath.evaluate("/ServiceExceptionReport/ServiceException/text()", dom).trim();
            Assert.assertTrue((boolean)error.matches(".*generate too much data.*"));
        }
        finally {
            this.setOutputLimit(0);
        }
    }

    @Test
    public void testReproject() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<GetCoverage version=\"1.0.0\" service=\"WCS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wcs\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xsi:schemaLocation=\"http://www.opengis.net/wcs http://schemas.opengis.net/wcs/1.0.0/getCoverage.xsd\">\n  <sourceCoverage>" + this.getLayerId(MockData.TASMANIA_BM) + "</sourceCoverage>\n  <domainSubset>\n    <spatialSubset>\n      <gml:Envelope srsName=\"EPSG:4326\">\n        <gml:pos>146 -45</gml:pos>\n        <gml:pos>147 42</gml:pos>\n      </gml:Envelope>\n      <gml:Grid dimension=\"2\">\n        <gml:limits>\n          <gml:GridEnvelope>\n            <gml:low>0 0</gml:low>\n            <gml:high>150 150</gml:high>\n          </gml:GridEnvelope>\n        </gml:limits>\n        <gml:axisName>x</gml:axisName>\n        <gml:axisName>y</gml:axisName>\n      </gml:Grid>\n    </spatialSubset>\n  </domainSubset>\n  <output>\n    <crs>EPSG:3857</crs>\n    <format>image/geotiff</format>\n  </output>\n</GetCoverage>";
        MockHttpServletResponse response = this.postAsServletResponse("wcs", xml);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        GeoTiffFormat format = new GeoTiffFormat();
        GeoTiffReader reader = format.getReader((Object)this.getBinaryInputStream(response));
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:3857"), (Object)reader.getOriginalEnvelope().getCoordinateReferenceSystem());
    }

    @Test
    public void testEntityExpansion() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE GetCoverage [<!ELEMENT GetCoverage (sourceCoverage) >\n  <!ATTLIST GetCoverage\n            service CDATA #FIXED \"WCS\"\n            version CDATA #FIXED \"1.0.0\"\n            xmlns CDATA #FIXED \"http://www.opengis.net/wcs\">\n  <!ELEMENT sourceCoverage (#PCDATA) >\n  <!ENTITY xxe SYSTEM \"FILE:///file/not/there?.XSD\" >]>\n<GetCoverage version=\"1.0.0\" service=\"WCS\" xmlns=\"http://www.opengis.net/wcs\" >\n  <sourceCoverage>&xxe;</sourceCoverage>\n</GetCoverage>";
        Document dom = this.postAsDOM("wcs", xml);
        String error = xpath.evaluate("//ServiceException", dom);
        Assert.assertTrue((boolean)error.contains("Entity resolution disallowed for "));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE GetCoverage [<!ELEMENT GetCoverage (sourceCoverage) >\n  <!ATTLIST GetCoverage\n            service CDATA #FIXED \"WCS\"\n            version CDATA #FIXED \"1.0.0\"\n            xmlns CDATA #FIXED \"http://www.opengis.net/wcs\">\n  <!ELEMENT sourceCoverage (#PCDATA) >\n  <!ENTITY xxe SYSTEM \"jar:file:///file/not/there?.XSD\" >]>\n<GetCoverage version=\"1.0.0\" service=\"WCS\" xmlns=\"http://www.opengis.net/wcs\" >\n  <sourceCoverage>&xxe;</sourceCoverage>\n</GetCoverage>";
        dom = this.postAsDOM("wcs", xml);
        error = xpath.evaluate("//ServiceException", dom);
        Assert.assertTrue((boolean)error.contains("Entity resolution disallowed for "));
    }

    @Test
    public void testRasterFilterGreen() throws Exception {
        String queryString = "wcs?sourcecoverage=" + this.getLayerId(MOSAIC) + "&request=getcoverage&service=wcs&version=1.0.0&&format=image/tiff&crs=EPSG:4326&bbox=0,0,1,1&CQL_FILTER=location like 'green%25'&width=150&height=150";
        MockHttpServletResponse response = this.getAsServletResponse(queryString);
        RenderedImage image = this.readTiff(response);
        int[] pixel = new int[3];
        image.getData().getPixel(0, 0, pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)255L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
    }

    RenderedImage readTiff(MockHttpServletResponse response) throws IOException {
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        reader.setInput(ImageIO.createImageInputStream(this.getBinaryInputStream(response)));
        return reader.read(0);
    }

    @Test
    public void testTimeFirstPOST() throws Exception {
        String request = this.getWaterTempTimeRequest("2008-10-31T00:00:00.000Z");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        this.checkPixelValue(response, 10, 10, 18.2659999176394);
    }

    @Test
    public void testTimeFirstKVP() throws Exception {
        String queryString = "request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0.237,40.562,14.593,44.558&crs=EPSG:4326&width=25&height=25&time=2008-10-31T00:00:00.000Z&coverage=" + this.getLayerId(WATTEMP);
        MockHttpServletResponse response = this.getAsServletResponse("wcs?" + queryString);
        this.checkPixelValue(response, 10, 10, 18.2659999176394);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeTooMany() throws Exception {
        GeoServer gs = this.getGeoServer();
        WCSInfo wcs = (WCSInfo)gs.getService(WCSInfo.class);
        wcs.setMaxRequestedDimensionValues(2);
        gs.save((ServiceInfo)wcs);
        try {
            String queryString = "request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0.237,40.562,14.593,44.558&crs=EPSG:4326&width=25&height=25&time=2008-10-31/2008-11-31/PT1H&coverage=" + this.getLayerId(WATTEMP);
            MockHttpServletResponse response = this.getAsServletResponse("wcs?" + queryString);
            Assert.assertEquals((Object)"application/vnd.ogc.se_xml;charset=UTF-8", (Object)response.getContentType());
            Document dom = this.dom(response, true);
            String text = this.checkLegacyException(dom, "InvalidParameterValue", "time");
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 2 times"));
        }
        finally {
            wcs.setMaxRequestedDimensionValues(100);
            gs.save((ServiceInfo)wcs);
        }
    }

    @Test
    public void testTimeRangeKVP() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null);
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null);
        String baseUrl = "wcs?request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0.237,40.562,14.593,44.558&crs=EPSG:4326&width=25&height=25&coverage=" + this.getLayerId(TIMERANGES);
        MockHttpServletResponse response = this.getAsServletResponse(baseUrl + "&TIME=2008-11-05T00:00:00.000Z/2008-11-06T12:00:00.000Z");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 13.337999683572);
        Document dom = this.getAsDOM(baseUrl + "&TIME=2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ServiceExceptionReport)", (Document)dom);
        response = this.getAsServletResponse(baseUrl + "&TIME=2008-10-31T12:00:00.000Z/2008-10-31T16:00:00.000Z");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 18.2659999176394);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPixelValue(MockHttpServletResponse response, int x, int y, double value) throws IOException, FileNotFoundException, DataSourceException {
        File tiffFile = File.createTempFile("wcs", "", new File("target"));
        try {
            IOUtils.copy((InputStream)this.getBinaryInputStream(response), (OutputStream)new FileOutputStream(tiffFile));
            GeoTiffReader reader = new GeoTiffReader((Object)tiffFile);
            GridCoverage2D result = reader.read(null);
            double[] pixel = new double[1];
            result.getRenderedImage().getData().getPixel(x, y, pixel);
            Assert.assertEquals((double)value, (double)pixel[0], (double)1.0E-6);
        }
        finally {
            tiffFile.delete();
        }
    }

    @Test
    public void testTimeSecond() throws Exception {
        String request = this.getWaterTempTimeRequest("2008-11-01T00:00:00.000Z");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        this.checkPixelValue(response, 10, 10, 18.2849999185419);
    }

    @Test
    public void testTimeKVPNow() throws Exception {
        String queryString = "request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0.237,40.562,14.593,44.558&crs=EPSG:4326&width=25&height=25&time=now&coverage=" + this.getLayerId(WATTEMP);
        MockHttpServletResponse response = this.getAsServletResponse("wcs?" + queryString);
        this.checkPixelValue(response, 10, 10, 18.2849999185419);
    }

    @Test
    public void testElevationFirst() throws Exception {
        String request = this.getWaterTempElevationRequest("0.0");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 18.2849999185419);
        request = request.replace("ELEVATION", "elevation");
        response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 18.2849999185419);
    }

    @Test
    public void testElevationFirstKVP() throws Exception {
        String queryString = "request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0.237,40.562,14.593,44.558&crs=EPSG:4326&width=25&height=25&elevation=0.0&coverage=" + this.getLayerId(WATTEMP);
        MockHttpServletResponse response = this.getAsServletResponse("wcs?" + queryString);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 18.2849999185419);
    }

    @Test
    public void testElevationSecond() throws Exception {
        String request = this.getWaterTempElevationRequest("100.0");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 13.337999683572);
        request = request.replace("ELEVATION", "elevation");
        response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 13.337999683572);
    }

    @Test
    public void testElevationSecondKVP() throws Exception {
        String queryString = "request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0.237,40.562,14.593,44.558&crs=EPSG:4326&width=25&height=25&elevation=100.0&coverage=" + this.getLayerId(WATTEMP);
        MockHttpServletResponse response = this.getAsServletResponse("wcs?" + queryString);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 13.337999683572);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testElevationTooMany() throws Exception {
        GeoServer gs = this.getGeoServer();
        WCSInfo wcs = (WCSInfo)gs.getService(WCSInfo.class);
        wcs.setMaxRequestedDimensionValues(2);
        gs.save((ServiceInfo)wcs);
        try {
            String queryString = "request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0.237,40.562,14.593,44.558&crs=EPSG:4326&width=25&height=25&elevation=0.0/1000.0/1.0&coverage=" + this.getLayerId(WATTEMP);
            MockHttpServletResponse response = this.getAsServletResponse("wcs?" + queryString);
            Assert.assertEquals((Object)"application/vnd.ogc.se_xml;charset=UTF-8", (Object)response.getContentType());
            Document dom = this.dom(response, true);
            this.print(dom);
            String text = this.checkLegacyException(dom, "InvalidParameterValue", "elevation");
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 2 elevations"));
        }
        finally {
            wcs.setMaxRequestedDimensionValues(100);
            gs.save((ServiceInfo)wcs);
        }
    }

    @Test
    public void testElevationRangeKVP() throws Exception {
        String baseUrl = "wcs?request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=0.237,40.562,14.593,44.558&crs=EPSG:4326&width=25&height=25&coverage=" + this.getLayerId(WATTEMP);
        MockHttpServletResponse response = this.getAsServletResponse(baseUrl + "&ELEVATION=75.0/100.0");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 13.337999683572);
        Document dom = this.getAsDOM(baseUrl + "&ELEVATION=25.0/75.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ServiceExceptionReport)", (Document)dom);
        response = this.getAsServletResponse(baseUrl + "&ELEVATION=0.0/25.0");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        this.checkPixelValue(response, 10, 10, 18.2849999185419);
    }

    private String getWaterTempElevationRequest(String elevation) {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<GetCoverage version=\"1.0.0\" service=\"WCS\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wcs\"\n  xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xsi:schemaLocation=\"http://www.opengis.net/wcs http://schemas.opengis.net/wcs/1.0.0/getCoverage.xsd\">\n  <sourceCoverage>" + this.getLayerId(WATTEMP) + "</sourceCoverage>\n  <domainSubset>\n    <spatialSubset>\n      <gml:Envelope srsName=\"EPSG:4326\">\n        <gml:pos>0.237 40.562</gml:pos>\n        <gml:pos>14.593 44.558</gml:pos>\n      </gml:Envelope>\n      <gml:Grid dimension=\"2\">\n        <gml:limits>\n          <gml:GridEnvelope>\n            <gml:low>0 0</gml:low>\n            <gml:high>25 24</gml:high>\n          </gml:GridEnvelope>\n        </gml:limits>\n        <gml:axisName>x</gml:axisName>\n        <gml:axisName>y</gml:axisName>\n      </gml:Grid>\n    </spatialSubset>\n  </domainSubset>\n  <rangeSubset>\n    <axisSubset name=\"ELEVATION\">\n      <singleValue>" + elevation + "</singleValue>\n    </axisSubset>\n  </rangeSubset>\n  <output>\n    <crs>EPSG:4326</crs>\n    <format>GEOTIFF</format>\n  </output>\n</GetCoverage>";
        return request;
    }

    private String getWaterTempTimeRequest(String date) {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<GetCoverage version=\"1.0.0\" service=\"WCS\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wcs\"\n  xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xsi:schemaLocation=\"http://www.opengis.net/wcs http://schemas.opengis.net/wcs/1.0.0/getCoverage.xsd\">\n  <sourceCoverage>" + this.getLayerId(WATTEMP) + "</sourceCoverage>\n  <domainSubset>\n    <spatialSubset>\n      <gml:Envelope srsName=\"EPSG:4326\">\n        <gml:pos>0.237 40.562</gml:pos>\n        <gml:pos>14.593 44.558</gml:pos>\n      </gml:Envelope>\n      <gml:Grid dimension=\"2\">\n        <gml:limits>\n          <gml:GridEnvelope>\n            <gml:low>0 0</gml:low>\n            <gml:high>25 25</gml:high>\n          </gml:GridEnvelope>\n        </gml:limits>\n        <gml:axisName>x</gml:axisName>\n        <gml:axisName>y</gml:axisName>\n      </gml:Grid>\n    </spatialSubset>\n    <temporalSubset>\n      <gml:timePosition>" + date + "</gml:timePosition>\n    </temporalSubset>\n  </domainSubset>\n  <output>\n    <crs>EPSG:4326</crs>\n    <format>GEOTIFF</format>\n  </output>\n</GetCoverage>";
        return request;
    }

    @Test
    public void testRasterFilterRed() throws Exception {
        String queryString = "wcs?sourcecoverage=" + this.getLayerId(MOSAIC) + "&request=getcoverage&service=wcs&version=1.0.0&format=image/tiff&crs=EPSG:4326&bbox=0,0,1,1&CQL_FILTER=location like 'red%25'&width=150&height=150";
        MockHttpServletResponse response = this.getAsServletResponse(queryString);
        RenderedImage image = this.readTiff(response);
        int[] pixel = new int[3];
        image.getData().getPixel(0, 0, pixel);
        Assert.assertEquals((long)255L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
    }

    @Test
    public void testCategoriesToArray() throws Exception {
        CoverageInfo myCoverage = this.getCatalog().getCoverageByName("category");
        GridCoverage gridCoverage = myCoverage.getGridCoverage(null, null);
        MultiplyConst op = new MultiplyConst();
        ParameterValueGroup param = op.getParameters();
        param.parameter("Source").setValue((Object)gridCoverage);
        param.parameter("constants").setValue((Object)new double[]{0.1});
        boolean exception = false;
        try {
            op.doOperation(param, null);
        }
        catch (Exception e) {
            exception = true;
        }
        Assert.assertFalse((boolean)exception);
    }

    private void setInputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxInputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    private void setOutputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxOutputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCoverageIAU() throws Exception {
        String url = "wcs?request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=-180,-90,180,90&crs=IAU:49900&width=10&height=10&coverage=" + this.getLayerId(SystemTestData.MARS_VIKING);
        MockHttpServletResponse response = this.getAsServletResponse(url);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        File tiffFile = File.createTempFile("wcs", "", new File("target"));
        try {
            IOUtils.copy((InputStream)this.getBinaryInputStream(response), (OutputStream)new FileOutputStream(tiffFile));
            GeoTiffReader reader = new GeoTiffReader((Object)tiffFile);
            GridCoverage2D result = reader.read(null);
            result.dispose(true);
            CoordinateReferenceSystem crs = CRS.decode((String)"IAU:49900");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
        }
        finally {
            tiffFile.delete();
        }
    }
}

