/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.Collection;
import java.util.Map;
import net.opengis.ows10.AcceptVersionsType;
import net.opengis.ows10.Ows10Factory;
import net.opengis.ows10.SectionsType;
import net.opengis.wcs10.GetCapabilitiesType;
import net.opengis.wcs10.Wcs10Factory;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.kvp.EMFKvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geotools.xsd.EMFUtils;

public class Wcs10GetCapabilitiesRequestReader
extends EMFKvpRequestReader {
    public Wcs10GetCapabilitiesRequestReader() {
        super(GetCapabilitiesType.class, (EFactory)Wcs10Factory.eINSTANCE);
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        String value;
        request = super.read(request, kvp, rawKvp);
        if (kvp.containsKey("version")) {
            String ver = (String)kvp.get("version");
            if (ver != null && "".equals(ver)) {
                ver = null;
            }
            GetCapabilitiesType getCapabilities = (GetCapabilitiesType)request;
            getCapabilities.setVersion(ver);
        }
        if (rawKvp.containsKey("acceptVersions")) {
            value = (String)rawKvp.get("acceptVersions");
            AcceptVersionsType acceptVersions = Ows10Factory.eINSTANCE.createAcceptVersionsType();
            Collection versions = (Collection)EMFUtils.get((EObject)acceptVersions, (String)"version");
            versions.addAll(KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER));
            kvp.put("acceptVersions", acceptVersions);
        }
        if (rawKvp.containsKey("sections")) {
            value = (String)rawKvp.get("sections");
            LOGGER.info("Sections: " + value);
            SectionsType sections = Ows10Factory.eINSTANCE.createSectionsType();
            Collection sectionCollection = (Collection)EMFUtils.get((EObject)sections, (String)"section");
            sectionCollection.addAll(KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER));
            kvp.put("sections", sections);
        }
        return request;
    }
}

