/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs.test.WCSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescribeCoverageTest
extends WCSTestSupport {
    public static QName NO_RANGE = new QName(MockData.WCS_URI, "NoRange", MockData.WCS_PREFIX);
    private static final QName SF_RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);
    private static final QName GS_RAIN = new QName(MockData.DEFAULT_URI, "rain", MockData.DEFAULT_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(SF_RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(GS_RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(NO_RANGE, "norange.tiff", null, null, DescribeCoverageTest.class, this.getCatalog());
        CoverageInfo noRange = this.getCatalog().getCoverageByName(this.getLayerId(NO_RANGE));
        CoverageDimensionInfo cdi = (CoverageDimensionInfo)noRange.getDimensions().get(0);
        cdi.setRange(null);
        this.getCatalog().save((ResourceInfo)noRange);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    @Before
    public void revertTasmaniaDem() throws IOException {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(MockData.TASMANIA_DEM, this.getCatalog());
    }

    @Test
    public void testDescribeNoIdentifiers() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1");
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ows:ExceptionReport").getLength());
        Element element = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        Assert.assertEquals((Object)"MissingParameterValue", (Object)element.getAttribute("exceptionCode"));
        Assert.assertEquals((Object)"identifiers", (Object)element.getAttribute("locator"));
    }

    @Test
    public void testDescribeByIdentifiers() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,149,urn:ogc:def:crs:EPSG:6.6:4326";
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        NodeList nodes = xpath.getMatchingNodes("//wcs:CoverageSummary/wcs:Identifier[text()[contains(.,'rain')]]", dom);
        Assert.assertTrue((nodes.getLength() >= 2 ? 1 : 0) != 0);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String identifier = nodes.item(i).getTextContent();
            dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + identifier);
            this.print(dom);
            Assert.assertEquals((Object)"wcs:CoverageDescriptions", (Object)dom.getDocumentElement().getNodeName());
            Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
            Assert.assertEquals((Object)identifier, (Object)dom.getElementsByTagName("wcs:Identifier").item(0).getTextContent());
        }
    }

    @Test
    public void testDescribeUnknownCoverageKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=plop");
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)element.getAttribute("exceptionCode"));
        Assert.assertEquals((Object)"identifiers", (Object)element.getAttribute("locator"));
        Assert.assertTrue((boolean)element.getTextContent().contains("plop"));
    }

    @Test
    public void testDescribeMissingVersion() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&identifiers=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        Assert.assertEquals((Object)"MissingParameterValue", (Object)element.getAttribute("exceptionCode"));
        Assert.assertEquals((Object)"version", (Object)element.getAttribute("locator"));
    }

    @Test
    public void testDescribeUnknownCoverageXml() throws Exception {
        ArrayList errors = new ArrayList();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.1.1\" >\r\n  <wcs:Identifier>plop</wcs:Identifier>\r\n</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs", request, errors);
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)element.getAttribute("exceptionCode"));
        Assert.assertEquals((Object)"identifiers", (Object)element.getAttribute("locator"));
        Assert.assertTrue((boolean)element.getTextContent().contains("plop"));
    }

    @Test
    public void testDescribeDemCoverageKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkDemCoverageDescription(dom);
    }

    @Test
    public void testDescribeNoRangeKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + this.getLayerId(NO_RANGE));
        this.print(dom);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescriptions").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(NO_RANGE), (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Identifier", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Field/wcs:Definition/ows:AnyValue)", (Document)dom);
    }

    @Test
    public void testDescribeDemCoverageXml() throws Exception {
        ArrayList errors = new ArrayList();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.1.1\" >\r\n  <wcs:Identifier>" + this.getLayerId(MockData.TASMANIA_DEM) + "</wcs:Identifier>\r\n</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs", request, errors);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkDemCoverageDescription(dom);
    }

    private void checkDemCoverageDescription(Document dom) throws Exception {
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescriptions").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.TASMANIA_DEM), (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Identifier", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Domain/wcs:SpatialDomain/wcs:GridCRS/wcs:GridOffsets", dom).item(0);
        String[] offsetStrs = gridOffsets.getTextContent().split(" ");
        Assert.assertEquals((long)4L, (long)offsetStrs.length);
        double[] offsets = new double[4];
        for (int i = 0; i < offsetStrs.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrs[i]);
        }
        Assert.assertTrue((offsets[0] > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)offsets[1], (double)0.0);
        Assert.assertEquals((double)0.0, (double)offsets[2], (double)0.0);
        Assert.assertTrue((offsets[3] < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:Field").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:Axis").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:Key").getLength());
    }

    @Test
    public void testDescribeRotatedCoverage() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + this.getLayerId(MockData.ROTATED_CAD));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescriptions").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.ROTATED_CAD), (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Identifier", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Domain/wcs:SpatialDomain/wcs:GridCRS/wcs:GridOffsets", dom).item(0);
        String[] offsetStrs = gridOffsets.getTextContent().split(" ");
        Assert.assertEquals((long)4L, (long)offsetStrs.length);
        double[] offsets = new double[4];
        for (int i = 0; i < offsetStrs.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrs[i]);
        }
        Assert.assertTrue((offsets[0] < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((offsets[1] > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((offsets[2] > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((offsets[3] > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:Field").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:Axis").getLength());
        Assert.assertEquals((long)4L, (long)dom.getElementsByTagName("wcs:Key").getLength());
    }

    @Test
    public void testDescribeImageCoverage() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + this.getLayerId(MockData.TASMANIA_BM));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescriptions").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.TASMANIA_BM), (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Identifier", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Domain/wcs:SpatialDomain/wcs:GridCRS/wcs:GridOffsets", dom).item(0);
        String[] offsetStrs = gridOffsets.getTextContent().split(" ");
        Assert.assertEquals((long)4L, (long)offsetStrs.length);
        double[] offsets = new double[4];
        for (int i = 0; i < offsetStrs.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrs[i]);
        }
        Assert.assertTrue((offsets[0] > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)offsets[1], (double)0.0);
        Assert.assertEquals((double)0.0, (double)offsets[2], (double)0.0);
        Assert.assertTrue((offsets[3] < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:Field").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:Axis").getLength());
        Assert.assertEquals((long)3L, (long)dom.getElementsByTagName("wcs:Key").getLength());
        NodeList keys = dom.getElementsByTagName("wcs:Key");
        for (int i = 0; i < keys.getLength(); ++i) {
            Node key = keys.item(i);
            Assert.assertFalse((boolean)key.getTextContent().contains(" "));
        }
        XMLAssert.assertXpathEvaluatesTo((String)"contents", (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Range/wcs:Field/wcs:Identifier", (Document)dom);
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Document dom = this.getAsDOM("cdf/wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + MockData.TASMANIA_DEM.getLocalPart());
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + MockData.TASMANIA_DEM.getLocalPart());
        Assert.assertEquals((Object)"wcs:CoverageDescriptions", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testMetadataLink() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
        ml.setContent("http://www.geoserver.org/tasmania/dem.xml");
        ml.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(ml);
        catalog.save((ResourceInfo)ci);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + MockData.TASMANIA_DEM.getLocalPart());
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        String xpathBase = "//wcs:CoverageDescription/ows:Metadata";
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)(xpathBase + "/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)(xpathBase + "/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org/tasmania/dem.xml", (String)(xpathBase + "/@xlink:href"), (Document)dom);
    }

    @Test
    public void testMetadataLinksTransormToProxyBaseURL() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
        ml.setContent("/metadata?key=value");
        ml.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(ml);
        catalog.save((ResourceInfo)ci);
        String proxyBaseUrl = this.getGeoServer().getGlobal().getSettings().getProxyBaseUrl();
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + MockData.TASMANIA_DEM.getLocalPart());
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        String xpathBase = "//wcs:CoverageDescription/ows:Metadata";
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)(xpathBase + "/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)(xpathBase + "/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata?key=value"), (String)(xpathBase + "/@xlink:href"), (Document)dom);
    }
}

