/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.test.CoverageTestSupport;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class WCSTestSupport
extends CoverageTestSupport {
    protected static XpathEngine xpath;
    protected static final boolean IS_WINDOWS;
    protected static final Schema WCS11_SCHEMA;

    @Override
    protected WCSInfo getWCS() {
        return (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wcs", "http://www.opengis.net/wcs/1.1.1");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xpath = XMLUnit.newXpathEngine();
    }

    protected boolean isMemoryCleanRequired() {
        return IS_WINDOWS;
    }

    protected Multipart getMultipart(MockHttpServletResponse response) throws MessagingException, IOException {
        MimeMessage body = new MimeMessage((Session)null, (InputStream)this.getBinaryInputStream(response));
        Multipart multipart = (Multipart)body.getContent();
        return multipart;
    }

    static {
        File wcsTestFile = new File("./schemas/wcs/1.1.1/wcsAll.xsd");
        if (!wcsTestFile.exists()) {
            wcsTestFile = new File("wcs1_1/schemas/wcs/1.1.1/wcsAll.xsd");
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            WCS11_SCHEMA = factory.newSchema(wcsTestFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse the WCS 1.1.1 schemas", e);
        }
        boolean windows = false;
        try {
            windows = System.getProperty("os.name").matches(".*Windows.*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_WINDOWS = windows;
    }
}

