/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml;

import java.io.Reader;
import java.io.StringReader;
import net.opengis.wcs11.GetCapabilitiesType;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wcs.xml.v1_1_1.WcsXmlReader;
import org.geotools.wcs.v1_1.WCSConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GetCapabilitiesXmlParserTest {
    private WCSConfiguration configuration;
    private WcsXmlReader reader;

    @Before
    public void setUp() throws Exception {
        this.configuration = new WCSConfiguration();
        this.reader = new WcsXmlReader("GetCapabilities", "1.1.1", this.configuration, EntityResolverProvider.RESOLVE_DISABLED_PROVIDER);
    }

    @Test
    public void testBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
        GetCapabilitiesType cap = (GetCapabilitiesType)this.reader.read(null, (Reader)new StringReader(request), null);
        Assert.assertEquals((Object)"WCS", (Object)cap.getService());
    }

    @Test
    public void testFull() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><ows:AcceptVersions>  <ows:Version>1.0.0</ows:Version></ows:AcceptVersions><ows:Sections>  <ows:Section>Section1</ows:Section></ows:Sections><ows:AcceptFormats>  <ows:OutputFormat>text/xml</ows:OutputFormat></ows:AcceptFormats></wcs:GetCapabilities>";
        GetCapabilitiesType cap = (GetCapabilitiesType)this.reader.read(null, (Reader)new StringReader(request), null);
        Assert.assertEquals((Object)"WCS", (Object)cap.getService());
        Assert.assertEquals((long)1L, (long)cap.getAcceptVersions().getVersion().size());
        Assert.assertEquals((Object)"1.0.0", (Object)cap.getAcceptVersions().getVersion().get(0));
        Assert.assertEquals((long)1L, (long)cap.getSections().getSection().size());
        Assert.assertEquals((Object)"Section1", (Object)cap.getSections().getSection().get(0));
        Assert.assertEquals((long)1L, (long)cap.getAcceptFormats().getOutputFormat().size());
        Assert.assertEquals((Object)"text/xml", (Object)cap.getAcceptFormats().getOutputFormat().get(0));
    }
}

