/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.GetCoverageType;
import net.opengis.wcs11.GridCrsType;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wcs.xml.v1_1_1.WcsXmlReader;
import org.geotools.wcs.v1_1.WCSConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vfny.geoserver.wcs.WcsException;

public class GetCoverageXmlParserTest {
    private WCSConfiguration configuration;
    private WcsXmlReader reader;

    @Before
    public void setUp() throws Exception {
        this.configuration = new WCSConfiguration();
        this.reader = new WcsXmlReader("GetCoverage", "1.1.1", this.configuration, EntityResolverProvider.RESOLVE_DISABLED_PROVIDER);
    }

    @Test
    public void testInvalid() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:GetCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1                        schemas/wcs/1.1.1/wcsAll.xsd\"\r\n  version=\"1.1.1\" >\r\n  <Identifier>wcs:BlueMarble</Identifier>\r\n    <ows:BoundingBox crs=\"urn:ogc:def:crs:EPSG:6.6:4326\">\r\n      <ows:LowerCorner>-90 -180</ows:LowerCorner>\r\n      <ows:UpperCorner>90 180</ows:UpperCorner>\r\n    </ows:BoundingBox>\r\n  <wcs:Output format=\"image/tiff\"/>\r\n</wcs:GetCoverage>";
        try {
            this.reader.read(null, (Reader)new StringReader(request), null);
            Assert.fail((String)"This request is not valid!!!");
        }
        catch (WcsException wcsException) {
            // empty catch block
        }
    }

    @Test
    public void testBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:GetCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1                        schemas/wcs/1.1.1/wcsAll.xsd\"\r\n  version=\"1.1.1\" >\r\n  <ows:Identifier>wcs:BlueMarble</ows:Identifier>\r\n  <wcs:DomainSubset>\r\n    <ows:BoundingBox crs=\"urn:ogc:def:crs:EPSG:6.6:4326\">\r\n      <ows:LowerCorner>-90 -180</ows:LowerCorner>\r\n      <ows:UpperCorner>90 180</ows:UpperCorner>\r\n    </ows:BoundingBox>\r\n  </wcs:DomainSubset>\r\n  <wcs:Output format=\"image/tiff\"/>\r\n</wcs:GetCoverage>";
        GetCoverageType gc = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        Assert.assertEquals((Object)"WCS", (Object)gc.getService());
        Assert.assertEquals((Object)"1.1.1", (Object)gc.getVersion());
        Assert.assertEquals((Object)"wcs:BlueMarble", (Object)gc.getIdentifier().getValue());
        Assert.assertEquals((Object)"urn:ogc:def:crs:EPSG:6.6:4326", (Object)gc.getDomainSubset().getBoundingBox().getCrs());
        Assert.assertEquals(Arrays.asList(-90.0, -180.0), (Object)gc.getDomainSubset().getBoundingBox().getLowerCorner());
        Assert.assertEquals(Arrays.asList(90.0, 180.0), (Object)gc.getDomainSubset().getBoundingBox().getUpperCorner());
        Assert.assertEquals((Object)"image/tiff", (Object)gc.getOutput().getFormat());
        Assert.assertNull((Object)gc.getOutput().getGridCRS());
    }

    @Test
    public void testRangeSubsetKeys() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:GetCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1 schemas/wcs/1.1.1/wcsAll.xsd\"\r\n  version=\"1.1.1\" >\r\n  <ows:Identifier>wcs:BlueMarble</ows:Identifier>\r\n  <wcs:DomainSubset>\r\n    <ows:BoundingBox crs=\"urn:ogc:def:crs:EPSG:6.6:4326\">\r\n      <ows:LowerCorner>-90 -180</ows:LowerCorner>\r\n      <ows:UpperCorner>90 180</ows:UpperCorner>\r\n    </ows:BoundingBox>\r\n  </wcs:DomainSubset>\r\n  <wcs:RangeSubset>\r\n    <wcs:FieldSubset>\r\n      <ows:Identifier>BlueMarble</ows:Identifier>\r\n      <wcs:InterpolationType>bicubic</wcs:InterpolationType>\r\n      <wcs:AxisSubset>\r\n        <wcs:Identifier>Bands</wcs:Identifier>\r\n        <wcs:Key>Red_band</wcs:Key>\r\n      </wcs:AxisSubset>\r\n    </wcs:FieldSubset>\r\n  </wcs:RangeSubset>\r\n  <wcs:Output format=\"image/tiff\"/>\r\n</wcs:GetCoverage>";
        GetCoverageType gc = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        Assert.assertEquals((long)1L, (long)gc.getRangeSubset().getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)gc.getRangeSubset().getFieldSubset().get(0);
        Assert.assertEquals((Object)"BlueMarble", (Object)field.getIdentifier().getValue());
        Assert.assertEquals((Object)"bicubic", (Object)field.getInterpolationType());
        Assert.assertEquals((long)1L, (long)field.getAxisSubset().size());
        AxisSubsetType axis = (AxisSubsetType)field.getAxisSubset().get(0);
        Assert.assertEquals((Object)"Bands", (Object)axis.getIdentifier());
        Assert.assertEquals((long)1L, (long)axis.getKey().size());
        String key = (String)axis.getKey().get(0);
        Assert.assertEquals((Object)"Red_band", (Object)key);
    }

    @Test
    public void testGridCRS() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:GetCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1 schemas/wcs/1.1.1/wcsAll.xsd\"\r\n  version=\"1.1.1\" >\r\n  <ows:Identifier>wcs:BlueMarble</ows:Identifier>\r\n  <wcs:DomainSubset>\r\n    <ows:BoundingBox crs=\"urn:ogc:def:crs:EPSG:6.6:4326\">\r\n      <ows:LowerCorner>-90 -180</ows:LowerCorner>\r\n      <ows:UpperCorner>90 180</ows:UpperCorner>\r\n    </ows:BoundingBox>\r\n  </wcs:DomainSubset>\r\n  <wcs:Output format=\"image/tiff\">\r\n    <wcs:GridCRS>\r\n      <wcs:GridBaseCRS>urn:ogc:def:crs:EPSG:6.6:4326</wcs:GridBaseCRS>\r\n      <wcs:GridType>urn:ogc:def:method:WCS:1.1:2dSimpleGrid</wcs:GridType>\r\n      <wcs:GridOrigin>10 20</wcs:GridOrigin>\r\n      <wcs:GridOffsets>1 2</wcs:GridOffsets>\r\n      <wcs:GridCS>urn:ogc:def:cs:OGC:0.0:Grid2dSquareCS</wcs:GridCS>\r\n    </wcs:GridCRS>\r\n  </wcs:Output>\r\n</wcs:GetCoverage>";
        GetCoverageType gc = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        GridCrsType gridCRS = gc.getOutput().getGridCRS();
        Assert.assertEquals((Object)"urn:ogc:def:crs:EPSG:6.6:4326", (Object)gridCRS.getGridBaseCRS());
        Assert.assertEquals((Object)"urn:ogc:def:method:WCS:1.1:2dSimpleGrid", (Object)gridCRS.getGridType());
        Assert.assertEquals((Object)"urn:ogc:def:cs:OGC:0.0:Grid2dSquareCS", (Object)gridCRS.getGridCS());
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Double[]{10.0, 20.0}, (Object[])((Double[])gridCRS.getGridOrigin())));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Double[]{1.0, 2.0}, (Object[])((Double[])gridCRS.getGridOffsets())));
    }
}

