/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.geom.AffineTransform;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.CodeType;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.DescribeCoverageType;
import net.opengis.wcs11.DomainSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.GetCapabilitiesType;
import net.opengis.wcs11.GetCoverageType;
import net.opengis.wcs11.GridCrsType;
import net.opengis.wcs11.OutputType;
import net.opengis.wcs11.RangeSubsetType;
import net.opengis.wcs11.TimeSequenceType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService111;
import org.geoserver.wcs.kvp.GridCS;
import org.geoserver.wcs.kvp.GridType;
import org.geoserver.wcs.response.DescribeCoverageTransformer;
import org.geoserver.wcs.response.WCSCapsTransformer;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.Filter;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.vfny.geoserver.util.WCSUtils;
import org.vfny.geoserver.wcs.WcsException;

public class DefaultWebCoverageService111
implements WebCoverageService111 {
    Logger LOGGER = Logging.getLogger(DefaultWebCoverageService111.class);
    private Catalog catalog;
    private GeoServer geoServer;
    private CoverageResponseDelegateFinder responseFactory;

    public DefaultWebCoverageService111(GeoServer geoServer, CoverageResponseDelegateFinder responseFactory) {
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
        this.responseFactory = responseFactory;
    }

    @Override
    public WCSInfo getServiceInfo() {
        return (WCSInfo)this.geoServer.getService(WCSInfo.class);
    }

    @Override
    public WCSCapsTransformer getCapabilities(GetCapabilitiesType request) {
        String version;
        ArrayList<String> provided = new ArrayList<String>();
        provided.add("1.1.0");
        provided.add("1.1.1");
        EList accepted = null;
        if (request.getAcceptVersions() != null) {
            accepted = request.getAcceptVersions().getVersion();
        }
        if ("1.1.0".equals(version = RequestUtils.getVersionOws11(provided, accepted)) || "1.1.1".equals(version)) {
            WCSCapsTransformer capsTransformer = new WCSCapsTransformer(this.geoServer);
            capsTransformer.setEncoding(Charset.forName(this.getServiceInfo().getGeoServer().getSettings().getCharset()));
            return capsTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    @Override
    public DescribeCoverageTransformer describeCoverage(DescribeCoverageType request) {
        String version = request.getVersion();
        if ("1.1.0".equals(version) || "1.1.1".equals(version)) {
            WCSInfo wcs = this.getServiceInfo();
            DescribeCoverageTransformer describeTransformer = new DescribeCoverageTransformer(wcs, this.catalog, this.responseFactory);
            describeTransformer.setEncoding(Charset.forName(wcs.getGeoServer().getSettings().getCharset()));
            return describeTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    @Override
    public GridCoverage[] getCoverage(GetCoverageType request) {
        if (this.LOGGER.isLoggable(Level.FINEST)) {
            this.LOGGER.finest(new StringBuffer("execute CoverageRequest response. Called request is: ").append(request).toString());
        }
        WCSInfo wcs = this.getServiceInfo();
        CoverageInfo meta = null;
        GridCoverage2D coverage = null;
        try {
            double pixelSizeY;
            double pixelSizeX;
            GeneralEnvelope intersectionEnvelope;
            boolean reprojectionNeeded;
            boolean hasTime;
            GeneralEnvelope requestedEnvelopeInNativeCRS;
            GeneralEnvelope requestedEnvelope;
            CodeType identifier = request.getIdentifier();
            if (identifier == null) {
                throw new WcsException("Internal error, the coverage identifier must not be null", WcsException.WcsExceptionCode.InvalidParameterValue, "identifier");
            }
            meta = this.catalog.getCoverageByName(identifier.getValue());
            if (meta == null) {
                throw new WcsException("No such coverage: " + request.getIdentifier().getValue());
            }
            this.checkDomainSubset(meta, request.getDomainSubset(), wcs);
            this.checkRangeSubset(meta, request.getRangeSubset());
            this.checkOutput(meta, request.getOutput());
            GridCoverage2DReader reader = (GridCoverage2DReader)meta.getGridCoverageReader(null, WCSUtils.getReaderHints((WCSInfo)wcs));
            GeneralEnvelope originalEnvelope = reader.getOriginalEnvelope();
            BoundingBoxType bbox = request.getDomainSubset().getBoundingBox();
            CoordinateReferenceSystem nativeCRS = originalEnvelope.getCoordinateReferenceSystem();
            if (bbox != null) {
                double[] lowerCorner = new double[bbox.getLowerCorner().size()];
                double[] upperCorner = new double[bbox.getUpperCorner().size()];
                for (int i = 0; i < lowerCorner.length; ++i) {
                    lowerCorner[i] = (Double)bbox.getLowerCorner().get(i);
                    upperCorner[i] = (Double)bbox.getUpperCorner().get(i);
                }
                requestedEnvelope = new GeneralEnvelope(lowerCorner, upperCorner);
                if (bbox.getCrs() == null) {
                    requestedEnvelope.setCoordinateReferenceSystem(nativeCRS);
                    requestedEnvelopeInNativeCRS = requestedEnvelope;
                } else {
                    CoordinateReferenceSystem bboxCRS = CRS.decode((String)bbox.getCrs());
                    requestedEnvelope.setCoordinateReferenceSystem(bboxCRS);
                    if (!CRS.equalsIgnoreMetadata((Object)bboxCRS, (Object)nativeCRS)) {
                        CoordinateOperationFactory of = CRS.getCoordinateOperationFactory((boolean)true);
                        CoordinateOperation co = of.createOperation(bboxCRS, nativeCRS);
                        requestedEnvelopeInNativeCRS = CRS.transform((CoordinateOperation)co, (Envelope)requestedEnvelope);
                    } else {
                        requestedEnvelopeInNativeCRS = new GeneralEnvelope((Envelope)requestedEnvelope);
                    }
                }
            } else {
                requestedEnvelope = requestedEnvelopeInNativeCRS = reader.getOriginalEnvelope();
            }
            GridCrsType gridCRS = request.getOutput().getGridCRS();
            CoordinateReferenceSystem targetCRS = gridCRS == null ? reader.getOriginalEnvelope().getCoordinateReferenceSystem() : CRS.decode((String)gridCRS.getGridBaseCRS());
            MathTransform gridToCRS = reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
            LinkedList<Date> timeValues = new LinkedList<Date>();
            TimeSequenceType temporalSubset = request.getDomainSubset().getTemporalSubset();
            if (temporalSubset != null && temporalSubset.getTimePosition() != null && temporalSubset.getTimePosition().size() > 0) {
                for (Date tp : temporalSubset.getTimePosition()) {
                    timeValues.add(tp);
                }
            } else if (temporalSubset != null && temporalSubset.getTimePeriod() != null && temporalSubset.getTimePeriod().size() > 0) {
                for (Date tp : temporalSubset.getTimePeriod()) {
                    Date beginning = (Date)tp.getBeginPosition();
                    Date ending = (Date)tp.getEndPosition();
                    timeValues.add(beginning);
                    timeValues.add(ending);
                }
            }
            GeneralEnvelope intersectionEnvelopeInSourceCRS = new GeneralEnvelope((Envelope)requestedEnvelopeInNativeCRS);
            intersectionEnvelopeInSourceCRS.intersect((Envelope)originalEnvelope);
            GridGeometry2D requestedGridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, gridToCRS, (Envelope)intersectionEnvelopeInSourceCRS, null);
            ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
            GeneralParameterValue[] readParameters = CoverageUtils.getParameters((ParameterValueGroup)readParametersDescriptor, (Map)meta.getParameters());
            readParameters = readParameters != null ? readParameters : new GeneralParameterValue[]{};
            ParameterValue requestedGridGeometryParam = new DefaultParameterDescriptor(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), GeneralGridGeometry.class, null, (Object)requestedGridGeometry).createValue();
            List parameterDescriptors = readParametersDescriptor.getDescriptor().descriptors();
            ParameterValue time = null;
            boolean bl = hasTime = timeValues.size() > 0;
            if (hasTime) {
                for (GeneralParameterDescriptor pd : parameterDescriptors) {
                    String code = pd.getName().getCode();
                    if (hasTime && code.equalsIgnoreCase("TIME")) {
                        time = (ParameterValue)pd.createValue();
                        time.setValue(timeValues);
                    }
                    if ((!hasTime || time == null) && (!hasTime || time == null)) continue;
                    break;
                }
            }
            int addedParams = 1 + (hasTime ? 1 : 0);
            GeneralParameterValue[] readParametersClone = new GeneralParameterValue[readParameters.length + addedParams--];
            System.arraycopy(readParameters, 0, readParametersClone, 0, readParameters.length);
            readParametersClone[readParameters.length + addedParams--] = requestedGridGeometryParam;
            if (hasTime) {
                readParametersClone[readParameters.length + addedParams--] = time;
            }
            readParameters = readParametersClone;
            WCSUtils.checkInputLimits((WCSInfo)wcs, (CoverageInfo)meta, (GridCoverage2DReader)reader, (GridGeometry2D)requestedGridGeometry);
            Filter filter = WCSUtils.getRequestFilter();
            if (filter != null) {
                readParameters = CoverageUtils.mergeParameter((List)parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)filter, (String[])new String[]{"FILTER", "Filter"});
            }
            if ((coverage = reader.read(readParameters = WCSUtils.replaceParameter((GeneralParameterValue[])readParameters, (Object)Boolean.TRUE, (ParameterDescriptor)AbstractGridFormat.USE_JAI_IMAGEREAD))) == null || !(coverage instanceof GridCoverage2D)) {
                throw new IOException("The requested coverage could not be found.");
            }
            WCSUtils.checkInputLimits((WCSInfo)wcs, (GridCoverage2D)coverage);
            if (!intersectionEnvelopeInSourceCRS.contains((Envelope)coverage.getEnvelope2D(), true)) {
                coverage = WCSUtils.crop((GridCoverage2D)coverage, (Envelope)intersectionEnvelopeInSourceCRS);
            }
            GridCoverage2D bandSelectedCoverage = coverage;
            String interpolationType = null;
            if (request.getRangeSubset() != null) {
                if (request.getRangeSubset().getFieldSubset().size() > 1) {
                    throw new WcsException("Multi field coverages are not supported yet");
                }
                FieldSubsetType field = (FieldSubsetType)request.getRangeSubset().getFieldSubset().get(0);
                interpolationType = field.getInterpolationType();
                if (field.getAxisSubset().size() > 1) {
                    throw new WcsException("Multi axis coverages are not supported yet");
                }
                if (field.getAxisSubset().size() == 1) {
                    List dimensions = meta.getDimensions();
                    HashMap<String, Integer> dimensionMap = new HashMap<String, Integer>();
                    for (int i = 0; i < dimensions.size(); ++i) {
                        String keyName = ((CoverageDimensionInfo)dimensions.get(i)).getName().replace(' ', '_');
                        dimensionMap.put(keyName, i);
                    }
                    AxisSubsetType axisSubset = (AxisSubsetType)field.getAxisSubset().get(0);
                    EList keys = axisSubset.getKey();
                    int[] bands = new int[keys.size()];
                    for (int j = 0; j < bands.length; ++j) {
                        String key = (String)keys.get(j);
                        Integer index = (Integer)dimensionMap.get(key);
                        if (index == null) {
                            throw new WcsException("Unknown field/axis/key combination " + field.getIdentifier().getValue() + "/" + axisSubset.getIdentifier() + "/" + key);
                        }
                        bands[j] = index;
                    }
                    try {
                        bandSelectedCoverage = (GridCoverage2D)WCSUtils.bandSelect((GridCoverage)coverage, (int[])bands);
                    }
                    catch (WcsException e) {
                        throw new WcsException(e.getLocalizedMessage());
                    }
                }
            }
            Interpolation interpolation = Interpolation.getInstance((int)0);
            if (interpolationType != null) {
                if (interpolationType.equalsIgnoreCase("linear") || interpolationType.equalsIgnoreCase("bilinear")) {
                    interpolation = Interpolation.getInstance((int)1);
                } else if (interpolationType.equalsIgnoreCase("cubic") || interpolationType.equalsIgnoreCase("bicubic")) {
                    interpolation = Interpolation.getInstance((int)2);
                } else if (interpolationType.equalsIgnoreCase("nearest")) {
                    interpolation = Interpolation.getInstance((int)0);
                }
            }
            boolean bl2 = reprojectionNeeded = !CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)targetCRS);
            if (reprojectionNeeded) {
                CoordinateOperationFactory of = CRS.getCoordinateOperationFactory((boolean)true);
                CoordinateOperation co = of.createOperation(nativeCRS, targetCRS);
                intersectionEnvelope = CRS.transform((CoordinateOperation)co, (Envelope)intersectionEnvelopeInSourceCRS);
            } else {
                intersectionEnvelope = intersectionEnvelopeInSourceCRS;
            }
            if (gridCRS != null) {
                AffineTransform tx;
                Double[] origin = (Double[])gridCRS.getGridOrigin();
                Double[] offsets = (Double[])gridCRS.getGridOffsets();
                if (origin == null) {
                    origin = new Double[]{0.0, 0.0};
                }
                if (offsets == null) {
                    offsets = this.estimateOffsets(reader, gridCRS, gridToCRS, intersectionEnvelope, reprojectionNeeded);
                }
                if (gridCRS.getGridType().equals(GridType.GT2dSimpleGrid.getXmlConstant())) {
                    tx = new AffineTransform(offsets[0], 0.0, 0.0, offsets[1], origin[0], origin[1]);
                } else if (gridCRS.getGridType().equals(GridType.GT2dGridIn2dCrs.getXmlConstant())) {
                    tx = new AffineTransform(offsets[0], offsets[1], offsets[2], offsets[3], origin[0], origin[1]);
                } else {
                    tx = new AffineTransform(offsets[0], offsets[4], offsets[1], offsets[3], origin[0], origin[1]);
                    if (origin.length != 3 || offsets.length != 6) {
                        throw new WcsException("", WcsException.WcsExceptionCode.InvalidParameterValue, "GridCRS");
                    }
                    int elevationLevels = (int)Math.round(requestedEnvelope.getUpperCorner().getOrdinate(2) - requestedEnvelope.getLowerCorner().getOrdinate(2));
                    if (elevationLevels > 0) {
                        double[] elevations = new double[elevationLevels];
                        elevations[0] = requestedEnvelope.getLowerCorner().getOrdinate(2);
                        elevations[elevationLevels - 1] = requestedEnvelope.getUpperCorner().getOrdinate(2);
                        if (elevationLevels > 2) {
                            int adjustedLevelsNum = elevationLevels - 1;
                            double step = (elevations[elevationLevels - 1] - elevations[0]) / (double)adjustedLevelsNum;
                            for (int i = 1; i < adjustedLevelsNum; ++i) {
                                elevations[i] = elevations[i - 1] + step;
                            }
                        }
                    }
                }
                pixelSizeX = Math.abs(tx.getScaleX());
                pixelSizeY = Math.abs(tx.getScaleY());
                gridToCRS = new AffineTransform2D(tx);
            } else {
                AffineTransform tx;
                Double[] offsets = this.estimateOffsets(reader, gridCRS, gridToCRS, intersectionEnvelope, reprojectionNeeded);
                if (offsets.length == 2) {
                    pixelSizeX = Math.abs(offsets[0]);
                    pixelSizeY = Math.abs(offsets[1]);
                    tx = new AffineTransform(offsets[0], 0.0, 0.0, offsets[1], 0.0, 0.0);
                    gridToCRS = new AffineTransform2D(tx);
                } else {
                    tx = new AffineTransform(offsets[0], offsets[1], offsets[3], offsets[4], 0.0, 0.0);
                    pixelSizeX = Math.abs(XAffineTransform.getScaleX0((AffineTransform)tx));
                    pixelSizeY = Math.abs(XAffineTransform.getScaleY0((AffineTransform)tx));
                    gridToCRS = new AffineTransform2D(tx);
                }
            }
            if (intersectionEnvelope.getSpan(0) < Math.abs(pixelSizeX)) {
                double minX = intersectionEnvelope.getMinimum(0);
                intersectionEnvelope.setRange(0, minX, minX + pixelSizeX);
            }
            if (intersectionEnvelope.getSpan(1) < Math.abs(pixelSizeY)) {
                double minY = intersectionEnvelope.getMinimum(1);
                intersectionEnvelope.setRange(1, minY, minY + pixelSizeY);
            }
            GridGeometry2D destinationGridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, gridToCRS, (Envelope)intersectionEnvelope, null);
            WCSUtils.checkOutputLimits((WCSInfo)wcs, (GridEnvelope2D)destinationGridGeometry.getGridRange2D(), (SampleModel)bandSelectedCoverage.getRenderedImage().getSampleModel());
            boolean sameGridGeometry = bandSelectedCoverage.getGridGeometry().equals((Object)destinationGridGeometry);
            if (reprojectionNeeded || !sameGridGeometry) {
                GridCoverage2D reprojectedCoverage = WCSUtils.resample((GridCoverage2D)bandSelectedCoverage, (CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)targetCRS, (GridGeometry2D)destinationGridGeometry, (Interpolation)interpolation);
                return new GridCoverage[]{reprojectedCoverage};
            }
            return new GridCoverage[]{bandSelectedCoverage};
        }
        catch (Throwable e) {
            if (coverage != null) {
                CoverageCleanerCallback.addCoverages((GridCoverage[])new GridCoverage[]{coverage});
            }
            if (e instanceof WcsException) {
                throw (WcsException)e;
            }
            throw new WcsException(e);
        }
    }

    private Double[] estimateOffsets(GridCoverage2DReader reader, GridCrsType gridCRS, MathTransform gridToCRS, GeneralEnvelope intersectionEnvelope, boolean reprojectionNeeded) {
        Double[] offsets;
        if (!(gridToCRS instanceof AffineTransform2D) && !(gridToCRS instanceof IdentityTransform)) {
            throw new WcsException("Internal error, the coverage we're playing with does not have an affine transform...");
        }
        if (!reprojectionNeeded) {
            if (gridCRS != null) {
                if (gridToCRS instanceof IdentityTransform) {
                    offsets = gridCRS.getGridType().equals(GridType.GT2dSimpleGrid.getXmlConstant()) || gridCRS.getGridType().equals(GridType.GT2dGridIn2dCrs.getXmlConstant()) ? new Double[]{1.0, -1.0} : new Double[]{1.0, 0.0, 0.0, 0.0, -1.0, 0.0};
                } else {
                    AffineTransform2D affine = (AffineTransform2D)gridToCRS;
                    offsets = gridCRS.getGridType().equals(GridType.GT2dSimpleGrid.getXmlConstant()) || gridCRS.getGridType().equals(GridType.GT2dGridIn2dCrs.getXmlConstant()) ? new Double[]{affine.getScaleX(), affine.getScaleY()} : new Double[]{affine.getScaleX(), affine.getShearX(), affine.getShearY(), affine.getScaleY()};
                }
            } else {
                AffineTransform2D at = (AffineTransform2D)gridToCRS;
                offsets = new Double[]{at.getScaleX(), at.getShearX(), 0.0, at.getShearY(), at.getScaleY(), 0.0};
            }
        } else {
            double teWidth = intersectionEnvelope.getSpan(0);
            double teHeight = intersectionEnvelope.getSpan(1);
            double targetRatio = teWidth / teHeight;
            GridEnvelope gr = reader.getOriginalGridRange();
            int targetRasterWidth = gr.getSpan(0);
            int targetRasterHeight = (int)Math.ceil((double)targetRasterWidth / targetRatio);
            double scaleX = teWidth / (double)targetRasterWidth;
            double scaleY = -teHeight / (double)targetRasterHeight;
            offsets = gridCRS == null || gridCRS.getGridType().equals(GridType.GT2dSimpleGrid.getXmlConstant()) || gridCRS.getGridType().equals(GridType.GT2dGridIn2dCrs.getXmlConstant()) ? new Double[]{scaleX, scaleY} : new Double[]{scaleX, 0.0, 0.0, 0.0, scaleY, 0.0};
        }
        return offsets;
    }

    private void checkDomainSubset(CoverageInfo meta, DomainSubsetType domainSubset, WCSInfo wcs) throws Exception {
        BoundingBoxType bbox = domainSubset.getBoundingBox();
        if (bbox == null) {
            return;
        }
        if ("urn:ogc:def:crs:OGC:1.3:CRS84".equals(bbox.getCrs())) {
            bbox.setCrs("EPSG:4326");
        }
        CoordinateReferenceSystem bboxCRs = CRS.decode((String)bbox.getCrs());
        GridCoverage2DReader reader = (GridCoverage2DReader)meta.getGridCoverageReader(null, WCSUtils.getReaderHints((WCSInfo)wcs));
        GeneralEnvelope gridEnvelope = reader.getOriginalEnvelope();
        GeneralEnvelope gridEnvelopeBboxCRS = null;
        if (bboxCRs instanceof GeographicCRS) {
            try {
                CoordinateOperationFactory cof = CRS.getCoordinateOperationFactory((boolean)true);
                CoordinateOperation operation = cof.createOperation(gridEnvelope.getCoordinateReferenceSystem(), bboxCRs);
                gridEnvelopeBboxCRS = CRS.transform((CoordinateOperation)operation, (Envelope)gridEnvelope);
            }
            catch (Exception cof) {
                // empty catch block
            }
        }
        List lower = bbox.getLowerCorner();
        List upper = bbox.getUpperCorner();
        for (int i = 0; i < lower.size(); ++i) {
            if (!((Double)lower.get(i) > (Double)upper.get(i))) continue;
            CoordinateSystemAxis axis = bboxCRs.getCoordinateSystem().getAxis(i);
            if (bboxCRs instanceof GeographicCRS && axis.getDirection() == AxisDirection.EAST) {
                if (gridEnvelopeBboxCRS != null) {
                    double envMax = gridEnvelopeBboxCRS.getMaximum(i);
                    if (envMax >= (Double)lower.get(i)) {
                        upper.set(i, (Double)upper.get(i) + (axis.getMaximumValue() - axis.getMinimumValue()));
                    } else {
                        lower.set(i, (Double)lower.get(i) - (axis.getMaximumValue() - axis.getMinimumValue()));
                    }
                } else {
                    upper.set(i, (Double)upper.get(i) + (axis.getMaximumValue() - axis.getMinimumValue()));
                }
            }
            if (!((Double)lower.get(i) > (Double)upper.get(i))) continue;
            throw new WcsException("illegal bbox, min of dimension " + (i + 1) + ": " + lower.get(i) + " is greater than max of same dimension: " + upper.get(i), WcsException.WcsExceptionCode.InvalidParameterValue, "BoundingBox");
        }
    }

    private void checkOutput(CoverageInfo meta, OutputType output) {
        if (output == null) {
            return;
        }
        String format = output.getFormat();
        String declaredFormat = this.getDeclaredFormat(meta.getSupportedFormats(), format);
        if (declaredFormat == null) {
            throw new WcsException("format " + format + " is not supported for this coverage", WcsException.WcsExceptionCode.InvalidParameterValue, "format");
        }
        GridCrsType gridCRS = output.getGridCRS();
        if (gridCRS != null) {
            String gridBaseCrs = gridCRS.getGridBaseCRS();
            if (gridBaseCrs != null) {
                String actualCRS = null;
                String gridBaseCrsCode = this.extractCode(gridBaseCrs);
                for (String responseCRS : meta.getResponseSRS()) {
                    String code = this.extractCode(responseCRS);
                    if (!code.equalsIgnoreCase(gridBaseCrsCode)) continue;
                    actualCRS = responseCRS;
                }
                if (actualCRS == null) {
                    throw new WcsException("CRS " + gridBaseCrs + " is not among the supported ones for coverage " + meta.getName(), WcsException.WcsExceptionCode.InvalidParameterValue, "GridBaseCrs");
                }
                gridCRS.setGridBaseCRS(gridBaseCrs);
            } else {
                String code = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)meta.getCRS());
                gridCRS.setGridBaseCRS("urn:x-ogc:def:crs:EPSG:" + code);
            }
            String gridTypeValue = gridCRS.getGridType();
            GridType type = GridType.GT2dGridIn2dCrs;
            if (gridTypeValue != null) {
                type = null;
                for (GridType gt : GridType.values()) {
                    if (!gt.getXmlConstant().equalsIgnoreCase(gridTypeValue)) continue;
                    type = gt;
                }
                if (type == null) {
                    throw new WcsException("Unknown grid type " + gridTypeValue, WcsException.WcsExceptionCode.InvalidParameterValue, "GridType");
                }
                if (type == GridType.GT2dGridIn3dCrs) {
                    throw new WcsException("Unsupported grid type " + gridTypeValue, WcsException.WcsExceptionCode.InvalidParameterValue, "GridType");
                }
            }
            gridCRS.setGridType(type.getXmlConstant());
            String gridCS = gridCRS.getGridCS();
            if (gridCS != null && !gridCS.equalsIgnoreCase(GridCS.GCSGrid2dSquare.getXmlConstant())) {
                throw new WcsException("Unsupported grid cs " + gridCS, WcsException.WcsExceptionCode.InvalidParameterValue, "GridCS");
            }
            gridCRS.setGridCS(GridCS.GCSGrid2dSquare.getXmlConstant());
            try {
                CRS.decode((String)gridCRS.getGridBaseCRS());
            }
            catch (Exception e) {
                throw new WcsException("Could not understand crs " + gridCRS.getGridBaseCRS(), WcsException.WcsExceptionCode.InvalidParameterValue, "GridBaseCRS");
            }
            if (!gridCRS.isSetGridOrigin() || gridCRS.getGridOrigin() == null) {
                Object[] origin = new Double[type.getOriginArrayLength()];
                Arrays.fill(origin, (Object)0.0);
                gridCRS.setGridOrigin((Object)origin);
            } else {
                Double[] gridOrigin = (Double[])gridCRS.getGridOrigin();
                if (gridOrigin.length != type.getOriginArrayLength()) {
                    throw new WcsException("Grid origin size (" + gridOrigin.length + ") inconsistent with grid type " + type.getXmlConstant() + " that requires (" + type.getOriginArrayLength() + ")", WcsException.WcsExceptionCode.InvalidParameterValue, "GridOrigin");
                }
                gridCRS.setGridOrigin((Object)gridOrigin);
            }
            Double[] gridOffsets = (Double[])gridCRS.getGridOffsets();
            if (gridOffsets != null) {
                if (type.getOffsetArrayLength() != gridOffsets.length) {
                    throw new WcsException("Invalid offsets lenght, grid type " + type.getXmlConstant() + " requires " + type.getOffsetArrayLength(), WcsException.WcsExceptionCode.InvalidParameterValue, "GridOffsets");
                }
            } else {
                gridCRS.setGridOffsets(null);
            }
        }
    }

    private String extractCode(String srsName) {
        if (srsName.startsWith("http://www.opengis.net/gml/srs/epsg.xml#")) {
            return srsName.substring(40);
        }
        if (srsName.startsWith("urn:")) {
            return srsName.substring(srsName.lastIndexOf(58) + 1);
        }
        if (srsName.startsWith("EPSG:")) {
            return srsName.substring(5);
        }
        return srsName;
    }

    private String getDeclaredFormat(List supportedFormats, String format) {
        for (String sf : supportedFormats) {
            if (sf.equalsIgnoreCase(format)) {
                return sf;
            }
            CoverageResponseDelegate delegate = this.responseFactory.encoderFor(sf);
            if (delegate == null || !delegate.canProduce(format)) continue;
            return sf;
        }
        return null;
    }

    private void checkRangeSubset(CoverageInfo info, RangeSubsetType rangeSubset) {
        if (rangeSubset == null) {
            return;
        }
        if (rangeSubset.getFieldSubset().size() > 1) {
            throw new WcsException("Multi field coverages are not supported yet", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        FieldSubsetType field = (FieldSubsetType)rangeSubset.getFieldSubset().get(0);
        String fieldId = field.getIdentifier().getValue();
        if (!fieldId.equalsIgnoreCase("contents")) {
            throw new WcsException("Unknown field " + fieldId, WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        String interpolation = field.getInterpolationType();
        if (interpolation != null) {
            boolean interpolationSupported = false;
            if (interpolation.equalsIgnoreCase("nearest")) {
                interpolation = "nearest";
            } else if (interpolation.equalsIgnoreCase("cubic") || interpolation.equalsIgnoreCase("bicubic")) {
                interpolation = "bicubic";
            } else if (interpolation.equalsIgnoreCase("linear") || interpolation.equalsIgnoreCase("bilinear")) {
                interpolation = "bilinear";
            }
            for (String method : info.getInterpolationMethods()) {
                if (!method.toLowerCase().startsWith(interpolation)) continue;
                interpolationSupported = true;
                break;
            }
            if (!interpolationSupported) {
                throw new WcsException("The requested Interpolation method is not supported by this Coverage.", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
        }
        if (field.getAxisSubset().size() > 1) {
            throw new WcsException("Multi axis coverages are not supported yet", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        if (field.getAxisSubset().size() == 0) {
            return;
        }
        AxisSubsetType axisSubset = (AxisSubsetType)field.getAxisSubset().get(0);
        String axisId = axisSubset.getIdentifier();
        if (!axisId.equalsIgnoreCase("Bands")) {
            throw new WcsException("Unknown axis " + axisId + " in field " + fieldId, WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        List dimensions = info.getDimensions();
        HashSet<String> dimensionMap = new HashSet<String>();
        for (int i = 0; i < dimensions.size(); ++i) {
            String keyName = ((CoverageDimensionInfo)dimensions.get(i)).getName().replace(' ', '_');
            dimensionMap.add(keyName);
        }
        EList keys = axisSubset.getKey();
        int[] bands = new int[keys.size()];
        for (int j = 0; j < bands.length; ++j) {
            String key = (String)keys.get(j);
            String parsedKey = null;
            for (String dimensionName : dimensionMap) {
                if (!dimensionName.equalsIgnoreCase(key)) continue;
                parsedKey = dimensionName;
                break;
            }
            if (parsedKey == null) {
                throw new WcsException("Unknown field/axis/key combination " + fieldId + "/" + axisSubset.getIdentifier() + "/" + key, WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
            keys.set(j, parsedKey);
        }
    }
}

