/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.opengis.wcs11.DescribeCoverageType;
import net.opengis.wcs11.Wcs111Factory;
import org.eclipse.emf.ecore.EFactory;
import org.geoserver.ows.kvp.EMFKvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.vfny.geoserver.wcs.WcsException;

public class DescribeCoverageKvpRequestReader
extends EMFKvpRequestReader {
    public DescribeCoverageKvpRequestReader() {
        super(DescribeCoverageType.class, (EFactory)Wcs111Factory.eINSTANCE);
        this.filter = new HashSet<String>(Arrays.asList("service", "version", "identifiers"));
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        request = super.read(request, kvp, rawKvp);
        DescribeCoverageType describeCoverage = (DescribeCoverageType)request;
        String identifiersValue = (String)rawKvp.get("identifiers");
        List identifiers = KvpUtils.readFlat((String)identifiersValue);
        if (identifiers == null || identifiers.size() == 0) {
            throw new WcsException("Required paramer, identifiers, missing", WcsException.WcsExceptionCode.MissingParameterValue, "identifiers");
        }
        describeCoverage.getIdentifier().addAll((Collection)identifiers);
        if (!describeCoverage.isSetVersion()) {
            throw new WcsException("Version has not been specified", WcsException.WcsExceptionCode.MissingParameterValue, "version");
        }
        return request;
    }
}

