/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.Collection;
import java.util.Date;
import net.opengis.wcs11.TimeSequenceType;
import net.opengis.wcs11.Wcs111Factory;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.kvp.TimeParser;
import org.geoserver.wcs.WCSInfo;

public class TimeSequenceKvpParser
extends KvpParser {
    private final GeoServer geoServer;

    public TimeSequenceKvpParser(GeoServer geoServer) {
        super("TimeSequence", TimeSequenceType.class);
        this.geoServer = geoServer;
    }

    public Object parse(String value) throws Exception {
        TimeSequenceType timeSequence = Wcs111Factory.eINSTANCE.createTimeSequenceType();
        WCSInfo info = (WCSInfo)this.geoServer.getService(WCSInfo.class);
        int maxRequestedDimensionValues = info.getMaxRequestedDimensionValues();
        TimeParser parser = new TimeParser(maxRequestedDimensionValues);
        Collection timePositions = parser.parse(value);
        for (Date tp : timePositions) {
            timeSequence.getTimePosition().add((Object)tp);
        }
        return timeSequence;
    }
}

