/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs.AbstractGetCoverageTest;
import org.geoserver.wcs.WCSInfo;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;

public class GetCoverageTest
extends AbstractGetCoverageTest {
    private static final QName MOSAIC = new QName(MockData.SF_URI, "rasterFilter", MockData.SF_PREFIX);
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);
    private static final QName SPATIO_TEMPORAL = new QName(MockData.SF_URI, "spatio-temporal", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(MOSAIC, "raster-filter-test.zip", null, this.getCatalog());
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(SPATIO_TEMPORAL, "spatio-temporal.zip", null, null, SystemTestData.class, this.getCatalog());
    }

    @Test
    public void testMissingInterpolation() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:GetCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1                        schemas/wcs/1.1.1/wcsAll.xsd\"\r\n  version=\"1.1.1\" >\r\n  <ows:Identifier>wcs:BlueMarble</ows:Identifier>\r\n  <wcs:DomainSubset>\r\n    <ows:BoundingBox crs=\"urn:ogc:def:crs:EPSG:6.6:4326\">\r\n      <ows:LowerCorner>-90 -180</ows:LowerCorner>\r\n      <ows:UpperCorner>90 180</ows:UpperCorner>\r\n    </ows:BoundingBox>\r\n  </wcs:DomainSubset>\r\n  <wcs:RangeSubset>\n    <wcs:FieldSubset>\n      <ows:Identifier>contents</ows:Identifier>\n      <wcs:InterpolationType></wcs:InterpolationType>\n    </wcs:FieldSubset>\n  </wcs:RangeSubset>  <wcs:Output format=\"image/tiff\"/>\r\n</wcs:GetCoverage>";
        try {
            this.executeGetCoverageXml(request);
            Assert.fail((String)"missing interpolation - should have thrown an exception");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
            Assert.assertEquals((Object)"RangeSubset", (Object)e.getLocator());
            Assert.assertTrue((boolean)e.getMessage().contains("InterpolationMethod"));
        }
    }

    @Test
    public void testKvpBasic() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("store", "false");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Assert.assertEquals((long)1L, (long)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        Assert.assertEquals((Object)CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326"), (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
    }

    @Test
    public void testAntimeridianWorld() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.WORLD);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "175,10,-175,20,urn:ogc:def:crs:OGC:1.3:CRS84");
        raw.put("store", "false");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Assert.assertEquals((long)1L, (long)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        Assert.assertEquals((Object)CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326"), (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
    }

    @Test
    public void testAntimeridianTaz() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("store", "false");
        raw.put("BoundingBox", "145,-80,-175,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "147,-80,-175,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "147.2,-80,147,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "175,-80,147,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "175,-80,150,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
    }

    @Test
    public void testWrongFormatParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "SuperCoolFormat");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        try {
            this.executeGetCoverageKvp(raw);
            Assert.fail((String)"When did we learn to encode SuperCoolFormat?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (Object)e.getCode());
            Assert.assertEquals((Object)"format", (Object)e.getLocator());
        }
    }

    @Test
    public void testDefaultGridOrigin() throws Exception {
        HashMap<String, Object> raw = new HashMap<String, Object>(this.baseMap());
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,149,urn:ogc:def:crs:EPSG:6.6:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        AffineTransform2D tx = (AffineTransform2D)coverages[0].getGridGeometry().getGridToCRS();
        Assert.assertEquals((double)0.0, (double)(tx.getTranslateX() + tx.getScaleX() / 2.0), (double)1.0E-9);
        Assert.assertEquals((double)0.0, (double)(tx.getTranslateY() + tx.getScaleY() / 2.0), (double)1.0E-9);
    }

    @Test
    public void testSpatialSubsetOnePixel() throws Exception {
        HashMap<String, Object> raw = new HashMap<String, Object>(this.baseMap());
        String getLayerId = this.getLayerId(RAIN);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,149,urn:ogc:def:crs:EPSG:6.6:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Bounds envelope = coverages[0].getEnvelope();
        Assert.assertEquals((double)-45.0, (double)envelope.getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)-42.0, (double)envelope.getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)146.0, (double)envelope.getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)149.0, (double)envelope.getMaximum(1), (double)1.0E-6);
    }

    @Test
    public void testWrongGridOrigin() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridOrigin", "12,13,14");
        try {
            this.executeGetCoverageKvp(raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (Object)e.getCode());
            Assert.assertEquals((Object)"GridOrigin", (Object)e.getLocator());
        }
    }

    @Test
    public void testReproject() throws Exception {
        Catalog catalog = this.getCatalog();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        CoverageInfo ci = catalog.getCoverageByName(layerId);
        ci.getResponseSRS().add("EPSG:3857");
        catalog.save((ResourceInfo)ci);
        Map<String, Object> raw = this.baseMap();
        raw.put("identifier", layerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-80,-180,80,180,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridBaseCRS", "EPSG:3857");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Bounds envelope = coverages[0].getEnvelope();
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3857");
        Assert.assertEquals((Object)targetCRS, (Object)envelope.getCoordinateReferenceSystem());
        ReferencedEnvelope nativeBounds = ci.getNativeBoundingBox();
        ReferencedEnvelope expected = nativeBounds.transform(targetCRS, true);
        Assert.assertEquals((long)0L, (long)Double.compare(expected.getMinimum(0), envelope.getMinimum(0)));
        Assert.assertEquals((long)0L, (long)Double.compare(expected.getMaximum(0), envelope.getMaximum(0)));
        Assert.assertEquals((long)0L, (long)Double.compare(expected.getMinimum(1), envelope.getMinimum(1)));
        Assert.assertEquals((long)0L, (long)Double.compare(expected.getMaximum(1), envelope.getMaximum(1)));
        GridEnvelope range = coverages[0].getGridGeometry().getGridRange();
        Assert.assertEquals((long)360L, (long)range.getSpan(0));
        Assert.assertEquals((long)499L, (long)range.getSpan(1));
    }

    @Test
    public void testRotated() throws Exception {
        String layerId = this.getLayerId(MockData.ROTATED_CAD);
        Map<String, Object> raw = this.baseMap();
        raw.put("identifier", layerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "7.7634301664746515,45.14713380418506,7.764350661575157,45.14763319238466,EPSG:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Bounds envelope = coverages[0].getEnvelope();
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"urn:x-ogc:def:crs:EPSG:3003");
        Assert.assertEquals((Object)targetCRS, (Object)envelope.getCoordinateReferenceSystem());
        GridEnvelope range = coverages[0].getGridGeometry().getGridRange();
        Assert.assertEquals((long)482L, (long)range.getSpan(0));
        Assert.assertEquals((long)447L, (long)range.getSpan(1));
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
        MockHttpServletResponse r = this.getAsServletResponse("wcs?identifier=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
        Assert.assertTrue((boolean)r.getContentType().startsWith("multipart/related"));
        Document dom = this.getAsDOM("cdf/wcs?identifier=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testNotExistent() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
        Document dom = this.getAsDOM("wcs?identifier=NotThere" + queryString);
        this.checkOws11Exception(dom, "InvalidParameterValue", "identifier");
    }

    @Test
    public void testLayerQualified() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
        MockHttpServletResponse r = this.getAsServletResponse("wcs/BlueMarble/wcs?identifier=BlueMarble" + queryString);
        Assert.assertTrue((boolean)r.getContentType().startsWith("multipart/related"));
        Document dom = this.getAsDOM("wcs/DEM/wcs?identifier=BlueMarble" + queryString);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testLargerThanData() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs/BlueMarble/wcs?identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326&GridBaseCRS=EPSG:4326");
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        File tiffFile = File.createTempFile("wcs", "", new File("target"));
        IOUtils.copy((InputStream)coveragePart.getInputStream(), (OutputStream)new FileOutputStream(tiffFile));
        GeoTiffReader reader = new GeoTiffReader((Object)tiffFile);
        GridCoverage2D result = reader.read(null);
        this.coverages.add(result);
        CoverageInfo ci = this.getCatalog().getCoverageByName(MockData.TASMANIA_BM.getLocalPart());
        GridCoverage2D original = (GridCoverage2D)ci.getGridCoverage(null, null);
        this.coverages.add(original);
        GridEnvelope originalRange = original.getGridGeometry().getGridRange();
        GridEnvelope actualRange = result.getGridGeometry().getGridRange();
        Assert.assertEquals((long)originalRange.getSpan(0), (long)actualRange.getSpan(0));
        Assert.assertEquals((long)originalRange.getSpan(1), (long)actualRange.getSpan(1));
        ReferencedEnvelope originalEnv = original.getEnvelope2D();
        ReferencedEnvelope actualEnv = result.getEnvelope2D();
        Assert.assertEquals((double)originalEnv.getMinX(), (double)actualEnv.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)originalEnv.getMinY(), (double)actualEnv.getMinY(), (double)1.0E-6);
        Assert.assertEquals((double)originalEnv.getMaxX(), (double)actualEnv.getMaxX(), (double)1.0E-6);
        Assert.assertEquals((double)originalEnv.getMaxY(), (double)actualEnv.getMaxY(), (double)1.0E-6);
        tiffFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInputLimits() throws Exception {
        try {
            this.setInputLimit(1);
            String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
            Document dom = this.getAsDOM("wcs/BlueMarble/wcs?identifier=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
            String error = xpath.evaluate("/ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()", dom);
            Assert.assertTrue((boolean)error.matches(".*read too much data.*"));
        }
        finally {
            this.setInputLimit(0);
        }
    }

    @Test
    public void testInputLimitsBounds() throws Exception {
        try {
            String url = "wcs/BlueMarble/wcs?identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-43.3,0,-43.29,180,urn:ogc:def:crs:EPSG:6.6:4326";
            this.setInputLimit(30);
            MockHttpServletResponse response = this.getAsServletResponse(url);
            Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
            this.setInputLimit(400);
            response = this.getAsServletResponse(url);
            MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.containsString((String)"multipart/related"));
        }
        finally {
            this.setInputLimit(-1);
        }
    }

    @Test
    public void testTimeInputLimitsDefault() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326&timeSequence=2010-01-01/2011-01-01/P1D";
        Document dom = this.getAsDOM("wcs/BlueMarble/wcs?identifier=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
        String text = this.checkOws11Exception(dom, "InvalidParameterValue", "time");
        MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 100 times"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeInputLimitsCustom() throws Exception {
        GeoServer gs = this.getGeoServer();
        WCSInfo wcs = (WCSInfo)gs.getService(WCSInfo.class);
        wcs.setMaxRequestedDimensionValues(2);
        gs.save((ServiceInfo)wcs);
        try {
            String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326&timeSequence=2010-01-01/2011-01-01/P1D";
            Document dom = this.getAsDOM("wcs/BlueMarble/wcs?identifier=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            String text = this.checkOws11Exception(dom, "InvalidParameterValue", "time");
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 2 times"));
        }
        finally {
            wcs.setMaxRequestedDimensionValues(100);
            gs.save((ServiceInfo)wcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutputLimits() throws Exception {
        try {
            this.setOutputLimit(1);
            String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
            Document dom = this.getAsDOM("wcs/wcs?identifier=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
            String error = xpath.evaluate("/ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()", dom);
            Assert.assertTrue((boolean)error.matches(".*generate too much data.*"));
        }
        finally {
            this.setOutputLimit(0);
        }
    }

    @Test
    public void testRasterFilterGreen() throws Exception {
        String queryString = "wcs?identifier=" + this.getLayerId(MOSAIC) + "&request=getcoverage&service=wcs&version=1.1.1&&format=image/tiff&BoundingBox=0,0,1,1,urn:ogc:def:crs:EPSG:6.6:4326&CQL_FILTER=location like 'green%25'";
        MockHttpServletResponse response = this.getAsServletResponse(queryString);
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        reader.setInput(ImageIO.createImageInputStream(coveragePart.getInputStream()));
        BufferedImage image = reader.read(0);
        int[] pixel = new int[3];
        image.getData().getPixel(0, 0, pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)255L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
    }

    @Test
    public void testRasterFilterRed() throws Exception {
        String queryString = "wcs?identifier=" + this.getLayerId(MOSAIC) + "&request=getcoverage&service=wcs&version=1.1.1&&format=image/tiff&BoundingBox=0,0,1,1,urn:ogc:def:crs:EPSG:6.6:4326&CQL_FILTER=location like 'red%25'";
        MockHttpServletResponse response = this.getAsServletResponse(queryString);
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        reader.setInput(ImageIO.createImageInputStream(coveragePart.getInputStream()));
        BufferedImage image = reader.read(0);
        int[] pixel = new int[3];
        image.getData().getPixel(0, 0, pixel);
        Assert.assertEquals((long)255L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
    }

    @Test
    public void testReadNoGridCRS() throws Exception {
        String request = "  <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\"                    xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"                    xmlns:gml=\"http://www.opengis.net/gml\"                   xmlns:ows=\"http://www.opengis.net/ows/1.1\" >\n   <ows:Identifier>" + this.getLayerId(MockData.TASMANIA_DEM) + "   </ows:Identifier>\n            <wcs:DomainSubset>\n              <ows:BoundingBox crs=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n                <ows:LowerCorner>-180.0 -90.0</ows:LowerCorner>\n                <ows:UpperCorner>180.0 90.0</ows:UpperCorner>\n              </ows:BoundingBox>\n            </wcs:DomainSubset>\n            <wcs:Output format=\"image/tiff\"/>\n          </wcs:GetCoverage>";
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        try (ImageInputStream iis = ImageIO.createImageInputStream(coveragePart.getInputStream());){
            reader.setInput(iis);
            reader.read(0);
        }
    }

    @Test
    public void testEntityExpansion() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE wcs:GetCoverage [<!ELEMENT wcs:GetCoverage (ows:Identifier) >\n  <!ATTLIST wcs:GetCoverage\n    service CDATA #FIXED \"WCS\"\n            version CDATA #FIXED \"1.1.1\"\n            xmlns:ows CDATA #FIXED \"http://www.opengis.net/ows/1.1\"\n            xmlns:wcs CDATA #FIXED \"http://www.opengis.net/wcs/1.1.1\">\n  <!ELEMENT ows:Identifier (#PCDATA) >\n  <!ENTITY xxe SYSTEM \"FILE:///file/not/there?.XSD\" >]>\n  <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\"                    xmlns:ows=\"http://www.opengis.net/ows/1.1\"\n                   xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\">\n   <ows:Identifier>&xxe;</ows:Identifier>\n  </wcs:GetCoverage>";
        Document dom = this.postAsDOM("wcs", request);
        String error = xpath.evaluate("//ows:ExceptionText", dom);
        Assert.assertTrue((boolean)error.contains("Entity resolution disallowed for "));
        request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE wcs:GetCoverage [<!ELEMENT wcs:GetCoverage (ows:Identifier) >\n  <!ATTLIST wcs:GetCoverage\n    service CDATA #FIXED \"WCS\"\n            version CDATA #FIXED \"1.1.1\"\n            xmlns:ows CDATA #FIXED \"http://www.opengis.net/ows/1.1\"\n            xmlns:wcs CDATA #FIXED \"http://www.opengis.net/wcs/1.1.1\">\n  <!ELEMENT ows:Identifier (#PCDATA) >\n  <!ENTITY xxe SYSTEM \"jar:file:///file/not/there?.xsd\" >]>\n  <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\"                    xmlns:ows=\"http://www.opengis.net/ows/1.1\"\n                   xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\">\n   <ows:Identifier>&xxe;</ows:Identifier>\n  </wcs:GetCoverage>";
        dom = this.postAsDOM("wcs", request);
        error = xpath.evaluate("//ows:ExceptionText", dom);
        Assert.assertTrue((boolean)error.contains("Entity resolution disallowed for "));
    }

    @Test
    public void testRotatedPost() throws Exception {
        String request = "<GetCoverage xmlns=\"http://www.opengis.net/wcs/1.1.1\" xmlns:gml=\"http://www.opengis.net/gml\"\n             xmlns:ows11=\"http://www.opengis.net/ows/1.1\"\n             xmlns:ows=\"http://www.opengis.net/ows/1.1\"\n             xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n             xmlns:wcs=\"http://schemas.opengis.net/wcs/1.1.1\"\n             xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n             service=\"WCS\"\n             version=\"1.1.1\"\n             xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1 http://schemas.opengis.net/wcs/1.1.1/wcsAll.xsd\">\n   <ows11:Identifier>RotatedCad</ows11:Identifier>\n   <DomainSubset>\n      <ows11:BoundingBox crs=\"urn:ogc:def:crs:OGC:1.3:CRS84\">\n         <ows11:LowerCorner>7.7634301664746515 45.14713380418506</ows11:LowerCorner>\n         <ows11:UpperCorner>7.764350661575157 45.14763319238466</ows11:UpperCorner>\n      </ows11:BoundingBox>\n   </DomainSubset>\n   <Output format=\"image/tiff\"/>\n</GetCoverage>";
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        reader.setInput(ImageIO.createImageInputStream(coveragePart.getInputStream()));
        BufferedImage image = reader.read(0);
        Assert.assertTrue((image.getWidth() < 1000 ? 1 : 0) != 0);
        Assert.assertTrue((image.getHeight() < 1000 ? 1 : 0) != 0);
    }

    @Test
    public void testRotatedGet() throws Exception {
        String request = "wcs?&service=WCS&request=GetCoverage&version=1.1.1&identifier=RotatedCad&BoundingBox=7.7634071540971386,45.14712131948007,7.76437367395267,45.14764567708965,urn:ogc:def:crs:OGC:1.3:CRS84&Format=image/tiff";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        reader.setInput(ImageIO.createImageInputStream(coveragePart.getInputStream()));
        BufferedImage image = reader.read(0);
        Assert.assertTrue((image.getWidth() < 1000 ? 1 : 0) != 0);
        Assert.assertTrue((image.getHeight() < 1000 ? 1 : 0) != 0);
    }

    @Test
    public void testBicubicInterpolation() throws Exception {
        this.testInterpolationMethods("cubic");
    }

    @Test
    public void testBilinearInterpolation() throws Exception {
        this.testInterpolationMethods("linear");
    }

    @Test
    public void testNearestNeighborInterpolation() throws Exception {
        this.testInterpolationMethods("nearest");
    }

    @Test
    public void testUnknownInterpolation() throws Exception {
        this.testInterpolationMethods("unknown");
    }

    @Test
    public void testEmptyInterpolation() throws Exception {
        this.testInterpolationMethods("");
    }

    @Test
    public void testDeferredLoading() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(SPATIO_TEMPORAL);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("store", "false");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Assert.assertEquals((long)1L, (long)coverages.length);
        this.assertDeferredLoading(coverages[0].getRenderedImage());
    }

    private void testInterpolationMethods(String method) throws Exception {
        String queryString = "wcs?identifier=" + this.getLayerId(MOSAIC) + "&request=getcoverage&service=wcs&version=1.1.1&&format=image/tiff&BoundingBox=0,0,1,1,urn:ogc:def:crs:EPSG:6.6:4326&RangeSubset=contents:" + method;
        MockHttpServletResponse response = this.getAsServletResponse(queryString);
        try {
            this.getMultipart(response);
            Assert.assertEquals((long)response.getStatus(), (long)200L);
        }
        catch (ClassCastException e) {
            Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIAUCoverage() throws Exception {
        String layer = this.getLayerId(SystemTestData.MARS_VIKING);
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=1.1.0&BoundingBox=-180,-90,180,90,urn:ogc:def:crs:IAU::49900&identifier=" + layer + "&format=image/tiff");
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.containsString((String)"multipart/related"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        GeoTiffReader reader = new GeoTiffReader((Object)ImageIO.createImageInputStream(coveragePart.getInputStream()));
        GridCoverage2D coverage = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"IAU:49900");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
            coverage = reader.read(null);
            Assert.assertNotNull((Object)coverage);
        }
        finally {
            if (reader != null) {
                try {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                if (coverage != null) {
                    coverage.dispose(true);
                }
            }
        }
    }
}

