/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.util.List;
import org.geoserver.ows.OWS11ServiceExceptionHandler;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.Service;

public class WCS11ServiceExceptionHandler
extends OWS11ServiceExceptionHandler {
    public static final String WCS11_NAMESPACE = "http://www.opengis.net/wcs/1.1.1";

    public WCS11ServiceExceptionHandler(Service service) {
        super(service);
    }

    public boolean canHandle(Service service, Request request) {
        List supportedVersions;
        if (request.isGet() && "WCS".equalsIgnoreCase(request.getService()) && !"GetCapabilities".equalsIgnoreCase(request.getRequest()) && !(supportedVersions = RequestUtils.getSupportedVersions((String)"WCS")).contains(request.getVersion())) {
            return request.getRawKvp().containsKey("identifiers");
        }
        return super.canHandle(service, request) || WCS11_NAMESPACE.equals(request.getNamespace());
    }
}

