/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.io.StringReader;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.RangeSubsetType;
import net.opengis.wcs11.Wcs111Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.wcs.kvp.InterpolationMethod;
import org.geoserver.wcs.kvp.rangesubset.ASTAxisId;
import org.geoserver.wcs.kvp.rangesubset.ASTAxisSubset;
import org.geoserver.wcs.kvp.rangesubset.ASTFieldId;
import org.geoserver.wcs.kvp.rangesubset.ASTFieldSubset;
import org.geoserver.wcs.kvp.rangesubset.ASTInterpolation;
import org.geoserver.wcs.kvp.rangesubset.ASTKey;
import org.geoserver.wcs.kvp.rangesubset.ASTRangeSubset;
import org.geoserver.wcs.kvp.rangesubset.Node;
import org.geoserver.wcs.kvp.rangesubset.RangeSubsetParser;
import org.geoserver.wcs.kvp.rangesubset.RangeSubsetParserVisitor;
import org.geoserver.wcs.kvp.rangesubset.SimpleNode;
import org.vfny.geoserver.wcs.WcsException;

public class RangeSubsetKvpParser
extends KvpParser {
    public RangeSubsetKvpParser() {
        super("RangeSubset", RangeSubsetType.class);
    }

    public Object parse(String value) throws Exception {
        RangeSubsetParser parser = new RangeSubsetParser(new StringReader(value));
        SimpleNode root = parser.RangeSubset();
        RangeSubsetType result = (RangeSubsetType)root.jjtAccept(new RangeSubsetKvpParserVisitor(), null);
        for (Object o : result.getFieldSubset()) {
            FieldSubsetType type = (FieldSubsetType)o;
            String interpolationType = type.getInterpolationType();
            if (interpolationType == null) continue;
            try {
                InterpolationMethod.valueOf(interpolationType);
            }
            catch (IllegalArgumentException e) {
                throw new WcsException("Unknown interpolation method " + interpolationType, WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
        }
        return result;
    }

    private static class RangeSubsetKvpParserVisitor
    implements RangeSubsetParserVisitor {
        Wcs111Factory wcsf = Wcs111Factory.eINSTANCE;
        Ows11Factory owsf = Ows11Factory.eINSTANCE;

        private RangeSubsetKvpParserVisitor() {
        }

        @Override
        public Object visit(SimpleNode node, Object data) {
            throw new UnsupportedOperationException("This method should never be reached");
        }

        @Override
        public Object visit(ASTRangeSubset node, Object data) {
            RangeSubsetType rs = this.wcsf.createRangeSubsetType();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                ASTFieldSubset fs = (ASTFieldSubset)node.jjtGetChild(i);
                FieldSubsetType fst = (FieldSubsetType)fs.jjtAccept(this, data);
                rs.getFieldSubset().add((Object)fst);
            }
            return rs;
        }

        @Override
        public Object visit(ASTFieldSubset node, Object data) {
            FieldSubsetType fs = this.wcsf.createFieldSubsetType();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Node child = node.jjtGetChild(i);
                if (child instanceof ASTFieldId) {
                    CodeType id = this.owsf.createCodeType();
                    id.setValue((String)child.jjtAccept(this, null));
                    fs.setIdentifier(id);
                    continue;
                }
                if (child instanceof ASTInterpolation) {
                    fs.setInterpolationType((String)child.jjtAccept(this, null));
                    continue;
                }
                if (!(child instanceof ASTAxisSubset)) continue;
                fs.getAxisSubset().add(child.jjtAccept(this, null));
            }
            return fs;
        }

        @Override
        public Object visit(ASTAxisSubset node, Object data) {
            AxisSubsetType as = this.wcsf.createAxisSubsetType();
            as.setIdentifier(((SimpleNode)node.jjtGetChild(0)).getContent());
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                as.getKey().add(node.jjtGetChild(i).jjtAccept(this, null));
            }
            return as;
        }

        @Override
        public Object visit(ASTFieldId node, Object data) {
            return node.getContent();
        }

        @Override
        public Object visit(ASTAxisId node, Object data) {
            return node.getContent();
        }

        @Override
        public Object visit(ASTInterpolation node, Object data) {
            return node.getContent();
        }

        @Override
        public Object visit(ASTKey node, Object data) {
            return node.getContent();
        }
    }
}

