/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.GetCoverageType;
import net.opengis.wcs11.RangeSubsetType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wcs.kvp.GetCoverageRequestReader;
import org.geoserver.wcs.kvp.GridCS;
import org.geoserver.wcs.kvp.GridType;
import org.geoserver.wcs.test.WCSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.vfny.geoserver.wcs.WcsException;

public class GetCoverageReaderTest
extends WCSTestSupport {
    static GetCoverageRequestReader reader;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = (Catalog)applicationContext.getBean("catalog");
        reader = new GetCoverageRequestReader(catalog);
    }

    Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.1.1");
        raw.put("request", "GetCoverage");
        return raw;
    }

    @Test
    public void testMissingParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"Hey, format is missing, this should have failed");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"MissingParameterValue", (Object)e.getCode());
        }
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"Hey, format is missing, this should have failed");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"MissingParameterValue", (Object)e.getCode());
        }
        raw.put("format", "image/tiff");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"Hey, boundingBox is missing, this should have failed");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"MissingParameterValue", (Object)e.getCode());
        }
        raw.put("BoundingBox", "-45,146,-42,147");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        }
        catch (WcsException e) {
            Assert.fail((String)"This time all mandatory params where provided?");
            Assert.assertEquals((Object)"MissingParameterValue", (Object)e.getCode());
        }
    }

    @Test
    public void testUnknownCoverageParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = "fairyTales:rumpelstilskin";
        raw.put("identifier", "fairyTales:rumpelstilskin");
        raw.put("format", "SuperCoolFormat");
        raw.put("BoundingBox", "-45,146,-42,147");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"That coverage is not registered???");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (Object)e.getCode());
            Assert.assertEquals((Object)"identifier", (Object)e.getLocator());
        }
    }

    @Test
    public void testWrongStoreParameter() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("store", "BAD_BAD_BAD");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"GetCoverage worked with a bad 'store' parameter");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (Object)e.getCode());
            Assert.assertEquals((Object)"store", (Object)e.getLocator());
        }
    }

    @Test
    public void testBasic() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("store", "false");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)layerId, (Object)getCoverage.getIdentifier().getValue());
        Assert.assertEquals((Object)"image/tiff", (Object)getCoverage.getOutput().getFormat());
        Assert.assertFalse((boolean)getCoverage.getOutput().isStore());
        Assert.assertEquals((Object)"urn:ogc:def:crs:EPSG:6.6:4326", (Object)getCoverage.getOutput().getGridCRS().getGridBaseCRS());
    }

    @Test
    public void testUnsupportedCRS() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:-1000");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)"GridBaseCRS", (Object)e.getLocator());
            Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
        }
    }

    @Test
    public void testGridTypes() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("gridType", GridType.GT2dGridIn2dCrs.getXmlConstant());
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)GridType.GT2dGridIn2dCrs.getXmlConstant(), (Object)getCoverage.getOutput().getGridCRS().getGridType());
        raw.put("gridType", GridType.GT2dSimpleGrid.getXmlConstant());
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)GridType.GT2dSimpleGrid.getXmlConstant(), (Object)getCoverage.getOutput().getGridCRS().getGridType());
        raw.put("gridType", GridType.GT2dSimpleGrid.getXmlConstant().toUpperCase());
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)GridType.GT2dSimpleGrid.getXmlConstant(), (Object)getCoverage.getOutput().getGridCRS().getGridType());
        raw.put("gridType", GridType.GT2dGridIn3dCrs.getXmlConstant());
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (Object)e.getCode());
            Assert.assertEquals((Object)"GridType", (Object)e.getLocator());
        }
        raw.put("gridType", "Hoolabaloola");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (Object)e.getCode());
            Assert.assertEquals((Object)"GridType", (Object)e.getLocator());
        }
    }

    @Test
    public void testGridCS() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("GridCS", GridCS.GCSGrid2dSquare.getXmlConstant());
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)GridCS.GCSGrid2dSquare.getXmlConstant(), (Object)getCoverage.getOutput().getGridCRS().getGridCS());
        raw.put("GridCS", GridCS.GCSGrid2dSquare.getXmlConstant().toUpperCase());
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Assert.assertEquals((Object)GridCS.GCSGrid2dSquare.getXmlConstant(), (Object)getCoverage.getOutput().getGridCRS().getGridCS());
        raw.put("GridCS", "Hoolabaloola");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (Object)e.getCode());
            Assert.assertEquals((Object)"GridCS", (Object)e.getLocator());
        }
    }

    @Test
    public void testGridOrigin() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("GridOrigin", "10.5,-30.2");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Double[] origin = (Double[])getCoverage.getOutput().getGridCRS().getGridOrigin();
        Assert.assertEquals((long)2L, (long)origin.length);
        Assert.assertEquals((long)0L, (long)Double.compare(10.5, origin[0]));
        Assert.assertEquals((long)0L, (long)Double.compare(-30.2, origin[1]));
        raw.put("GridOrigin", "12");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (Object)e.getCode());
            Assert.assertEquals((Object)"GridOrigin", (Object)e.getLocator());
        }
        raw.put("GridOrigin", "12,a");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (Object)e.getCode());
            Assert.assertEquals((Object)"GridOrigin", (Object)e.getLocator());
        }
    }

    @Test
    public void testGridOffsets() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("GridOffsets", "10.5,-30.2");
        raw.put("GridType", GridType.GT2dSimpleGrid.getXmlConstant());
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Double[] offsets = (Double[])getCoverage.getOutput().getGridCRS().getGridOffsets();
        Assert.assertEquals((long)2L, (long)offsets.length);
        Assert.assertEquals((long)0L, (long)Double.compare(10.5, offsets[0]));
        Assert.assertEquals((long)0L, (long)Double.compare(-30.2, offsets[1]));
        raw.put("GridOffsets", "12");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (Object)e.getCode());
            Assert.assertEquals((Object)"GridOffsets", (Object)e.getLocator());
        }
        raw.put("GridOffsets", "12,a");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            Assert.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (Object)e.getCode());
            Assert.assertEquals((Object)"GridOffsets", (Object)e.getLocator());
        }
    }

    @Test
    public void testInterpolationBicubic() throws Exception {
        this.testRangeSubset("cubic");
    }

    @Test
    public void testInterpolationBilinear() throws Exception {
        this.testRangeSubset("linear");
    }

    @Test
    public void testInterpolationNearest() throws Exception {
        this.testRangeSubset("nearest");
    }

    protected Map<String, Object> parseKvp(Map<String, Object> raw) throws Exception {
        HashMap<String, Object> input = new HashMap<String, Object>(raw);
        List errors = KvpUtils.parse(input);
        if (errors != null && !errors.isEmpty()) {
            throw (Exception)errors.get(0);
        }
        return this.caseInsensitiveKvp(input);
    }

    protected <V> Map<String, V> caseInsensitiveKvp(Map<String, V> input) {
        HashMap<String, V> result = new HashMap<String, V>();
        for (String key : input.keySet()) {
            result.put(key.toUpperCase(), input.get(key));
        }
        return new CaseInsensitiveMap(result);
    }

    private void testRangeSubset(String interpolation) throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("rangeSubset", "BlueMarble:" + interpolation + "[Bands[Red_band]]");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        RangeSubsetType rs = getCoverage.getRangeSubset();
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        AxisSubsetType axis = (AxisSubsetType)field.getAxisSubset().get(0);
        EList keys = axis.getKey();
        Assert.assertNotNull((Object)rs);
        Assert.assertEquals((long)1L, (long)rs.getFieldSubset().size());
        Assert.assertEquals((Object)"BlueMarble", (Object)field.getIdentifier().getValue());
        Assert.assertEquals((long)1L, (long)field.getAxisSubset().size());
        Assert.assertEquals((Object)"Bands", (Object)axis.getIdentifier());
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertEquals((Object)"Red_band", keys.get(0));
        Assert.assertEquals((Object)field.getInterpolationType(), (Object)interpolation);
    }
}

