/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.w3c.dom.Document;

public class ResourceAccessManagerWCSTest
extends WCSTestSupport {
    protected static QName WATTEMP = new QName(MockData.SF_URI, "watertemp", MockData.SF_PREFIX);
    protected static final String UNITS = "foot";
    protected static final String UNIT_SYMBOL = "ft";

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wcs2_0/ResourceAccessManagerContext.xml");
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        File security = new File(testData.getDataDirectoryRoot(), "security");
        security.mkdir();
        File users = new File(security, "users.properties");
        Properties props = new Properties();
        props.put("admin", "geoserver,ROLE_ADMINISTRATOR");
        props.put("cite", "cite,ROLE_DUMMY");
        props.store(new FileOutputStream(users), "");
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addUser("cite", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        Catalog catalog = this.getCatalog();
        testData.addRasterLayer(WATTEMP, "watertemp.zip", null, null, SystemTestData.class, catalog);
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, UNITS, UNIT_SYMBOL);
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        CoverageInfo waterTemp = catalog.getCoverageByName(this.getLayerId(WATTEMP));
        tam.putLimits("cite", (CatalogInfo)waterTemp, (AccessLimits)new CoverageAccessLimits(CatalogMode.CHALLENGE, (Filter)Filter.EXCLUDE, null, null));
    }

    @Test
    public void testDescribeWithTimeElevation() throws Exception {
        this.setRequestAuth("cite", "cite");
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=2.0.0&coverageId=sf__watertemp");
        this.print(dom);
        this.checkValidationErrors(dom, ResourceAccessManagerWCSTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__watertemp_td_0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[1]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[1]/gml:timePosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf__watertemp_td_1", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[2]/@gml:id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:TimeDomain/gml:TimeInstant[2]/gml:timePosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/wcsgs:SingleValue)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)UNIT_SYMBOL, (String)"//gmlcov:metadata/gmlcov:Extension/wcsgs:ElevationDomain/@uom", (Document)dom);
    }
}

