/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.referencing.CRS;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.springframework.mock.web.MockHttpServletResponse;

public class ScalingExtentionTest
extends WCSTestSupport {
    private GridCoverage2D sourceCoverage;

    @Before
    public void setup() throws Exception {
        this.sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        GeoServer gs = this.getGeoServer();
        GeoServerInfo gsInfo = gs.getGlobal();
        SettingsInfo settings = gsInfo.getSettings();
        settings.setVerboseExceptions(true);
        gs.save(gsInfo);
    }

    @After
    public void close() {
        try {
            if (this.sourceCoverage != null) {
                this.scheduleForCleaning((GridCoverage)this.sourceCoverage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testScaleAxesByFactorXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageScaleAxesByFactor.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)1260, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)1260, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertNotNull((Object)coverage);
        ScalingExtentionTest.assertEnvelopeEquals((Coverage)this.sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
    }

    @Test
    public void testScaleToSizeXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageScaleToSize.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        if ("application/xml".equals(response.getContentType())) {
            System.out.println("Error message: " + response.getContentAsString());
            Runtime runtime = Runtime.getRuntime();
            System.out.println("Max memory: " + runtime.maxMemory());
            System.out.println("Free memory: " + runtime.freeMemory());
            System.out.println("Total memory: " + runtime.totalMemory());
        }
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)1000, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)1000, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertNotNull((Object)coverage);
        ScalingExtentionTest.assertEnvelopeEquals((Coverage)this.sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
    }

    @Test
    public void testScaleToExtentXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageScaleToExtent.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)200, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)300, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertNotNull((Object)coverage);
        ScalingExtentionTest.assertEnvelopeEquals((Coverage)this.sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
    }

    @Test
    public void testScaleByFactorXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageScaleByFactor.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)900, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)900, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertNotNull((Object)coverage);
        ScalingExtentionTest.assertEnvelopeEquals((Coverage)this.sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
    }
}

