/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opengis.wcs20.GetCoverageType;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.wcs2_0.GetCoverage;
import org.geoserver.wcs2_0.GridCoverageRequest;
import org.geoserver.wcs2_0.WCSEnvelope;
import org.geoserver.wcs2_0.response.WCSDimensionsValueParser;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.SortByImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WCSDefaultValuesHelper {
    FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private String coverageName;
    private GridCoverage2DReader reader;
    private GetCoverageType request;
    private ReaderDimensionsAccessor accessor;
    private static final WCSDimensionsValueParser PARSER = new WCSDimensionsValueParser();

    public WCSDefaultValuesHelper(GridCoverage2DReader reader, ReaderDimensionsAccessor accessor, GetCoverageType request, String coverageName) throws IOException {
        this.accessor = accessor == null ? new ReaderDimensionsAccessor(reader) : accessor;
        this.reader = reader;
        this.request = request;
        this.coverageName = coverageName;
    }

    public void setDefaults(GridCoverageRequest subsettingRequest) throws IOException {
        String format = this.request.getFormat();
        if (format != null && !GetCoverage.formatSupportMDOutput(format)) {
            if (!(this.reader instanceof StructuredGridCoverage2DReader)) {
                this.setStandardReaderDefaults(subsettingRequest);
            } else {
                this.setDefaultsFromStructuredReader(subsettingRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverageRequest setDefaultsFromStructuredReader(GridCoverageRequest subsettingRequest) throws IOException {
        boolean defaultCustomDimensionsNeeded;
        DateRange temporalSubset = subsettingRequest.getTemporalSubset();
        NumberRange<?> elevationSubset = subsettingRequest.getElevationSubset();
        Map<String, List<Object>> dimensionsSubset = subsettingRequest.getDimensionsSubset();
        WCSEnvelope envelopeSubset = subsettingRequest.getSpatialSubset();
        Filter originalFilter = subsettingRequest.getFilter();
        int specifiedDimensionsSubset = dimensionsSubset != null ? dimensionsSubset.size() : 0;
        StructuredGridCoverage2DReader structuredReader = (StructuredGridCoverage2DReader)this.reader;
        List dimensionDescriptors = structuredReader.getDimensionDescriptors(this.coverageName);
        DimensionDescriptor timeDimension = null;
        DimensionDescriptor elevationDimension = null;
        ArrayList<DimensionDescriptor> customDimensions = new ArrayList<DimensionDescriptor>();
        int dimensions = 0;
        for (DimensionDescriptor dimensionDescriptor : dimensionDescriptors) {
            if (dimensionDescriptor.getName().equalsIgnoreCase("time")) {
                timeDimension = dimensionDescriptor;
                continue;
            }
            if (dimensionDescriptor.getName().equalsIgnoreCase("elevation")) {
                elevationDimension = dimensionDescriptor;
                continue;
            }
            customDimensions.add(dimensionDescriptor);
            ++dimensions;
        }
        boolean defaultTimeNeeded = temporalSubset == null && timeDimension != null;
        boolean defaultElevationNeeded = elevationSubset == null && elevationDimension != null;
        boolean bl = defaultCustomDimensionsNeeded = dimensions != specifiedDimensionsSubset;
        if (defaultTimeNeeded || defaultElevationNeeded || defaultCustomDimensionsNeeded) {
            GranuleSource source = structuredReader.getGranules(this.coverageName, true);
            Filter finalFilter = this.setFilters(originalFilter, temporalSubset, elevationSubset, (Envelope)envelopeSubset, dimensionsSubset, structuredReader, timeDimension, elevationDimension, customDimensions);
            Query query = new Query();
            List<SortBy> requestedSort = subsettingRequest.getSortBy();
            if (requestedSort == null) {
                this.sortBy(query, timeDimension, elevationDimension);
            } else {
                query.setSortBy(requestedSort.toArray(new SortBy[requestedSort.size()]));
            }
            query.setFilter(finalFilter);
            query.setMaxFeatures(1);
            SimpleFeatureCollection granulesCollection = source.getGranules(query);
            try (SimpleFeatureIterator features = granulesCollection.features();){
                if (features.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)features.next();
                    if (defaultTimeNeeded && timeDimension != null) {
                        temporalSubset = this.setDefaultTemporalSubset(timeDimension, feature);
                        subsettingRequest.setTemporalSubset(temporalSubset);
                    }
                    if (defaultElevationNeeded && elevationDimension != null) {
                        elevationSubset = this.setDefaultElevationSubset(elevationDimension, feature);
                        subsettingRequest.setElevationSubset(elevationSubset);
                    }
                    if (defaultCustomDimensionsNeeded && !customDimensions.isEmpty()) {
                        dimensionsSubset = this.setDefaultDimensionsSubset(customDimensions, feature);
                        subsettingRequest.setDimensionsSubset(dimensionsSubset);
                    }
                }
            }
        }
        return subsettingRequest;
    }

    private Map<String, List<Object>> setDefaultDimensionsSubset(List<DimensionDescriptor> customDimensions, SimpleFeature feature) {
        HashMap<String, List<Object>> dimensionsSubset = new HashMap<String, List<Object>>();
        for (DimensionDescriptor dimensionDescriptor : customDimensions) {
            String start = dimensionDescriptor.getStartAttribute();
            Object value = feature.getAttribute(start);
            ArrayList<Object> dimensionValues = new ArrayList<Object>();
            dimensionValues.add(value);
            dimensionsSubset.put(dimensionDescriptor.getName().toUpperCase(), dimensionValues);
        }
        return dimensionsSubset;
    }

    private NumberRange<?> setDefaultElevationSubset(DimensionDescriptor elevationDimension, SimpleFeature f) {
        Number startTime;
        String start = elevationDimension.getStartAttribute();
        String end = elevationDimension.getEndAttribute();
        Number endTime = startTime = (Number)f.getAttribute(start);
        if (end != null) {
            endTime = (Number)f.getAttribute(end);
        }
        return new NumberRange(startTime.getClass(), startTime, endTime);
    }

    private DateRange setDefaultTemporalSubset(DimensionDescriptor timeDimension, SimpleFeature f) {
        Date startTime;
        String start = timeDimension.getStartAttribute();
        String end = timeDimension.getEndAttribute();
        Date endTime = startTime = (Date)f.getAttribute(start);
        if (end != null) {
            endTime = (Date)f.getAttribute(end);
        }
        return new DateRange(startTime, endTime);
    }

    private void sortBy(Query query, DimensionDescriptor timeDimension, DimensionDescriptor elevationDimension) {
        ArrayList<SortByImpl> clauses = new ArrayList<SortByImpl>();
        if (timeDimension != null) {
            clauses.add(new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(timeDimension.getStartAttribute()), SortOrder.DESCENDING));
        }
        if (elevationDimension != null) {
            clauses.add(new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(elevationDimension.getStartAttribute()), SortOrder.ASCENDING));
        }
        SortBy[] sb = clauses.toArray(new SortBy[0]);
        query.setSortBy(sb);
    }

    private Filter setFilters(Filter originalFilter, DateRange temporalSubset, NumberRange<?> elevationSubset, Envelope envelopeSubset, Map<String, List<Object>> dimensionSubset, StructuredGridCoverage2DReader reader, DimensionDescriptor timeDimension, DimensionDescriptor elevationDimension, List<DimensionDescriptor> additionalDimensions) throws IOException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter timeFilter = temporalSubset == null && timeDimension == null ? null : this.setTimeFilter(temporalSubset, timeDimension.getStartAttribute(), timeDimension.getEndAttribute());
        Filter elevationFilter = elevationSubset == null && elevationDimension == null ? null : this.setElevationFilter(elevationSubset, elevationDimension.getStartAttribute(), elevationDimension.getEndAttribute());
        Filter envelopeFilter = this.setEnevelopeFilter(envelopeSubset, reader);
        Filter additionalDimensionsFilter = this.setAdditionalDimensionsFilter(dimensionSubset, additionalDimensions);
        if (originalFilter != null) {
            filters.add(originalFilter);
        }
        if (elevationFilter != null) {
            filters.add(elevationFilter);
        }
        if (timeFilter != null) {
            filters.add(timeFilter);
        }
        if (envelopeFilter != null) {
            filters.add(envelopeFilter);
        }
        if (additionalDimensionsFilter != null) {
            filters.add(additionalDimensionsFilter);
        }
        And finalFilter = this.FF.and(filters);
        return finalFilter;
    }

    private Filter setEnevelopeFilter(Envelope envelopeSubset, StructuredGridCoverage2DReader reader) throws IOException {
        Intersects envelopeFilter = null;
        if (envelopeSubset != null) {
            Polygon polygon = JTS.toGeometry((ReferencedEnvelope)new ReferencedEnvelope(envelopeSubset));
            GeometryDescriptor geom = reader.getGranules(this.coverageName, true).getSchema().getGeometryDescriptor();
            PropertyName geometryProperty = this.FF.property(geom.getLocalName());
            try {
                Geometry nativeCRSPolygon = JTS.transform((Geometry)polygon, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)reader.getCoordinateReferenceSystem()));
                Literal polygonLiteral = this.FF.literal((Object)nativeCRSPolygon);
                envelopeFilter = this.FF.intersects((Expression)geometryProperty, (Expression)polygonLiteral);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return envelopeFilter;
    }

    private Filter setAdditionalDimensionsFilter(Map<String, List<Object>> dimensionSubset, List<DimensionDescriptor> additionalDimensions) {
        And additionalDimensionsFilter = null;
        if (additionalDimensions != null && dimensionSubset != null && additionalDimensions.size() != dimensionSubset.size() && dimensionSubset.size() > 0) {
            ArrayList<Filter> additionalDimensionFilterList = new ArrayList<Filter>();
            Set<String> dimensionKeys = dimensionSubset.keySet();
            for (String dimension : dimensionKeys) {
                Filter dimensionFilter = this.createCustomDimensionFilter(dimension, dimensionSubset, additionalDimensions);
                if (dimensionFilter == null) continue;
                additionalDimensionFilterList.add(dimensionFilter);
            }
            if (!additionalDimensionFilterList.isEmpty()) {
                additionalDimensionsFilter = this.FF.and(additionalDimensionFilterList);
            }
        }
        return additionalDimensionsFilter;
    }

    private Filter createCustomDimensionFilter(String dimension, Map<String, List<Object>> dimensionSubset, List<DimensionDescriptor> customDimensions) {
        List<Object> dimensionSelection = dimensionSubset.get(dimension);
        Object dimensionValue = dimensionSelection.get(0);
        for (DimensionDescriptor dimensionDescriptor : customDimensions) {
            if (!dimensionDescriptor.getName().equalsIgnoreCase(dimension)) continue;
            String attribute = dimensionDescriptor.getStartAttribute();
            return this.FF.equals((Expression)this.FF.property(attribute), (Expression)this.FF.literal(dimensionValue));
        }
        return null;
    }

    private Filter setTimeFilter(DateRange timeRange, String start, String end) {
        if (timeRange != null) {
            if (end == null) {
                return this.betweenFilter(start, timeRange.getMinValue(), timeRange.getMaxValue());
            }
            return this.rangeFilter(start, end, timeRange.getMinValue(), timeRange.getMaxValue());
        }
        return null;
    }

    private Filter setElevationFilter(NumberRange elevationSubset, String start, String end) {
        if (elevationSubset != null) {
            if (end == null) {
                return this.betweenFilter(start, elevationSubset.getMinValue(), elevationSubset.getMaxValue());
            }
            return this.rangeFilter(start, end, elevationSubset.getMinValue(), elevationSubset.getMaxValue());
        }
        return null;
    }

    private Filter betweenFilter(String start, Object minValue, Object maxValue) {
        return this.FF.between((Expression)this.FF.property(start), (Expression)this.FF.literal(minValue), (Expression)this.FF.literal(maxValue));
    }

    private Filter rangeFilter(String start, String end, Object minValue, Object maxValue) {
        PropertyIsLessThanOrEqualTo f1 = this.FF.lessOrEqual((Expression)this.FF.property(start), (Expression)this.FF.literal(maxValue));
        PropertyIsGreaterThanOrEqualTo f2 = this.FF.greaterOrEqual((Expression)this.FF.property(end), (Expression)this.FF.literal(minValue));
        return this.FF.and(Arrays.asList(f1, f2));
    }

    private GridCoverageRequest setStandardReaderDefaults(GridCoverageRequest subsettingRequest) throws IOException {
        Double minElevation;
        Date maxTime;
        DateRange temporalSubset = subsettingRequest.getTemporalSubset();
        NumberRange elevationSubset = subsettingRequest.getElevationSubset();
        Map<String, List<Object>> dimensionSubset = subsettingRequest.getDimensionsSubset();
        if (temporalSubset == null && (maxTime = this.accessor.getMaxTime()) != null) {
            temporalSubset = new DateRange(maxTime, maxTime);
        }
        if (elevationSubset == null && (minElevation = this.accessor.getMinElevation()) != null) {
            elevationSubset = new NumberRange(minElevation.getClass(), (Number)minElevation, (Number)minElevation);
        }
        List customDomains = this.accessor.getCustomDomains();
        int availableCustomDimensions = 0;
        int specifiedCustomDimensions = 0;
        if (customDomains != null && !customDomains.isEmpty()) {
            availableCustomDimensions = customDomains.size();
            int n = specifiedCustomDimensions = dimensionSubset != null ? dimensionSubset.size() : 0;
            if (dimensionSubset == null) {
                dimensionSubset = new HashMap<String, List<Object>>();
            }
        }
        if (availableCustomDimensions != specifiedCustomDimensions) {
            this.setDefaultCustomDimensions(customDomains, dimensionSubset);
        }
        subsettingRequest.setDimensionsSubset(dimensionSubset);
        subsettingRequest.setTemporalSubset(temporalSubset);
        subsettingRequest.setElevationSubset(elevationSubset);
        return subsettingRequest;
    }

    private void setDefaultCustomDimensions(List<String> customDomains, Map<String, List<Object>> dimensionSubset) throws IOException {
        for (String customDomain : customDomains) {
            if (dimensionSubset.containsKey(customDomain)) continue;
            ArrayList<Object> dimensionValue = new ArrayList<Object>();
            String defaultValue = this.accessor.getCustomDomainDefaultValue(customDomain);
            String dataType = this.reader.getMetadataValue(customDomain + "_DOMAIN_DATATYPE");
            if (dataType != null) {
                PARSER.setValues(defaultValue, dimensionValue, dataType);
            } else {
                dimensionValue.add(defaultValue);
            }
            dimensionSubset.put(customDomain, dimensionValue);
        }
    }
}

