/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.geotools.xml.impl.DatatypeConverterImpl;

public class WCSDimensionsValueParser {
    private static final Logger LOGGER = Logging.getLogger(WCSDimensionsValueParser.class);
    private static final DatatypeConverterImpl XML_CONVERTER = DatatypeConverterImpl.getInstance();

    public Date parseDateTime(String value) {
        return XML_CONVERTER.parseDateTime(value).getTime();
    }

    public Double parseDouble(String value) {
        return XML_CONVERTER.parseDouble(value);
    }

    public boolean setAsInteger(String slicePointS, List<Object> selectedValues) {
        Integer slicePoint = this.parseAsInteger(slicePointS);
        if (slicePoint != null) {
            selectedValues.add(slicePoint);
            return true;
        }
        return false;
    }

    public boolean setAsIntegerRange(String low, String high, List<Object> selectedValues) {
        Integer l = this.parseAsInteger(low);
        Integer h = this.parseAsInteger(high);
        if (l != null && h != null) {
            if (l > h) {
                WCSDimensionsValueParser.throwInvalidRangeException(low, high);
            }
            selectedValues.add(new NumberRange(Integer.class, (Number)l, (Number)h));
            return true;
        }
        return false;
    }

    public boolean setAsDouble(String slicePointS, List<Object> selectedValues) {
        Double slicePoint = WCSDimensionsValueParser.parseAsDouble(slicePointS);
        if (slicePoint != null) {
            selectedValues.add(slicePoint);
            return true;
        }
        return false;
    }

    public boolean setAsDoubleRange(String low, String high, List<Object> selectedValues) {
        Double l = WCSDimensionsValueParser.parseAsDouble(low);
        Double h = WCSDimensionsValueParser.parseAsDouble(high);
        if (l != null && h != null) {
            if (l > h) {
                WCSDimensionsValueParser.throwInvalidRangeException(low, high);
            }
            selectedValues.add(new NumberRange(Double.class, (Number)l, (Number)h));
            return true;
        }
        return false;
    }

    public boolean setAsDate(String slicePointS, List<Object> selectedValues) {
        Date slicePoint = WCSDimensionsValueParser.parseAsDate(slicePointS);
        if (slicePoint != null) {
            selectedValues.add(slicePoint);
            return true;
        }
        return false;
    }

    public boolean setAsDateRange(String low, String high, List<Object> selectedValues) {
        Date l = WCSDimensionsValueParser.parseAsDate(low);
        Date h = WCSDimensionsValueParser.parseAsDate(high);
        if (l != null && h != null) {
            if (l.compareTo(h) > 0) {
                WCSDimensionsValueParser.throwInvalidRangeException(low, high);
            }
            selectedValues.add(new DateRange(l, h));
            return true;
        }
        return false;
    }

    public static Double parseAsDouble(String text) {
        try {
            Double slicePoint = XML_CONVERTER.parseDouble(text);
            return slicePoint;
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(text + " can't be parsed as an Double.");
            }
            return null;
        }
    }

    public static NumberRange<Double> parseAsDoubleRange(String text) {
        block3: {
            try {
                String[] range;
                if (text.contains("/") && (range = text.split("/")).length == 2) {
                    String min = range[0];
                    String max = range[1];
                    Double minValue = XML_CONVERTER.parseDouble(min);
                    Double maxValue = XML_CONVERTER.parseDouble(max);
                    return new NumberRange(Double.class, (Number)minValue, (Number)maxValue);
                }
            }
            catch (NumberFormatException nfe) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.fine(text + " can't be parsed as an Double.");
            }
        }
        return null;
    }

    public Integer parseAsInteger(String text) {
        try {
            Integer slicePoint = XML_CONVERTER.parseInt(text);
            return slicePoint;
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(text + " can't be parsed as an Integer.");
            }
            return null;
        }
    }

    public static Date parseAsDate(String text) {
        block3: {
            try {
                Date slicePoint = XML_CONVERTER.parseDateTime(text).getTime();
                if (slicePoint != null) {
                    return slicePoint;
                }
            }
            catch (IllegalArgumentException iae) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.fine(text + " can't be parsed as a time");
            }
        }
        return null;
    }

    public void setValues(String slicePointS, List<Object> selectedValues, String domainDatatype) {
        if (domainDatatype.endsWith("Timestamp") || domainDatatype.endsWith("Date")) {
            this.setAsDate(slicePointS, selectedValues);
        } else if (domainDatatype.endsWith("Integer")) {
            this.setAsInteger(slicePointS, selectedValues);
        } else if (domainDatatype.endsWith("Double")) {
            this.setAsDouble(slicePointS, selectedValues);
        } else if (domainDatatype.endsWith("String")) {
            selectedValues.add(slicePointS);
        }
    }

    public void setRangeValues(String low, String high, List<Object> selectedValues, String domainDatatype) {
        if (domainDatatype.endsWith("Timestamp") || domainDatatype.endsWith("Date")) {
            this.setAsDateRange(low, high, selectedValues);
        } else if (domainDatatype.endsWith("Integer")) {
            this.setAsIntegerRange(low, high, selectedValues);
        } else if (domainDatatype.endsWith("Double")) {
            this.setAsDoubleRange(low, high, selectedValues);
        } else if (domainDatatype.endsWith("String")) {
            selectedValues.add(low + "/" + high);
        }
    }

    public TreeSet<Double> getDomainNumber(TreeSet<Object> domain) {
        TreeSet<Double> results = new TreeSet<Double>();
        for (Object item : domain) {
            if (item instanceof Number) {
                Double number = (Double)item;
                results.add(number);
                continue;
            }
            if (item instanceof NumberRange) {
                NumberRange range = (NumberRange)item;
                results.add(range.getMinimum());
                results.add(range.getMaximum());
                continue;
            }
            throw new IllegalArgumentException("The specified domain set doesn't contain Number or NumberRange instances");
        }
        return results;
    }

    private static void throwInvalidRangeException(String low, String high) {
        throw new WCS20Exception("Low greater than High: " + low + ", " + high, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
    }
}

