/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.awt.geom.AffineTransform;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wcs20.GetCoverageType;
import net.opengis.wcs20.InterpolationType;
import net.opengis.wcs20.RangeItemType;
import net.opengis.wcs20.RangeSubsetType;
import net.opengis.wcs20.ScaleAxisByFactorType;
import net.opengis.wcs20.ScaleAxisType;
import net.opengis.wcs20.ScaleByFactorType;
import net.opengis.wcs20.ScaleToExtentType;
import net.opengis.wcs20.ScaleToSizeType;
import net.opengis.wcs20.ScalingType;
import net.opengis.wcs20.TargetAxisExtentType;
import net.opengis.wcs20.TargetAxisSizeType;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.EList;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs2_0.kvp.WCSKVPTestSupport;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.image.test.ImageAssert;
import org.geotools.referencing.CRS;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetCoverageKvpTest
extends WCSKVPTestSupport {
    private static final QName WORLD_EXTRA = new QName(MockData.SF_URI, "world", MockData.SF_PREFIX);
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), "raster-filter-test.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addRasterLayer(WORLD_EXTRA, "world.tiff", "tiff", this.getCatalog());
    }

    @Test
    public void testParseBasic() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage");
        Assert.assertEquals((Object)"theCoverage", (Object)gc.getCoverageId());
    }

    @Test
    public void testGetCoverageNoWs() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=BlueMarble&Format=image/tiff");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
    }

    @Test
    public void testNotExistent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=NotThere&&Format=image/tiff");
        this.checkOws20Exception(response, 404, "NoSuchCoverage", "coverageId");
    }

    @Test
    public void testGetCoverageLocalWs() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs/wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=BlueMarble&&Format=image/tiff");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
    }

    @Test
    public void testExtensionScaleFactor() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&scaleFactor=2");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((long)1L, (long)extensions.size());
        ScalingType scaling = (ScalingType)extensions.get("http://www.opengis.net/WCS_service-extension_scaling/1.0:Scaling");
        ScaleByFactorType sbf = scaling.getScaleByFactor();
        Assert.assertEquals((double)2.0, (double)sbf.getScaleFactor(), (double)0.0);
    }

    @Test
    public void testExtensionScaleAxes() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&scaleaxes=http://www.opengis.net/def/axis/OGC/1/i(3.5),http://www.opengis.net/def/axis/OGC/1/j(5.0),http://www.opengis.net/def/axis/OGC/1/k(2.0)");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((long)1L, (long)extensions.size());
        ScalingType scaling = (ScalingType)extensions.get("http://www.opengis.net/WCS_service-extension_scaling/1.0:Scaling");
        ScaleAxisByFactorType sax = scaling.getScaleAxesByFactor();
        EList saxes = sax.getScaleAxis();
        Assert.assertEquals((long)3L, (long)saxes.size());
        Assert.assertEquals((Object)"http://www.opengis.net/def/axis/OGC/1/i", (Object)((ScaleAxisType)saxes.get(0)).getAxis());
        Assert.assertEquals((double)3.5, (double)((ScaleAxisType)saxes.get(0)).getScaleFactor(), (double)0.0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/axis/OGC/1/j", (Object)((ScaleAxisType)saxes.get(1)).getAxis());
        Assert.assertEquals((double)5.0, (double)((ScaleAxisType)saxes.get(1)).getScaleFactor(), (double)0.0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/axis/OGC/1/k", (Object)((ScaleAxisType)saxes.get(2)).getAxis());
        Assert.assertEquals((double)2.0, (double)((ScaleAxisType)saxes.get(2)).getScaleFactor(), (double)0.0);
    }

    @Test
    public void testExtensionScaleSize() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&scalesize=http://www.opengis.net/def/axis/OGC/1/i(1000),http://www.opengis.net/def/axis/OGC/1/j(1000),http://www.opengis.net/def/axis/OGC/1/k(10)");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((long)1L, (long)extensions.size());
        ScalingType scaling = (ScalingType)extensions.get("http://www.opengis.net/WCS_service-extension_scaling/1.0:Scaling");
        ScaleToSizeType sts = scaling.getScaleToSize();
        EList scaleAxes = sts.getTargetAxisSize();
        Assert.assertEquals((long)3L, (long)scaleAxes.size());
        Assert.assertEquals((Object)"http://www.opengis.net/def/axis/OGC/1/i", (Object)((TargetAxisSizeType)scaleAxes.get(0)).getAxis());
        Assert.assertEquals((double)1000.0, (double)((TargetAxisSizeType)scaleAxes.get(0)).getTargetSize(), (double)0.0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/axis/OGC/1/j", (Object)((TargetAxisSizeType)scaleAxes.get(1)).getAxis());
        Assert.assertEquals((double)1000.0, (double)((TargetAxisSizeType)scaleAxes.get(1)).getTargetSize(), (double)0.0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/axis/OGC/1/k", (Object)((TargetAxisSizeType)scaleAxes.get(2)).getAxis());
        Assert.assertEquals((double)10.0, (double)((TargetAxisSizeType)scaleAxes.get(2)).getTargetSize(), (double)0.0);
    }

    @Test
    public void testExtensionScaleExtent() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&scaleextent=http://www.opengis.net/def/axis/OGC/1/i(10,20),http://www.opengis.net/def/axis/OGC/1/j(20,30)");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((long)1L, (long)extensions.size());
        ScalingType scaling = (ScalingType)extensions.get("http://www.opengis.net/WCS_service-extension_scaling/1.0:Scaling");
        ScaleToExtentType ste = scaling.getScaleToExtent();
        Assert.assertEquals((long)2L, (long)ste.getTargetAxisExtent().size());
        TargetAxisExtentType tax = (TargetAxisExtentType)ste.getTargetAxisExtent().get(0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/axis/OGC/1/i", (Object)tax.getAxis());
        Assert.assertEquals((double)10.0, (double)tax.getLow(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)tax.getHigh(), (double)0.0);
        tax = (TargetAxisExtentType)ste.getTargetAxisExtent().get(1);
        Assert.assertEquals((Object)"http://www.opengis.net/def/axis/OGC/1/j", (Object)tax.getAxis());
        Assert.assertEquals((double)20.0, (double)tax.getLow(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)tax.getHigh(), (double)0.0);
    }

    @Test
    public void testExtensionRangeSubset() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&rangesubset=band01,band03:band05,band10,band19:band21");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((long)1L, (long)extensions.size());
        RangeSubsetType rangeSubset = (RangeSubsetType)extensions.get("http://www.opengis.net/wcs/range-subsetting/1.0:RangeSubset");
        EList items = rangeSubset.getRangeItems();
        Assert.assertEquals((long)4L, (long)items.size());
        RangeItemType i1 = (RangeItemType)items.get(0);
        Assert.assertEquals((Object)"band01", (Object)i1.getRangeComponent());
        RangeItemType i2 = (RangeItemType)items.get(1);
        Assert.assertEquals((Object)"band03", (Object)i2.getRangeInterval().getStartComponent());
        Assert.assertEquals((Object)"band05", (Object)i2.getRangeInterval().getEndComponent());
        RangeItemType i3 = (RangeItemType)items.get(2);
        Assert.assertEquals((Object)"band10", (Object)i3.getRangeComponent());
        RangeItemType i4 = (RangeItemType)items.get(3);
        Assert.assertEquals((Object)"band19", (Object)i4.getRangeInterval().getStartComponent());
        Assert.assertEquals((Object)"band21", (Object)i4.getRangeInterval().getEndComponent());
    }

    @Test
    public void testExtensionCRS() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&SUBSETTINGCRS=http://www.opengis.net/def/crs/EPSG/0/4326&outputcrs=http://www.opengis.net/def/crs/EPSG/0/32632");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((long)2L, (long)extensions.size());
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/EPSG/0/4326", (Object)extensions.get("http://www.opengis.net/wcs/service-extension/crs/1.0:subsettingCrs"));
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/EPSG/0/32632", (Object)extensions.get("http://www.opengis.net/wcs/service-extension/crs/1.0:outputCrs"));
    }

    @Test
    public void testExtensionInterpolationLinear() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&interpolation=http://www.opengis.net/def/interpolation/OGC/1/linear");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        InterpolationType interp = (InterpolationType)extensions.get("http://www.opengis.net/WCS_service-extension_interpolation/1.0:Interpolation");
        Assert.assertEquals((Object)"http://www.opengis.net/def/interpolation/OGC/1/linear", (Object)interp.getInterpolationMethod().getInterpolationMethod());
    }

    @Test
    public void testExtensionInterpolationMixed() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&interpolation=http://www.opengis.net/def/interpolation/OGC/1/linear");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        InterpolationType interp = (InterpolationType)extensions.get("http://www.opengis.net/WCS_service-extension_interpolation/1.0:Interpolation");
        Assert.assertEquals((Object)"http://www.opengis.net/def/interpolation/OGC/1/linear", (Object)interp.getInterpolationMethod().getInterpolationMethod());
    }

    @Test
    public void testExtensionOverview() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&overviewPolicy=QUALITY");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((long)1L, (long)extensions.size());
        String overviewPolicy = (String)extensions.get("http://www.geoserver.org/WCS_service-extension_overviewpolicy/1.0:OverviewPolicy");
        Assert.assertEquals((Object)overviewPolicy, (Object)"QUALITY");
    }

    @Test
    public void testGetMissingCoverage() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=notThereBaby");
        this.checkOws20Exception(response, 404, "NoSuchCoverage", "coverageId");
    }

    @Test
    public void testCqlFilterRed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__mosaic&CQL_FILTER=location like 'red%25'");
        this.assertOriginPixelColor(response, new int[]{255, 0, 0});
    }

    @Test
    public void testCqlFilterGreen() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__mosaic&CQL_FILTER=location like 'green%25'");
        this.assertOriginPixelColor(response, new int[]{0, 255, 0});
    }

    @Test
    public void testSortByLocationAscending() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__mosaic&sortBy=location");
        this.assertOriginPixelColor(response, new int[]{0, 255, 0});
    }

    @Test
    public void testSortByLocationDescending() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__mosaic&sortBy=location D");
        this.assertOriginPixelColor(response, new int[]{255, 255, 0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorldOutsideDateline() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__world");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("world", "world.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        GridCoverage2D coverage = null;
        try {
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)EPSG_4326));
            Assert.assertEquals((long)720L, (long)reader.getOriginalGridRange().getSpan(0));
            Assert.assertEquals((long)360L, (long)reader.getOriginalGridRange().getSpan(1));
            coverage = reader.read(null);
            Assert.assertNotNull((Object)coverage);
            GeneralBounds expected = new GeneralBounds(new double[]{-180.01, -90.0}, new double[]{180.01, 90.0});
            expected.setCoordinateReferenceSystem(EPSG_4326);
            double scale = GetCoverageKvpTest.getScale((Coverage)coverage);
            GetCoverageKvpTest.assertEnvelopeEquals(expected, scale, (GeneralBounds)coverage.getEnvelope(), scale);
        }
        catch (Throwable throwable) {
            this.clean(reader, coverage);
            throw throwable;
        }
        this.clean(reader, coverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScalingWithRequestCrossingDateline() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__world&subset=http://www.opengis.net/def/axis/OGC/0/Long(40,240)&subset=http://www.opengis.net/def/axis/OGC/0/Lat(-50,50)&format=image/tiff&SCALESIZE=http://www.opengis.net/def/axis/OGC/1/i(400),http://www.opengis.net/def/axis/OGC/1/j(200)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("world", "world.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        GridCoverage2D coverage = null;
        try {
            Assert.assertEquals((long)400L, (long)reader.getOriginalGridRange().getSpan(0));
            Assert.assertEquals((long)200L, (long)reader.getOriginalGridRange().getSpan(1));
            coverage = reader.read(null);
            Assert.assertNotNull((Object)coverage);
            GeneralBounds expected = new GeneralBounds(new double[]{40.0, -50.0}, new double[]{240.0, 50.0});
            expected.setCoordinateReferenceSystem(EPSG_4326);
            double scale = GetCoverageKvpTest.getScale((Coverage)coverage);
            GetCoverageKvpTest.assertEnvelopeEquals(expected, scale, (GeneralBounds)coverage.getEnvelope(), scale);
            RenderedImage image = coverage.getRenderedImage();
            ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wcs2_0/dateline-world.png"), (RenderedImage)image, (int)250);
        }
        catch (Throwable throwable) {
            this.clean(reader, coverage);
            throw throwable;
        }
        this.clean(reader, coverage);
    }

    private void assertOriginPixelColor(MockHttpServletResponse response, int[] expected) throws DataSourceException, IOException {
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] bytes = response.getContentAsByteArray();
        GeoTiffReader reader = new GeoTiffReader((Object)new ByteArrayInputStream(bytes));
        GridCoverage2D coverage = reader.read(null);
        Raster raster = coverage.getRenderedImage().getData();
        int[] pixel = new int[3];
        raster.getPixel(0, 0, pixel);
        MatcherAssert.assertThat((Object)pixel, (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImposedBBOX() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__utm11");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("utm11", "utm11.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        GridCoverage2D coverage = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:26711");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
            coverage = reader.read(null);
            Assert.assertNotNull((Object)coverage);
            double scale = GetCoverageKvpTest.getScale((Coverage)coverage);
            Assert.assertEquals((double)256.0, (double)scale, (double)0.0);
            GeneralBounds expected = new GeneralBounds(new double[]{440562.0, 3720758.0}, new double[]{471794.0, 3750966.0});
            expected.setCoordinateReferenceSystem(crs);
            GetCoverageKvpTest.assertEnvelopeEquals(expected, scale, (GeneralBounds)coverage.getEnvelope(), scale);
            Assert.assertEquals((long)122L, (long)reader.getOriginalGridRange().getSpan(0));
            Assert.assertEquals((long)118L, (long)reader.getOriginalGridRange().getSpan(1));
            Raster raster = coverage.getRenderedImage().getData();
            int[] px = new int[1];
            for (int j = 0; j < 118; ++j) {
                raster.getPixel(0, j, px);
                Assert.assertEquals((long)0L, (long)px[0]);
                raster.getPixel(121, j, px);
                Assert.assertEquals((long)0L, (long)px[0]);
            }
        }
        catch (Throwable throwable) {
            this.clean(reader, coverage);
            throw throwable;
        }
        this.clean(reader, coverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImposedBBOXRotated() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__RotatedCad");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("rotatedCad", "rotatedCad.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        GridCoverage2D coverage = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3003");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
            coverage = reader.read(null);
            Assert.assertNotNull((Object)coverage);
            GeneralBounds expected = new GeneralBounds(new double[]{5000000.0, 1402800.0}, new double[]{5000100.0, 1402900.0});
            expected.setCoordinateReferenceSystem(crs);
            GetCoverageKvpTest.assertEnvelopeEquals(expected, 1.0, (GeneralBounds)coverage.getEnvelope(), 1.0);
            double scale = GetCoverageKvpTest.getScale((Coverage)coverage);
            Assert.assertEquals((double)0.11285131, (double)scale, (double)1.0E-5);
            Assert.assertEquals((long)886L, (long)reader.getOriginalGridRange().getSpan(0));
            Assert.assertEquals((long)886L, (long)reader.getOriginalGridRange().getSpan(1));
        }
        catch (Throwable throwable) {
            this.clean(reader, coverage);
            throw throwable;
        }
        this.clean(reader, coverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatelineCross() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__dateline_cross");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("dateline", "dateline.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        GridCoverage2D coverage = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
            coverage = reader.read(null);
            Assert.assertNotNull((Object)coverage);
            double scale = GetCoverageKvpTest.getScale((Coverage)coverage);
            Assert.assertEquals((double)0.005, (double)scale, (double)1.0E-4);
            GeneralBounds expected = new GeneralBounds(new double[]{179.5, -84.272}, new double[]{180.0, -82.217});
            expected.setCoordinateReferenceSystem(crs);
            Assert.assertTrue((String)("Equality failed, actual envelope was " + coverage.getEnvelope2D()), (boolean)expected.equals((Bounds)coverage.getEnvelope2D(), 1.0E-4, false));
            Assert.assertEquals((long)100L, (long)reader.getOriginalGridRange().getSpan(0));
            Assert.assertEquals((long)411L, (long)reader.getOriginalGridRange().getSpan(1));
        }
        catch (Throwable throwable) {
            this.clean(reader, coverage);
            throw throwable;
        }
        this.clean(reader, coverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReprojected() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=cdf__usa");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("usa", "usa.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        GridCoverage2D coverage = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3857");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
            coverage = reader.read(null);
            Assert.assertNotNull((Object)coverage);
            GeneralBounds expected = new GeneralBounds(new double[]{-1.457024E7, 6199732.0}, new double[]{-1.3790593E7, 7197101.0});
            expected.setCoordinateReferenceSystem(crs);
            Assert.assertTrue((boolean)expected.equals(coverage.getEnvelope(), 1.0, false));
            AffineTransform affineTransform = GetCoverageKvpTest.getAffineTransform((Coverage)coverage);
            Assert.assertEquals((double)7796.0, (double)affineTransform.getScaleX(), (double)1.0);
            Assert.assertEquals((double)-9973.0, (double)affineTransform.getScaleY(), (double)1.0);
            Assert.assertEquals((long)100L, (long)reader.getOriginalGridRange().getSpan(0));
            Assert.assertEquals((long)100L, (long)reader.getOriginalGridRange().getSpan(1));
        }
        catch (Throwable throwable) {
            this.clean(reader, coverage);
            throw throwable;
        }
        this.clean(reader, coverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIAUCoverageGeotiff() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=iau__Viking");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("viking", "viking.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        GridCoverage2D coverage = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"IAU:49900");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
            coverage = reader.read(null);
            Assert.assertNotNull((Object)coverage);
            double scale = GetCoverageKvpTest.getScale((Coverage)coverage);
            Assert.assertEquals((double)27.0, (double)scale, (double)0.001);
        }
        catch (Throwable throwable) {
            this.clean(reader, coverage);
            throw throwable;
        }
        this.clean(reader, coverage);
    }

    @Test
    public void testIAUCoverageGML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=iau__Viking&format=application/gml%2Bxml");
        Assert.assertEquals((Object)"application/gml+xml", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.dom(new ByteArrayInputStream(this.getBinary(response)));
        NodeList nodes = xpath.getMatchingNodes("//@srsName", dom);
        Assert.assertEquals((long)4L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Assert.assertEquals((Object)"http://www.opengis.net/def/crs/IAU/0/49900", (Object)nodes.item(i).getNodeValue());
        }
    }

    @Test
    public void testClipWorldNoCRS() throws Exception {
        String halfWorld = "POLYGON((0 -90, 0 90, 180 90, 180 -90, 0 -90))";
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__world&clip=" + halfWorld);
        this.testCoverage(response, "halfWorld", (reader, coverage) -> {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
            GeneralBounds expected = new GeneralBounds(new double[]{0.0, -90.0}, new double[]{180.0, 90.0});
            expected.setCoordinateReferenceSystem(crs);
            GetCoverageKvpTest.assertEnvelopeEquals(expected, 1.0, (GeneralBounds)coverage.getEnvelope(), 1.0);
        });
    }

    @Test
    public void testClipWorldReprojected() throws Exception {
        String halfWorld = "SRID=4326;POLYGON((0 -85, 0 85, 180 85, 180 -85, 0 -85))";
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__world&outputCrs=EPSG:3857&clip=" + halfWorld);
        this.testCoverage(response, "halfWorld", (reader, coverage) -> {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3857");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)crs));
            GeneralBounds expected = new GeneralBounds(new double[]{0.0, -1.99663728E7}, new double[]{2.00375083E7, 1.99663728E7});
            expected.setCoordinateReferenceSystem(crs);
            GetCoverageKvpTest.assertEnvelopeEquals(expected, 1.0, (GeneralBounds)coverage.getEnvelope(), 1000000.0);
        });
    }

    @Test
    public void testClipInvalidGeometryType() throws Exception {
        String point = "POINT(0 -85)";
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__world&outputCrs=EPSG:3857&clip=" + point);
        this.checkOws20Exception(response, 400, "InvalidParameterValue", "clip");
    }

    @Test
    public void testClipInvalidWkt() throws Exception {
        String point = "POINT(0";
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=sf__world&outputCrs=EPSG:3857&clip=" + point);
        this.checkOws20Exception(response, 400, "InvalidParameterValue", "clip");
    }

    @Test
    public void testClipOutside() throws Exception {
        String europe = "POLYGON((35 -10, 70 -10, 70 40, 70 -10, 35 -10))";
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=BlueMarble&clip=" + europe);
        String message = this.checkOws20Exception(response, 400, "InvalidParameterValue", "clip");
        Assert.assertEquals((Object)"Clip polygon does not overlap coverage data", (Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCoverage(MockHttpServletResponse response, String fileName, CoverageChecker checker) throws Exception {
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile(fileName, fileName + ".tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        GridCoverage2D coverage = null;
        try {
            coverage = reader.read(null);
            checker.check(reader, coverage);
        }
        catch (Throwable throwable) {
            this.clean(reader, coverage);
            throw throwable;
        }
        this.clean(reader, coverage);
    }

    public static interface CoverageChecker {
        public void check(GeoTiffReader var1, GridCoverage2D var2) throws Exception;
    }
}

