/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.imageio.stream.FileImageInputStream;
import org.apache.commons.io.FileUtils;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class InterpolationExtentionsTest
extends WCSTestSupport {
    @Test
    public void testInterpolationSingleLinearXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationLinear.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        Assert.assertEquals((long)360L, (long)reader.getWidth(0));
        Assert.assertEquals((long)360L, (long)reader.getHeight(0));
        reader.dispose();
    }

    @Test
    public void testInterpolationSingleNearestXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationNearest.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        Assert.assertEquals((long)360L, (long)reader.getWidth(0));
        Assert.assertEquals((long)360L, (long)reader.getHeight(0));
        reader.dispose();
    }

    @Test
    public void testInterpolationMixedSupportedXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationMixedSupported.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        Assert.assertEquals((long)360L, (long)reader.getWidth(0));
        Assert.assertEquals((long)360L, (long)reader.getHeight(0));
        reader.dispose();
    }

    @Test
    public void testInterpolationMixedTimeXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationMixedTime.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
    }

    @Test
    public void testInterpolationMixedUnsupportedXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationMixedUnsupported.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
    }

    @Test
    public void testInterpolationMixedDuplicatedXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationMixedDuplicated.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
    }
}

