/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import net.opengis.wcs20.DimensionSliceType;
import net.opengis.wcs20.DimensionTrimType;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.wcs2_0.kvp.SubsetKvpParser;
import org.junit.Assert;
import org.junit.Test;

public class SubsetKvpParserTest {
    SubsetKvpParser parser = new SubsetKvpParser();

    @Test
    public void testInvalidValues() throws Exception {
        try {
            this.parser.parse("test");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("test,EPSG:4326");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("test(,");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("test(,)");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("test(\"abc,def\",abc)");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
    }

    @Test
    public void testSliceString() throws Exception {
        DimensionSliceType result = (DimensionSliceType)this.parser.parse("mydim(\"myvalue\")");
        Assert.assertEquals((Object)"mydim", (Object)result.getDimension());
        Assert.assertEquals((Object)"myvalue", (Object)result.getSlicePoint());
    }

    @Test
    public void testSliceNumber() throws Exception {
        DimensionSliceType result = (DimensionSliceType)this.parser.parse("mydim(12345)");
        Assert.assertEquals((Object)"mydim", (Object)result.getDimension());
        Assert.assertEquals((Object)"12345", (Object)result.getSlicePoint());
    }

    @Test
    public void testTrimOpen() throws Exception {
        DimensionTrimType result = (DimensionTrimType)this.parser.parse("lon,EPSG:4326(*,*)");
        Assert.assertEquals((Object)"lon", (Object)result.getDimension());
        Assert.assertEquals((Object)"EPSG:4326", (Object)result.getCRS());
        Assert.assertNull((Object)result.getTrimLow());
        Assert.assertNull((Object)result.getTrimHigh());
    }

    @Test
    public void testTrimNumbers() throws Exception {
        DimensionTrimType result = (DimensionTrimType)this.parser.parse("lon,EPSG:4326(10,20)");
        Assert.assertEquals((Object)"lon", (Object)result.getDimension());
        Assert.assertEquals((Object)"EPSG:4326", (Object)result.getCRS());
        Assert.assertEquals((Object)"10", (Object)result.getTrimLow());
        Assert.assertEquals((Object)"20", (Object)result.getTrimHigh());
    }

    @Test
    public void testTrimStringsCommas() throws Exception {
        DimensionTrimType result = (DimensionTrimType)this.parser.parse("mydim(\"a,b\",\"c,d\")");
        Assert.assertEquals((Object)"mydim", (Object)result.getDimension());
        Assert.assertNull((Object)result.getCRS());
        Assert.assertEquals((Object)"a,b", (Object)result.getTrimLow());
        Assert.assertEquals((Object)"c,d", (Object)result.getTrimHigh());
    }

    private void checkInvalidSyntaxException(OWS20Exception e) {
        Assert.assertNotNull((Object)e.getHttpCode());
        Assert.assertEquals((long)400L, (long)e.getHttpCode().intValue());
        Assert.assertEquals((Object)"InvalidEncodingSyntax", (Object)e.getCode());
        Assert.assertEquals((Object)"subset", (Object)e.getLocator());
    }
}

