/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.io.File;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageInputStream;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.vfny.geoserver.wcs.WcsException;

public class GeoTiffGetCoverageTest
extends WCSTestSupport {
    @Test
    public void testGeotiffExtensionCompressionJPEGWrongQuality1() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionCompressionJPEGWrongQuality1.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.JpegQualityInvalid.toString(), "105");
    }

    @Test
    public void testGeotiffExtensionCompressionJPEGWrongQuality2() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionCompressionJPEGWrongQuality2.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.JpegQualityInvalid.toString(), "0");
    }

    @Test
    public void testGeotiffExtensionCompressionLZW() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionCompressionLZW.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(0).getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        IIOMetadataNode field = this.getTiffField(root, 259);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"LZW", (Object)field.getFirstChild().getFirstChild().getAttributes().item(1).getNodeValue());
        Assert.assertEquals((Object)"5", (Object)field.getFirstChild().getFirstChild().getAttributes().item(0).getNodeValue());
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    public void testGeotiffExtensionCompressionDeflate() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionCompressionDeflate.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(0).getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        IIOMetadataNode field = this.getTiffField(root, 259);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Deflate", (Object)field.getFirstChild().getFirstChild().getAttributes().item(1).getNodeValue());
        Assert.assertEquals((Object)"32946", (Object)field.getFirstChild().getFirstChild().getAttributes().item(0).getNodeValue());
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    @Ignore
    public void testGeotiffExtensionCompressionHuffman() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionCompressionHuffman.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(0).getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        IIOMetadataNode field = this.getTiffField(root, 259);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Deflate", (Object)field.getFirstChild().getFirstChild().getAttributes().item(1).getNodeValue());
        Assert.assertEquals((Object)"32946", (Object)field.getFirstChild().getFirstChild().getAttributes().item(0).getNodeValue());
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    @Ignore
    public void testGeotiffExtensionCompressionPackBits() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionCompressionPackBits.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(0).getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        IIOMetadataNode field = this.getTiffField(root, 259);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"PackBits", (Object)field.getFirstChild().getFirstChild().getAttributes().item(1).getNodeValue());
        Assert.assertEquals((Object)"32773", (Object)field.getFirstChild().getFirstChild().getAttributes().item(0).getNodeValue());
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    public void testGeotiffExtensionCompressionWrongCompression() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionCompressionWrongCompression.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.CompressionInvalid.toString(), "OUCH");
    }

    @Test
    public void testGeotiffExtensionCompressionJPEG() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionCompressionJPEG.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(0).getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        IIOMetadataNode field = this.getTiffField(root, 259);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"JPEG", (Object)field.getFirstChild().getFirstChild().getAttributes().item(1).getNodeValue());
        Assert.assertEquals((Object)"7", (Object)field.getFirstChild().getFirstChild().getAttributes().item(0).getNodeValue());
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    public void testGeotiffExtensionTilingDefault() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionTilingDefault.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = new File("./target/bm_gtiff.tiff");
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TestCase.assertTrue((boolean)reader.isImageTiled(0));
        Assert.assertEquals((long)368L, (long)reader.getTileHeight(0));
        Assert.assertEquals((long)368L, (long)reader.getTileWidth(0));
        IIOMetadataNode node = ((TIFFImageMetadata)reader.getImageMetadata(0)).getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    public void testGeotiffExtensionTilingWrong1() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionTilingWrong1.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.TilingInvalid.toString(), "13");
    }

    @Test
    public void testGeotiffExtensionTilingWrong2() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionTilingWrong2.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.TilingInvalid.toString(), "25");
    }

    @Test
    public void testGeotiffExtensionTiling() throws Exception {
        File xml = new File("./src/test/resources/geotiff/geotiffExtensionTiling.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = new File("./target/bm_gtiff.tiff");
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TestCase.assertTrue((boolean)reader.isImageTiled(0));
        Assert.assertEquals((long)256L, (long)reader.getTileHeight(0));
        Assert.assertEquals((long)256L, (long)reader.getTileWidth(0));
        IIOMetadataNode node = ((TIFFImageMetadata)reader.getImageMetadata(0)).getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    public void testGeotiffExtensionBanded() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wcs:GetCoverage\n  xmlns:wcs=\"http://www.opengis.net/wcs/2.0\"\n  xmlns:wcsgeotiff=\"http://www.opengis.net/wcs/geotiff/1.0\"\n  xmlns:gml=\"http://www.opengis.net/gml/3.2\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/2.0 \n  http://schemas.opengis.net/wcs/2.0/wcsAll.xsd\"\n  service=\"WCS\"\n  version=\"2.0.1\">\n  <wcs:Extension>\n    <wcsgeotiff:compression>None</wcsgeotiff:compression>\n    <wcsgeotiff:interleave>band</wcsgeotiff:interleave>\n  </wcs:Extension>\n  <wcs:CoverageId>wcs__BlueMarble</wcs:CoverageId>\n  <wcs:format>image/tiff</wcs:format>\n</wcs:GetCoverage>";
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
    }
}

