/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.WarpAffine;
import net.opengis.wcs20.ExtensionItemType;
import net.opengis.wcs20.ExtensionType;
import net.opengis.wcs20.GetCoverageType;
import net.opengis.wcs20.InterpolationAxesType;
import net.opengis.wcs20.InterpolationAxisType;
import net.opengis.wcs20.InterpolationMethodType;
import net.opengis.wcs20.InterpolationType;
import net.opengis.wcs20.RangeIntervalType;
import net.opengis.wcs20.RangeItemType;
import net.opengis.wcs20.RangeSubsetType;
import net.opengis.wcs20.ScalingType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionCustomizerReader;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs2_0.GridCoverageRequest;
import org.geoserver.wcs2_0.InterpolationPolicy;
import org.geoserver.wcs2_0.ScalingPolicy;
import org.geoserver.wcs2_0.WCSEnvelope;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.response.DimensionBean;
import org.geoserver.wcs2_0.response.GranuleStackImpl;
import org.geoserver.wcs2_0.response.MIMETypeMapper;
import org.geoserver.wcs2_0.response.MultidimensionalCoverageResponse;
import org.geoserver.wcs2_0.response.WCSDimensionsHelper;
import org.geoserver.wcs2_0.response.WCSDimensionsSubsetHelper;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geoserver.wcs2_0.util.NCNameResourceCodec;
import org.geoserver.wcs2_0.util.RequestUtils;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.processing.Operation;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Mosaic;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.util.DefaultProgressListener;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.vfny.geoserver.util.WCSUtils;
import org.vfny.geoserver.wcs.WcsException;

public class GetCoverage {
    private static final Hints HINTS = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
    private static final Set<String> mdFormats;
    private static final CoverageProcessor processor;
    private static Logger LOGGER;
    private WCSInfo wcs;
    private Catalog catalog;
    private EnvelopeAxesLabelsMapper envelopeDimensionsMapper;
    private GridCoverageFactory gridCoverageFactory;
    private MIMETypeMapper mimeMapper;
    public static Hints.Key PRE_APPLIED_SCALE;
    private static final double EPS = 1.0E-6;

    public GetCoverage(WCSInfo serviceInfo, Catalog catalog, EnvelopeAxesLabelsMapper envelopeDimensionsMapper, MIMETypeMapper mimeMapper) {
        this.wcs = serviceInfo;
        this.catalog = catalog;
        this.envelopeDimensionsMapper = envelopeDimensionsMapper;
        this.mimeMapper = mimeMapper;
        this.gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
    }

    public static boolean formatSupportMDOutput(String format) {
        return mdFormats.contains(format);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GridCoverage run(GetCoverageType request) {
        LayerInfo linfo;
        Filter filter = WCSUtils.getRequestFilter();
        if (filter != null) {
            request.setFilter(filter);
        }
        if ((linfo = NCNameResourceCodec.getCoverage(this.catalog, request.getCoverageId())) == null) {
            throw new WCS20Exception("Could not locate coverage " + request.getCoverageId(), WCS20Exception.WCS20ExceptionCode.NoSuchCoverage, "coverageId");
        }
        CoverageInfo cinfo = (CoverageInfo)linfo.getResource();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Executing GetCoverage request on coverage :" + linfo.toString());
        }
        if (request.getFormat() == null) {
            try {
                String nativeFormat = this.mimeMapper.mapNativeFormat(cinfo);
                request.setFormat(nativeFormat);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not compute the native type of the coverage, defaulting to image/tiff", e);
            }
        }
        GridCoverage2D coverage = null;
        try {
            Map<String, ExtensionItemType> extensions = this.extractExtensions(request);
            Hints hints = GeoTools.getDefaultHints();
            hints.add((RenderingHints)WCSUtils.getReaderHints((WCSInfo)this.wcs));
            hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
            GridCoverage2DReader reader = (GridCoverage2DReader)cinfo.getGridCoverageReader((ProgressListener)new DefaultProgressListener(), hints);
            WCSDimensionsSubsetHelper helper = this.parseGridCoverageRequest(cinfo, reader, request, extensions);
            GridCoverageRequest gcr = helper.getGridCoverageRequest();
            GridCoverageFactory coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)hints);
            if (reader instanceof StructuredGridCoverage2DReader && GetCoverage.formatSupportMDOutput(request.getFormat())) {
                Set<GridCoverageRequest> requests = helper.splitRequestToSet();
                if (requests == null) throw new IllegalArgumentException("Splitting requests returned nothing");
                if (requests.isEmpty()) {
                    throw new IllegalArgumentException("Splitting requests returned nothing");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Splitting request generated " + requests.size() + " sub requests");
                }
                List<DimensionBean> dimensions = helper.setupDimensions();
                String nativeName = cinfo.getNativeCoverageName();
                String coverageName = nativeName != null ? nativeName : reader.getGridCoverageNames()[0];
                GranuleStackImpl stack = new GranuleStackImpl(coverageName, cinfo.getCRS(), dimensions);
                long outputLimit = this.wcs.getMaxOutputMemory() * 1024L;
                long inputLimit = this.wcs.getMaxInputMemory() * 1024L;
                ImageSizeRecorder incrementalOutputSize = new ImageSizeRecorder(outputLimit, false);
                ImageSizeRecorder incrementalInputSize = new ImageSizeRecorder(inputLimit, true);
                int numRequests = requests.size();
                Iterator<GridCoverageRequest> requestsIterator = requests.iterator();
                GridCoverageRequest firstRequest = requestsIterator.next();
                GridCoverage2D firstCoverage = this.setupCoverage(helper, firstRequest, request, reader, hints, extensions, dimensions, incrementalOutputSize, incrementalInputSize, coverageFactory);
                long actual = incrementalInputSize.finalSize();
                long estimatedSize = actual * (long)numRequests;
                if (outputLimit > 0L && estimatedSize > outputLimit) {
                    throw new WcsException("This request is trying to generate too much data, the limit is " + GetCoverage.formatBytes(outputLimit) + " but the estimated amount of bytes to be written in the output is " + GetCoverage.formatBytes(estimatedSize));
                }
                stack.addCoverage(firstCoverage);
                while (requestsIterator.hasNext()) {
                    GridCoverageRequest subRequest = requestsIterator.next();
                    GridCoverage2D singleCoverage = this.setupCoverage(helper, subRequest, request, reader, hints, extensions, dimensions, incrementalOutputSize, incrementalInputSize, coverageFactory);
                    stack.addCoverage(singleCoverage);
                }
                coverage = stack;
            } else {
                coverage = this.setupCoverage(helper, gcr, request, reader, hints, extensions, null, null, null, coverageFactory);
            }
            if (coverage == null) return coverage;
        }
        catch (ServiceException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new WCS20Exception("Failed to read the coverage " + request.getCoverageId(), e2);
                }
            }
            catch (Throwable throwable) {
                if (coverage == null) throw throwable;
                CoverageCleanerCallback.addCoverages((GridCoverage[])new GridCoverage[]{coverage});
                throw throwable;
            }
        }
        CoverageCleanerCallback.addCoverages((GridCoverage[])new GridCoverage[]{coverage});
        return coverage;
    }

    private GridCoverage2D setupCoverage(WCSDimensionsSubsetHelper helper, GridCoverageRequest gridCoverageRequest, GetCoverageType coverageType, GridCoverage2DReader reader, Hints hints, Map<String, ExtensionItemType> extensions, List<DimensionBean> coverageDimensions, ImageSizeRecorder incrementalOutputSize, ImageSizeRecorder incrementalInputSize, GridCoverageFactory coverageFactory) throws Exception {
        GridCoverage2D scaled;
        double[] preAppliedScale = new double[]{Double.NaN, Double.NaN};
        ScalingType scaling = this.extractScaling(extensions);
        List<GridCoverage2D> coverages = this.readCoverage(helper, gridCoverageRequest, reader, hints, incrementalInputSize, scaling, preAppliedScale);
        GridSampleDimension[] sampleDimensions = this.collectDimensions(coverages);
        if (coverages == null || coverages.isEmpty()) {
            this.throwFailedReadException(coverageType.getCoverageId(), reader, helper.getGridCoverageRequest(), helper.getCoverageInfo());
        }
        for (int i = 0; i < coverages.size(); ++i) {
            GridCoverage2D rangeSubsetted = this.handleRangeSubsettingExtension(coverages.get(i), extensions, hints);
            coverages.set(i, rangeSubsetted);
        }
        ArrayList<GridCoverage2D> temp = new ArrayList<GridCoverage2D>();
        for (GridCoverage2D gridCoverage2D : coverages) {
            List<GridCoverage2D> subsetted = this.handleSubsettingExtension(gridCoverage2D, gridCoverageRequest.getSpatialSubset());
            temp.addAll(subsetted);
        }
        coverages = temp;
        for (int i = 0; i < coverages.size(); ++i) {
            GridCoverage2D reprojected = this.handleReprojection(coverages.get(i), gridCoverageRequest.getOutputCRS(), gridCoverageRequest.getSpatialInterpolation(), hints);
            coverages.set(i, reprojected);
        }
        GridCoverage2D coverage = this.mosaicCoverages(coverages, hints);
        coverage = scaled = this.handleScaling(coverage, scaling, gridCoverageRequest.getSpatialInterpolation(), preAppliedScale, hints);
        boolean enforceLatLonAxesOrder = this.requestingLatLonAxesOrder(gridCoverageRequest.getOutputCRS());
        if (this.wcs.isLatLon() && enforceLatLonAxesOrder) {
            coverage = this.enforceLatLongOrder(coverage, hints, gridCoverageRequest.getOutputCRS());
        }
        if (incrementalOutputSize == null) {
            WCSUtils.checkOutputLimits((WCSInfo)this.wcs, (GridEnvelope2D)coverage.getGridGeometry().getGridRange2D(), (SampleModel)coverage.getRenderedImage().getSampleModel());
        } else {
            incrementalOutputSize.addSize(coverage);
        }
        if (reader instanceof StructuredGridCoverage2DReader && coverageDimensions != null) {
            HashMap<String, Object> map = coverage.getProperties();
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            for (DimensionBean coverageDimension : coverageDimensions) {
                helper.setCoverageDimensionProperty(map, gridCoverageRequest, coverageDimension);
            }
            coverage = coverageFactory.create((CharSequence)coverage.getName(), coverage.getRenderedImage(), coverage.getEnvelope(), coverage.getSampleDimensions(), null, map);
        }
        if (sampleDimensions != null && sampleDimensions.length > 0) {
            coverage = CoverageDimensionCustomizerReader.GridCoverageWrapper.wrapCoverage((GridCoverage2D)coverage, (GridCoverage2D)coverage, (GridSampleDimension[])sampleDimensions, null, (boolean)true);
        }
        return coverage;
    }

    private void throwFailedReadException(String coverageId, GridCoverage2DReader reader, GridCoverageRequest request, CoverageInfo coverageInfo) throws Exception {
        WCSDimensionsHelper helper = WCSDimensionsHelper.getWCSDimensionsHelper(coverageId, coverageInfo, reader);
        if (helper != null) {
            ReaderDimensionsAccessor accessor = helper.getDimensionAccessor();
            DateRange requestedTimeSubset = request.getTemporalSubset();
            DimensionInfo timeDimension = helper.getTimeDimension();
            if (requestedTimeSubset != null && timeDimension != null && timeDimension.isEnabled()) {
                this.checkTimeDomainIntersection(helper, accessor, requestedTimeSubset, timeDimension);
            }
            NumberRange<?> requestedElevationRange = request.getElevationSubset();
            DimensionInfo elevationDimension = helper.getElevationDimension();
            if (requestedElevationRange != null && elevationDimension != null && elevationDimension.isEnabled()) {
                this.checkElevationDomainIntersection(helper, accessor, requestedElevationRange, elevationDimension);
            }
            if (request.getDimensionsSubset() != null && !request.getDimensionsSubset().isEmpty()) {
                this.checkCustomDomainIntersection(reader, request, accessor);
            }
        }
        throw new WCS20Exception("Unable to read a coverage for the current request (could be due to filtering or subsetting): " + request, WCS20Exception.WCS20ExceptionCode.NoApplicableCode, null);
    }

    private void checkCustomDomainIntersection(GridCoverage2DReader reader, GridCoverageRequest request, ReaderDimensionsAccessor accessor) throws IOException {
        Set dynamicParameters = reader.getDynamicParameters();
        for (ParameterDescriptor dynamicParameter : dynamicParameters) {
            List actualValues;
            String name = dynamicParameter.getName().getCode();
            List<Object> requestedValues = request.getDimensionsSubset().get(name);
            if (requestedValues == null || requestedValues.isEmpty() || !Collections.disjoint(actualValues = accessor.getDomain(name), requestedValues)) continue;
            throw new WCS20Exception("Requested " + name + " subset does not intersect the available values " + actualValues, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
        }
    }

    private void checkElevationDomainIntersection(WCSDimensionsHelper helper, ReaderDimensionsAccessor accessor, NumberRange<?> requestedElevationRange, DimensionInfo elevationDimension) throws IOException {
        NumberRange actualElevationSubset = new NumberRange(Double.class, (Number)accessor.getMinElevation(), (Number)accessor.getMaxElevation());
        if (!requestedElevationRange.intersects((Range)actualElevationSubset)) {
            throw new WCS20Exception("Requested elevation subset does not intersect the declared range " + helper.getBeginElevation() + "/" + helper.getEndElevation(), WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
        }
        DimensionPresentation presentation = elevationDimension.getPresentation();
        if (requestedElevationRange.getMinimum() < requestedElevationRange.getMaximum() && (presentation == DimensionPresentation.LIST || presentation == DimensionPresentation.CONTINUOUS_INTERVAL)) {
            TreeSet elevationDomain = accessor.getElevationDomain();
            boolean intersectionFound = false;
            for (Object o : elevationDomain) {
                if (o instanceof Number) {
                    intersectionFound |= requestedElevationRange.contains((Comparable)o);
                } else if (o instanceof NumberRange) {
                    intersectionFound |= requestedElevationRange.intersects((Range)o);
                }
                if (!intersectionFound) continue;
                break;
            }
            if (!intersectionFound) {
                throw new WCS20Exception("Requested elevation subset does not intersect available values " + elevationDomain, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
            }
        }
    }

    private void checkTimeDomainIntersection(WCSDimensionsHelper helper, ReaderDimensionsAccessor accessor, DateRange requestedTimeSubset, DimensionInfo timeDimension) throws IOException {
        DateRange actualTimeSubset = new DateRange(accessor.getMinTime(), accessor.getMaxTime());
        if (!requestedTimeSubset.intersects((Range)actualTimeSubset)) {
            throw new WCS20Exception("Requested time subset does not intersect the declared range " + helper.getBeginTime() + "/" + helper.getEndTime(), WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
        }
        DimensionPresentation presentation = timeDimension.getPresentation();
        if (!(requestedTimeSubset.getMinValue().equals(requestedTimeSubset.getMaxValue()) || presentation != DimensionPresentation.LIST && presentation != DimensionPresentation.CONTINUOUS_INTERVAL)) {
            TreeSet timeDomain = accessor.getTimeDomain();
            boolean intersectionFound = false;
            for (Object o2 : timeDomain) {
                if (o2 instanceof Date) {
                    intersectionFound |= requestedTimeSubset.contains((Comparable)((Date)o2));
                } else if (o2 instanceof DateRange) {
                    intersectionFound |= requestedTimeSubset.intersects((Range)o2);
                }
                if (!intersectionFound) continue;
                break;
            }
            if (!intersectionFound) {
                List formattedDomain = timeDomain.stream().map(o -> helper.format(o)).collect(Collectors.toList());
                throw new WCS20Exception("Requested time subset does not intersect available values " + formattedDomain, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
            }
        }
    }

    private ScalingType extractScaling(Map<String, ExtensionItemType> extensions) {
        ScalingType scaling = null;
        if (extensions != null && !extensions.isEmpty() && extensions.containsKey("Scaling")) {
            ExtensionItemType extensionItem = extensions.get("Scaling");
            assert (extensionItem != null);
            scaling = (ScalingType)extensionItem.getObjectContent();
            if (scaling == null) {
                throw new IllegalStateException("Scaling extension contained a null ScalingType");
            }
        }
        return scaling;
    }

    private GridSampleDimension[] collectDimensions(List<GridCoverage2D> coverages) {
        ArrayList<GridSampleDimension> dimensions = new ArrayList<GridSampleDimension>();
        for (GridCoverage2D coverage : coverages) {
            if (!(coverage instanceof CoverageDimensionCustomizerReader.GridCoverageWrapper)) continue;
            for (GridSampleDimension dimension : coverage.getSampleDimensions()) {
                dimensions.add(dimension);
            }
        }
        return dimensions.toArray(new GridSampleDimension[dimensions.size()]);
    }

    private GridCoverage2D mosaicCoverages(List<GridCoverage2D> coverages, Hints hints) throws FactoryException, TransformException {
        GridCoverage2D first = coverages.get(0);
        if (coverages.size() == 1) {
            return first;
        }
        CoordinateReferenceSystem crs = first.getCoordinateReferenceSystem2D();
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)crs);
        if (crs instanceof GeographicCRS || mapProjection instanceof Mercator) {
            double offset = crs instanceof GeographicCRS ? 360.0 : this.computeMercatorWorldSpan(crs, mapProjection);
            for (int i = 1; i < coverages.size(); ++i) {
                GridCoverage2D c = coverages.get(i);
                if (!(Math.abs(c.getEnvelope().getMinimum(0) + offset - first.getEnvelope().getMaximum(0)) < 1.0E-6)) continue;
                GridCoverage2D displaced = this.displaceCoverage(coverages.get(1), offset);
                coverages.set(i, displaced);
            }
        }
        try {
            ParameterValueGroup param = processor.getOperation("Mosaic").getParameters();
            param.parameter("sources").setValue(coverages);
            param.parameter("policy").setValue((Object)Mosaic.GridGeometryPolicy.FIRST.name());
            return (GridCoverage2D)((Mosaic)processor.getOperation("Mosaic")).doOperation(param, hints);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to mosaic the input coverages", e);
        }
    }

    private GridCoverage2D displaceCoverage(GridCoverage2D coverage, double offset) {
        GridGeometry2D originalGG = coverage.getGridGeometry();
        GridEnvelope gridRange = originalGG.getGridRange();
        ReferencedEnvelope envelope = originalGG.getEnvelope2D();
        double minx = envelope.getMinX() + offset;
        double miny = envelope.getMinY();
        double maxx = envelope.getMaxX() + offset;
        double maxy = envelope.getMaxY();
        ReferencedEnvelope translatedEnvelope = new ReferencedEnvelope(minx, maxx, miny, maxy, envelope.getCoordinateReferenceSystem());
        GridGeometry2D translatedGG = new GridGeometry2D(gridRange, (Bounds)translatedEnvelope);
        GridCoverage2D translatedCoverage = this.gridCoverageFactory.create((CharSequence)coverage.getName(), coverage.getRenderedImage(), translatedGG, coverage.getSampleDimensions(), (GridCoverage[])new GridCoverage2D[]{coverage}, coverage.getProperties());
        return translatedCoverage;
    }

    private double computeMercatorWorldSpan(CoordinateReferenceSystem crs, MapProjection mapProjection) throws FactoryException, TransformException {
        double centralMeridian = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
        double[] src = new double[]{centralMeridian, 0.0, 180.0 + centralMeridian, 0.0};
        double[] dst = new double[4];
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs);
        mt.transform(src, 0, dst, 0, 2);
        double worldSpan = Math.abs(dst[2] - dst[0]);
        return worldSpan;
    }

    private WCSDimensionsSubsetHelper parseGridCoverageRequest(CoverageInfo ci, GridCoverage2DReader reader, GetCoverageType request, Map<String, ExtensionItemType> extensions) throws IOException {
        ReferencedEnvelope nativeBoundingBox;
        CoordinateReferenceSystem subsettingCRS = this.extractSubsettingCRS(ci, extensions);
        CoordinateReferenceSystem outputCRS = this.extractOutputCRS(reader, extensions, subsettingCRS);
        WCSDimensionsSubsetHelper subsetHelper = new WCSDimensionsSubsetHelper(reader, request, ci, subsettingCRS, this.envelopeDimensionsMapper);
        GridCoverageRequest requestSubset = subsetHelper.createGridCoverageRequestSubset();
        Map<String, InterpolationPolicy> axesInterpolations = this.extractInterpolation(ci, extensions);
        try {
            nativeBoundingBox = ci.boundingBox();
        }
        catch (Exception noNativeBounds) {
            throw new IllegalStateException("Unable to determine axes names as native extent not determined: " + noNativeBounds.getMessage(), noNativeBounds);
        }
        Interpolation spatialInterpolation = this.extractSpatialInterpolation(axesInterpolations, (Bounds)nativeBoundingBox);
        OverviewPolicy overviewPolicy = this.extractOverviewPolicy(extensions);
        assert (spatialInterpolation != null);
        GridCoverageRequest gcr = new GridCoverageRequest();
        gcr.setOutputCRS(outputCRS);
        gcr.setSpatialInterpolation(spatialInterpolation);
        gcr.setSpatialSubset(requestSubset.getSpatialSubset());
        gcr.setTemporalSubset(requestSubset.getTemporalSubset());
        gcr.setElevationSubset(requestSubset.getElevationSubset());
        gcr.setDimensionsSubset(requestSubset.getDimensionsSubset());
        gcr.setFilter(request.getFilter());
        gcr.setSortBy((List<SortBy>)request.getSortBy());
        gcr.setOverviewPolicy(overviewPolicy);
        subsetHelper.setGridCoverageRequest(gcr);
        return subsetHelper;
    }

    private OverviewPolicy extractOverviewPolicy(Map<String, ExtensionItemType> extensions) {
        if (extensions == null || extensions.isEmpty() || !extensions.containsKey("OverviewPolicy")) {
            return null;
        }
        ExtensionItemType extensionItem = extensions.get("OverviewPolicy");
        if (extensionItem.getName().equals("OverviewPolicy")) {
            String overviewPolicy = extensionItem.getSimpleContent();
            if (overviewPolicy == null) {
                throw new WCS20Exception("OverviewPolicy was null", WCS20Exception.WCS20ExceptionCode.MissingParameterValue, "null");
            }
            try {
                return OverviewPolicy.valueOf((String)overviewPolicy);
            }
            catch (Exception e) {
                WCS20Exception exception = new WCS20Exception("Invalid OverviewPolicy", WCS20Exception.WCS20ExceptionCode.InvalidParameterValue, overviewPolicy);
                exception.initCause(e);
                throw exception;
            }
        }
        return null;
    }

    private GridCoverage2D enforceLatLongOrder(GridCoverage2D coverage, Hints hints, CoordinateReferenceSystem outputCRS) throws Exception {
        String identifier = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)outputCRS, (boolean)false);
        if (identifier != null) {
            CoordinateReferenceSystem finalCRS = CRS.decode((String)SrsSyntax.OGC_HTTP_URI.getSRS(identifier));
            if (CRS.getAxisOrder((CoordinateReferenceSystem)outputCRS).equals((Object)CRS.getAxisOrder((CoordinateReferenceSystem)finalCRS))) {
                return coverage;
            }
            AffineTransform g2w = new AffineTransform((AffineTransform)((AffineTransform2D)coverage.getGridGeometry().getGridToCRS2D()));
            g2w.preConcatenate(CoverageUtilities.AXES_SWAP);
            GridGeometry2D finalGG = new GridGeometry2D(coverage.getGridGeometry().getGridRange(), PixelInCell.CELL_CENTER, (MathTransform)new AffineTransform2D(g2w), finalCRS, hints);
            coverage = CoverageFactoryFinder.getGridCoverageFactory((Hints)hints).create((CharSequence)coverage.getName(), coverage.getRenderedImage(), finalGG, coverage.getSampleDimensions(), new GridCoverage[]{coverage}, coverage.getProperties());
        }
        return coverage;
    }

    private boolean requestingLatLonAxesOrder(CoordinateReferenceSystem outputCRS) {
        try {
            String identifier = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)outputCRS, (boolean)false);
            if (identifier != null) {
                CoordinateReferenceSystem originalCRS = CRS.decode((String)SrsSyntax.OGC_HTTP_URI.getSRS(identifier));
                return !CRS.getAxisOrder((CoordinateReferenceSystem)originalCRS).equals((Object)CRS.getAxisOrder((CoordinateReferenceSystem)outputCRS));
            }
        }
        catch (FactoryException e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
            return false;
        }
        return false;
    }

    private Interpolation extractSpatialInterpolation(Map<String, InterpolationPolicy> axesInterpolations, Bounds envelope) {
        Interpolation interpolation = InterpolationPolicy.getDefaultPolicy().getInterpolation();
        for (String axisLabel : axesInterpolations.keySet()) {
            int index = this.envelopeDimensionsMapper.getAxisIndex(envelope, axisLabel);
            if (index != 0 && index != 1) continue;
            interpolation = axesInterpolations.get(axisLabel).getInterpolation();
            break;
        }
        return interpolation;
    }

    private List<GridCoverage2D> readCoverage(WCSDimensionsSubsetHelper helper, GridCoverageRequest request, GridCoverage2DReader reader, Hints hints, ImageSizeRecorder incrementalInputSize, ScalingType scaling, double[] preAppliedScale) throws Exception {
        CoverageInfo cinfo = helper.getCoverageInfo();
        WCSEnvelope requestedEnvelope = helper.getRequestedEnvelope();
        Interpolation spatialInterpolation = request.getSpatialInterpolation();
        Utilities.ensureNonNull((String)"interpolation", (Object)spatialInterpolation);
        CoordinateReferenceSystem readerCRS = reader.getCoordinateReferenceSystem();
        WCSEnvelope subset = request.getSpatialSubset();
        ArrayList<GridCoverage2D> result = new ArrayList<GridCoverage2D>();
        ArrayList<GeneralBounds> readEnvelopes = new ArrayList<GeneralBounds>();
        if (subset.isCrossingDateline()) {
            GeneralBounds[] envelopes = subset.getNormalizedEnvelopes();
            this.addEnvelopes((Bounds)envelopes[0], readEnvelopes, readerCRS);
            this.addEnvelopes((Bounds)envelopes[1], readEnvelopes, readerCRS);
        } else {
            this.addEnvelopes((Bounds)subset, readEnvelopes, readerCRS);
        }
        ArrayList<GridCoverage2D> readCoverages = new ArrayList<GridCoverage2D>();
        for (GeneralBounds readEnvelope : readEnvelopes) {
            GeneralBounds padEnvelope = this.computePadEnvelope(readEnvelope, reader, cinfo);
            GridCoverage2D cov = null;
            ReferencedEnvelope readBoundingBox = new ReferencedEnvelope((Bounds)readEnvelope);
            for (GridCoverage2D gc : readCoverages) {
                ReferencedEnvelope gce = gc.getEnvelope2D();
                if (!gce.contains((BoundingBox)readBoundingBox)) continue;
                cov = gc;
                break;
            }
            if (cov == null) {
                cov = this.readCoverage(cinfo, request, reader, hints, incrementalInputSize, spatialInterpolation, readerCRS, (Bounds)readEnvelope, requestedEnvelope, scaling, preAppliedScale);
                if (cov == null) continue;
                readCoverages.add(cov);
            }
            GridCoverage2D padded = cov;
            Bounds croppedEnvelope = cov.getEnvelope();
            if (!new GeneralBounds(croppedEnvelope).contains((Bounds)padEnvelope, true)) {
                padded = this.padOnEnvelope(cov, padEnvelope);
            }
            if (padded == null) continue;
            result.add(padded);
        }
        return result;
    }

    private GeneralBounds computePadEnvelope(GeneralBounds readEnvelope, GridCoverage2DReader reader, CoverageInfo cinfo) {
        CoordinateReferenceSystem sourceCRS = reader.getCoordinateReferenceSystem();
        CoordinateReferenceSystem subsettingCRS = readEnvelope.getCoordinateReferenceSystem();
        try {
            if (!CRS.equalsIgnoreMetadata((Object)subsettingCRS, (Object)sourceCRS)) {
                readEnvelope = CRS.transform((Bounds)readEnvelope, (CoordinateReferenceSystem)sourceCRS);
            }
        }
        catch (TransformException e) {
            throw new WCS20Exception("Unable to initialize subsetting envelope", WCS20Exception.WCS20ExceptionCode.SubsettingCrsNotSupported, subsettingCRS.toWKT(), e);
        }
        GeneralBounds padEnvelope = new GeneralBounds((Bounds)readEnvelope);
        return padEnvelope;
    }

    private void addEnvelopes(Bounds envelope, List<GeneralBounds> readEnvelopes, CoordinateReferenceSystem readerCRS) throws TransformException, FactoryException {
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)new ReferencedEnvelope(envelope), (CoordinateReferenceSystem)readerCRS, (boolean)true);
        if (handler == null) {
            readEnvelopes.add(new GeneralBounds(envelope));
        } else {
            List queryEnvelopes = handler.getQueryEnvelopes();
            for (ReferencedEnvelope qe : queryEnvelopes) {
                readEnvelopes.add(new GeneralBounds((Bounds)qe));
            }
        }
    }

    private GridCoverage2D readCoverage(CoverageInfo cinfo, GridCoverageRequest request, GridCoverage2DReader reader, Hints hints, ImageSizeRecorder incrementalInputSize, Interpolation spatialInterpolation, CoordinateReferenceSystem coverageCRS, Bounds subset, WCSEnvelope requestedEnvelope, ScalingType scaling, double[] preAppliedScale) throws TransformException, IOException, NoninvertibleTransformException {
        GridGeometry2D readGG;
        ArrayList descriptors;
        boolean sameCRS;
        if (!CRS.equalsIgnoreMetadata((Object)subset.getCoordinateReferenceSystem(), (Object)coverageCRS)) {
            subset = CRS.transform((Bounds)subset, (CoordinateReferenceSystem)coverageCRS);
        }
        CoordinateReferenceSystem outputCRS = request.getOutputCRS();
        boolean equalsMetadata = CRS.equalsIgnoreMetadata((Object)outputCRS, (Object)coverageCRS);
        try {
            sameCRS = equalsMetadata ? true : CRS.findMathTransform((CoordinateReferenceSystem)outputCRS, (CoordinateReferenceSystem)reader.getCoordinateReferenceSystem(), (boolean)true).isIdentity();
        }
        catch (FactoryException e1) {
            IOException ioe = new IOException();
            ioe.initCause(e1);
            throw ioe;
        }
        ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
        GeneralParameterValue[] readParameters = CoverageUtils.getParameters((ParameterValueGroup)readParametersDescriptor, (Map)cinfo.getParameters());
        readParameters = readParameters != null ? readParameters : new GeneralParameterValue[]{};
        readParameters = WCSUtils.replaceParameter((GeneralParameterValue[])readParameters, (Object)Boolean.TRUE, (ParameterDescriptor)AbstractGridFormat.USE_JAI_IMAGEREAD);
        if (request.getTemporalSubset() != null) {
            descriptors = readParametersDescriptor.getDescriptor().descriptors();
            ArrayList<DateRange> times = new ArrayList<DateRange>();
            times.add(request.getTemporalSubset());
            readParameters = CoverageUtils.mergeParameter(descriptors, (GeneralParameterValue[])readParameters, times, (String[])new String[]{"TIME", "Time"});
        }
        if (request.getElevationSubset() != null) {
            descriptors = readParametersDescriptor.getDescriptor().descriptors();
            ArrayList elevations = new ArrayList();
            elevations.add(request.getElevationSubset());
            readParameters = CoverageUtils.mergeParameter(descriptors, (GeneralParameterValue[])readParameters, elevations, (String[])new String[]{"ELEVATION", "Elevation"});
        }
        if (request.getFilter() != null) {
            descriptors = readParametersDescriptor.getDescriptor().descriptors();
            readParameters = CoverageUtils.mergeParameter((List)descriptors, (GeneralParameterValue[])readParameters, (Object)request.getFilter(), (String[])new String[]{"Filter"});
        }
        if (request.getSortBy() != null) {
            descriptors = readParametersDescriptor.getDescriptor().descriptors();
            String sortBySpec = request.getSortBy().stream().map(sb -> sb.getPropertyName().getPropertyName() + " " + sb.getSortOrder().name().charAt(0)).collect(Collectors.joining(","));
            readParameters = CoverageUtils.mergeParameter(descriptors, (GeneralParameterValue[])readParameters, (Object)sortBySpec, (String[])new String[]{"SORTING"});
        }
        if (request.getDimensionsSubset() != null && !request.getDimensionsSubset().isEmpty()) {
            descriptors = new ArrayList(readParametersDescriptor.getDescriptor().descriptors());
            Set dynamicParameters = reader.getDynamicParameters();
            descriptors.addAll(dynamicParameters);
            Map<String, List<Object>> dimensionsSubset = request.getDimensionsSubset();
            Set<String> dimensionKeys = dimensionsSubset.keySet();
            for (String key : dimensionKeys) {
                List<Object> dimValues = dimensionsSubset.get(key);
                readParameters = CoverageUtils.mergeParameter(descriptors, (GeneralParameterValue[])readParameters, dimValues, (String[])new String[]{key});
            }
        }
        if (sameCRS) {
            MathTransform transform = this.getMathTransform(cinfo, reader, (Bounds)(requestedEnvelope != null ? requestedEnvelope : subset), request, PixelInCell.CELL_CENTER, scaling);
            readGG = new GridGeometry2D(PixelInCell.CELL_CENTER, transform, subset, hints);
        } else {
            Rectangle rasterRange = CRS.transform((MathTransform)reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER).inverse(), (Bounds)subset).toRectangle2D().getBounds();
            rasterRange.setBounds(rasterRange.x - 10, rasterRange.y - 10, rasterRange.width + 20, rasterRange.height + 20);
            rasterRange = rasterRange.intersection((Rectangle)((GridEnvelope2D)reader.getOriginalGridRange()));
            readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(rasterRange), PixelInCell.CELL_CENTER, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), coverageCRS, hints);
        }
        WCSUtils.checkInputLimits((WCSInfo)this.wcs, (CoverageInfo)cinfo, (GridCoverage2DReader)reader, (GridGeometry2D)readGG);
        Hints readHints = new Hints();
        if (hints != null) {
            readHints.putAll((Map)hints);
        }
        if (request.getOverviewPolicy() != null) {
            readHints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)request.getOverviewPolicy()));
        }
        if (readGG.getGridRange().getSpan(0) <= 0 || readGG.getGridRange().getSpan(1) <= 0) {
            return null;
        }
        GridCoverage2D coverage = RequestUtils.readBestCoverage(cinfo, reader, readParameters, readGG, spatialInterpolation, request.getOverviewPolicy(), readHints);
        if (coverage != null) {
            if (WCSUtils.isDeferredLoaded((GridCoverage2D)coverage)) {
                coverage = this.cropCoverage(coverage, subset);
                this.checkInputLimits(incrementalInputSize, coverage);
            } else {
                this.checkInputLimits(incrementalInputSize, coverage);
                coverage = this.cropCoverage(coverage, subset);
            }
            if (scaling != null) {
                MathTransform cmt = coverage.getGridGeometry().getGridToCRS();
                MathTransform2D rmt = WCSUtils.fitGridGeometry((CoverageInfo)cinfo, (GridCoverage2DReader)reader).getGridToCRS2D();
                if (!(cmt instanceof AffineTransform2D) || !(rmt instanceof AffineTransform2D)) {
                    LOGGER.log(Level.FINE, "Cannot check if the returned coverage matched the requested resolution due to a non affine grid to world backing it");
                } else {
                    AffineTransform2D cat = (AffineTransform2D)cmt;
                    AffineTransform2D rat = (AffineTransform2D)rmt;
                    preAppliedScale[0] = cat.getScaleX() / rat.getScaleX();
                    preAppliedScale[1] = cat.getScaleY() / rat.getScaleY();
                }
            }
        }
        return coverage;
    }

    private void checkInputLimits(ImageSizeRecorder incrementalInputSize, GridCoverage2D coverage) {
        if (incrementalInputSize == null) {
            WCSUtils.checkInputLimits((WCSInfo)this.wcs, (GridCoverage2D)coverage);
        } else {
            incrementalInputSize.addSize(coverage);
        }
    }

    private GridCoverage2D cropCoverage(GridCoverage2D coverage, Bounds subset) {
        ReferencedEnvelope readBoundingBox = ReferencedEnvelope.reference((Bounds)subset);
        ReferencedEnvelope covEnvelope = coverage.getEnvelope2D();
        GridCoverage2D cropped = coverage;
        if (covEnvelope.contains(readBoundingBox) && (covEnvelope.getWidth() > readBoundingBox.getWidth() || covEnvelope.getHeight() > readBoundingBox.getHeight())) {
            cropped = this.cropOnEnvelope(coverage, subset);
        }
        return cropped;
    }

    MathTransform getMathTransform(CoverageInfo ci, GridCoverage2DReader reader, Bounds subset, GridCoverageRequest request, PixelInCell pixelInCell, ScalingType scaling) throws IOException {
        ScalingPolicy scalingPolicy;
        ScalingPolicy scalingPolicy2 = scalingPolicy = scaling == null ? null : ScalingPolicy.getPolicy(scaling);
        if (scalingPolicy == null || scalingPolicy == ScalingPolicy.DoNothing) {
            return reader.getOriginalGridToWorld(pixelInCell);
        }
        MathTransform transform = reader.getOriginalGridToWorld(pixelInCell);
        AffineTransform af = (AffineTransform)transform;
        double nativeResX = XAffineTransform.getScaleX0((AffineTransform)af);
        double nativeResY = XAffineTransform.getScaleY0((AffineTransform)af);
        double[] requestedResolution = this.computeRequestedResolution(scaling, subset, nativeResX, nativeResY);
        AffineTransform scale = new AffineTransform();
        scale.scale(requestedResolution[0] / nativeResX, requestedResolution[1] / nativeResY);
        AffineTransform finalTransform = new AffineTransform(af);
        finalTransform.concatenate(scale);
        return ProjectiveTransform.create((AffineTransform)finalTransform);
    }

    private double[] computeRequestedResolution(ScalingType scaling, Bounds subset, double nativeResX, double nativeResY) {
        ScalingPolicy policy = ScalingPolicy.getPolicy(scaling);
        double[] requestedResolution = new double[2];
        if (policy == ScalingPolicy.ScaleToSize || policy == ScalingPolicy.ScaleToExtent) {
            int[] scalingSize = ScalingPolicy.getTargetSize(scaling);
            GridToEnvelopeMapper mapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(0, 0, scalingSize[0], scalingSize[1]), subset);
            AffineTransform scalingTransform = mapper.createAffineTransform();
            requestedResolution[0] = XAffineTransform.getScaleX0((AffineTransform)scalingTransform);
            requestedResolution[1] = XAffineTransform.getScaleY0((AffineTransform)scalingTransform);
        } else {
            double[] scalingFactors = ScalingPolicy.getScaleFactors(scaling);
            requestedResolution[0] = nativeResX / scalingFactors[0];
            requestedResolution[1] = nativeResY / scalingFactors[1];
        }
        return requestedResolution;
    }

    private CoordinateReferenceSystem extractOutputCRS(GridCoverage2DReader reader, Map<String, ExtensionItemType> extensions, CoordinateReferenceSystem subsettingCRS) {
        return this.extractCRSInternal(extensions, subsettingCRS, true);
    }

    private CoordinateReferenceSystem extractCRSInternal(Map<String, ExtensionItemType> extensions, CoordinateReferenceSystem defaultCRS, boolean isOutputCRS) throws WCS20Exception {
        String identifier;
        Utilities.ensureNonNull((String)"defaultCRS", (Object)defaultCRS);
        String string = identifier = isOutputCRS ? "outputCrs" : "subsettingCrs";
        if (extensions == null || extensions.isEmpty() || !extensions.containsKey(identifier)) {
            return defaultCRS;
        }
        ExtensionItemType extensionItem = extensions.get(identifier);
        if (extensionItem.getName().equals(identifier)) {
            String crsName = extensionItem.getSimpleContent();
            if (crsName == null) {
                throw new WCS20Exception(identifier + " was null", WCS20Exception.WCS20ExceptionCode.NotACrs, "null");
            }
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)crsName);
                String id = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)false);
                if (id != null) {
                    return CRS.decode((String)SrsSyntax.AUTH_CODE.getSRS(id));
                }
                return crs;
            }
            catch (Exception e) {
                WCS20Exception exception = new WCS20Exception("Invalid " + identifier, isOutputCRS ? WCS20Exception.WCS20ExceptionCode.OutputCrsNotSupported : WCS20Exception.WCS20ExceptionCode.SubsettingCrsNotSupported, crsName);
                exception.initCause(e);
                throw exception;
            }
        }
        return defaultCRS;
    }

    private CoordinateReferenceSystem extractSubsettingCRS(CoverageInfo ci, Map<String, ExtensionItemType> extensions) {
        return this.extractCRSInternal(extensions, ci.getCRS(), false);
    }

    private Map<String, ExtensionItemType> extractExtensions(GetCoverageType request) {
        Utilities.ensureNonNull((String)"request", (Object)request);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Extracting extensions from provided request");
        }
        ExtensionType extension = request.getExtension();
        HashMap<String, ExtensionItemType> parsedExtensions = new HashMap<String, ExtensionItemType>();
        if (extension != null) {
            EList extensions = extension.getContents();
            for (ExtensionItemType extensionItem : extensions) {
                String extensionName = extensionItem.getName();
                if (extensionName == null || extensionName.length() <= 0) {
                    throw new WCS20Exception("Null extension");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Parsing extension " + extensionName);
                }
                if (extensionName.equals("subsettingCrs")) {
                    parsedExtensions.put("subsettingCrs", extensionItem);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Added extension subsettingCrs");
                    continue;
                }
                if (extensionName.equals("outputCrs")) {
                    parsedExtensions.put("outputCrs", extensionItem);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Added extension outputCrs");
                    continue;
                }
                if (extensionName.equals("Scaling")) {
                    parsedExtensions.put("Scaling", extensionItem);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Added extension Scaling");
                    continue;
                }
                if (extensionName.equals("Interpolation")) {
                    parsedExtensions.put("Interpolation", extensionItem);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Added extension Interpolation");
                    continue;
                }
                if (extensionName.equals("rangeSubset") || extensionName.equals("RangeSubset")) {
                    parsedExtensions.put("rangeSubset", extensionItem);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Added extension rangeSubset");
                    continue;
                }
                if (!extensionName.equals("OverviewPolicy")) continue;
                parsedExtensions.put("OverviewPolicy", extensionItem);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Added extension overviewPolicy ");
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No extensions found in provided request");
        }
        return parsedExtensions;
    }

    private Map<String, InterpolationPolicy> extractInterpolation(CoverageInfo ci, Map<String, ExtensionItemType> extensions) {
        ReferencedEnvelope nativeBoundingBox;
        HashMap<String, InterpolationPolicy> returnValue = new HashMap<String, InterpolationPolicy>();
        try {
            nativeBoundingBox = ci.boundingBox();
        }
        catch (Exception noNativeBounds) {
            throw new IllegalStateException("Unable to determine axes names as native extent not determined: " + noNativeBounds.getMessage(), noNativeBounds);
        }
        List<String> axesNames = this.envelopeDimensionsMapper.getAxesNames((Bounds)nativeBoundingBox, true);
        for (String axisName : axesNames) {
            returnValue.put(axisName, InterpolationPolicy.getDefaultPolicy());
        }
        if (extensions == null || extensions.isEmpty() || !extensions.containsKey("Interpolation")) {
            return returnValue;
        }
        ExtensionItemType extensionItem = extensions.get("Interpolation");
        InterpolationType interpolationType = (InterpolationType)extensionItem.getObjectContent();
        if (interpolationType.getInterpolationMethod() != null) {
            InterpolationMethodType method = interpolationType.getInterpolationMethod();
            InterpolationPolicy policy = InterpolationPolicy.getPolicy(method);
            for (String axisName : axesNames) {
                returnValue.put(axisName, policy);
            }
        } else if (interpolationType.getInterpolationAxes() != null) {
            ArrayList<String> foundAxes = new ArrayList<String>();
            InterpolationAxesType axes = interpolationType.getInterpolationAxes();
            for (InterpolationAxisType axisInterpolation : axes.getInterpolationAxis()) {
                String axisLabel;
                String method = axisInterpolation.getInterpolationMethod();
                InterpolationPolicy policy = InterpolationPolicy.getPolicy(method);
                String axis = axisInterpolation.getAxis();
                int index = axis.lastIndexOf("/");
                String string = axisLabel = index >= 0 ? axis.substring(index + 1, axis.length()) : axis;
                if (foundAxes.contains(axisLabel)) {
                    throw new WCS20Exception("Duplicated axis", WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel, axisLabel);
                }
                foundAxes.add(axisLabel);
                if (!returnValue.containsKey(axisLabel)) {
                    throw new WCS20Exception("Invalid axes URI", WCS20Exception.WCS20ExceptionCode.NoSuchAxis, axisLabel);
                }
                returnValue.put(axisLabel, policy);
            }
        }
        InterpolationPolicy lat = null;
        InterpolationPolicy lon = null;
        if (returnValue.containsKey("Long")) {
            lon = (InterpolationPolicy)((Object)returnValue.get("Long"));
        }
        if (returnValue.containsKey("Lat")) {
            lat = (InterpolationPolicy)((Object)returnValue.get("Lat"));
        }
        if (lat != lon) {
            throw new WCS20Exception("We don't support different interpolations on Lat,Lon", WCS20Exception.WCS20ExceptionCode.InterpolationMethodNotSupported, "");
        }
        returnValue.get("Lat");
        return returnValue;
    }

    private GridCoverage2D handleReprojection(GridCoverage2D coverage, CoordinateReferenceSystem targetCRS, Interpolation spatialInterpolation, Hints hints) {
        Utilities.ensureNonNull((String)"interpolation", (Object)spatialInterpolation);
        if (CRS.equalsIgnoreMetadata((Object)coverage.getCoordinateReferenceSystem2D(), (Object)targetCRS)) {
            return coverage;
        }
        CoverageProcessor processor = hints == null ? CoverageProcessor.getInstance() : CoverageProcessor.getInstance((Hints)hints);
        Operation operation = processor.getOperation("Resample");
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)coverage);
        parameters.parameter("CoordinateReferenceSystem").setValue((Object)targetCRS);
        parameters.parameter("GridGeometry").setValue(null);
        parameters.parameter("InterpolationType").setValue((Object)spatialInterpolation);
        return (GridCoverage2D)processor.doOperation(parameters);
    }

    private GridCoverage2D handleRangeSubsettingExtension(GridCoverage2D coverage, Map<String, ExtensionItemType> extensions, Hints hints) {
        ArrayList<String> returnValue = new ArrayList<String>();
        if (extensions == null || extensions.isEmpty() || !extensions.containsKey("rangeSubset")) {
            return coverage;
        }
        GridSampleDimension[] bands = coverage.getSampleDimensions();
        ArrayList<String> bandsNames = new ArrayList<String>();
        for (GridSampleDimension band : bands) {
            bandsNames.add(band.getDescription().toString());
        }
        ExtensionItemType extensionItem = extensions.get("rangeSubset");
        assert (extensionItem != null);
        RangeSubsetType range = (RangeSubsetType)extensionItem.getObjectContent();
        for (RangeItemType rangeItem : range.getRangeItems()) {
            String rangeComponent = rangeItem.getRangeComponent();
            if (rangeComponent == null) {
                RangeIntervalType rangeInterval = rangeItem.getRangeInterval();
                String startRangeComponent = rangeInterval.getStartComponent();
                String endRangeComponent = rangeInterval.getEndComponent();
                if (!bandsNames.contains(startRangeComponent)) {
                    throw new WCS20Exception("Invalid Band Name", WCS20Exception.WCS20ExceptionCode.NoSuchField, rangeComponent);
                }
                if (!bandsNames.contains(endRangeComponent)) {
                    throw new WCS20Exception("Invalid Band Name", WCS20Exception.WCS20ExceptionCode.NoSuchField, rangeComponent);
                }
                boolean add = false;
                for (GridSampleDimension sd : bands) {
                    if (!(sd instanceof GridSampleDimension)) continue;
                    GridSampleDimension band = sd;
                    String name = band.getDescription().toString();
                    if (name.equals(startRangeComponent)) {
                        returnValue.add(startRangeComponent);
                        add = true;
                        continue;
                    }
                    if (name.equals(endRangeComponent)) {
                        returnValue.add(endRangeComponent);
                        add = false;
                        continue;
                    }
                    if (!add) continue;
                    returnValue.add(name);
                }
                if (!add) continue;
                throw new IllegalStateException("Unable to close range in band identifiers");
            }
            if (bandsNames.contains(rangeComponent)) {
                returnValue.add(rangeComponent);
                continue;
            }
            throw new WCS20Exception("Invalid Band Name", WCS20Exception.WCS20ExceptionCode.NoSuchField, rangeComponent);
        }
        if (returnValue.isEmpty()) {
            return coverage;
        }
        int[] indexes = new int[returnValue.size()];
        int i = 0;
        for (String bandName : returnValue) {
            indexes[i++] = bandsNames.indexOf(bandName);
        }
        if (coverage.getNumSampleDimensions() < indexes.length) {
            WCSUtils.checkOutputLimits((WCSInfo)this.wcs, (GridCoverage2D)coverage, (int[])indexes);
        }
        return (GridCoverage2D)WCSUtils.bandSelect((GridCoverage)coverage, (int[])indexes);
    }

    private List<GridCoverage2D> handleSubsettingExtension(GridCoverage2D coverage, WCSEnvelope subset) {
        ArrayList<GridCoverage2D> result = new ArrayList<GridCoverage2D>();
        if (subset != null) {
            if (subset.isCrossingDateline()) {
                GeneralBounds[] normalizedEnvelopes;
                for (GeneralBounds ge : normalizedEnvelopes = subset.getNormalizedEnvelopes()) {
                    GridCoverage2D cropped;
                    if (this.emptyIntersection(coverage, ge) || (cropped = this.cropOnEnvelope(coverage, (Bounds)ge)) == null) continue;
                    result.add(cropped);
                }
            } else {
                GridCoverage2D cropped = this.cropOnEnvelope(coverage, (Bounds)subset);
                if (cropped != null) {
                    result.add(cropped);
                }
            }
        }
        return result;
    }

    private boolean emptyIntersection(GridCoverage2D coverage, GeneralBounds cropEnvelope) {
        ReferencedEnvelope coverageEnvelope = coverage.getEnvelope2D();
        if (!cropEnvelope.intersects((Bounds)coverageEnvelope, false)) {
            return true;
        }
        ReferencedEnvelope intersection = new ReferencedEnvelope(coverageEnvelope).intersection((Envelope)ReferencedEnvelope.reference((Bounds)cropEnvelope));
        GridGeometry2D gg = coverage.getGridGeometry();
        double resx = gg.getEnvelope2D().getSpan(0) / (double)gg.getGridRange().getSpan(0);
        double resy = gg.getEnvelope2D().getSpan(1) / (double)gg.getGridRange().getSpan(1);
        return intersection.getSpan(0) <= resx / 2.0 || intersection.getSpan(1) <= resy / 2.0;
    }

    private GridCoverage2D cropOnEnvelope(GridCoverage2D coverage, Bounds cropEnvelope) {
        CoordinateReferenceSystem sourceCRS = coverage.getCoordinateReferenceSystem();
        CoordinateReferenceSystem subsettingCRS = cropEnvelope.getCoordinateReferenceSystem();
        try {
            if (!CRS.equalsIgnoreMetadata((Object)subsettingCRS, (Object)sourceCRS)) {
                cropEnvelope = CRS.transform((Bounds)cropEnvelope, (CoordinateReferenceSystem)sourceCRS);
            }
        }
        catch (TransformException e) {
            throw new WCS20Exception("Unable to initialize subsetting envelope", WCS20Exception.WCS20ExceptionCode.SubsettingCrsNotSupported, subsettingCRS.toWKT(), e);
        }
        GridCoverage2D cropped = WCSUtils.crop((GridCoverage2D)coverage, (Bounds)cropEnvelope);
        if (cropped == null) {
            return null;
        }
        cropped = CoverageDimensionCustomizerReader.GridCoverageWrapper.wrapCoverage((GridCoverage2D)cropped, (GridCoverage2D)coverage, null, null, (boolean)false);
        return cropped;
    }

    private GridCoverage2D padOnEnvelope(GridCoverage2D coverage, GeneralBounds padEnvelope) throws TransformException {
        GridCoverage2D padded = WCSUtils.padToEnvelope((GridCoverage2D)coverage, (Bounds)padEnvelope);
        if (padded == coverage) {
            return coverage;
        }
        if (padded == null) {
            return null;
        }
        padded = CoverageDimensionCustomizerReader.GridCoverageWrapper.wrapCoverage((GridCoverage2D)padded, (GridCoverage2D)coverage, null, null, (boolean)false);
        return padded;
    }

    private GridCoverage2D handleScaling(GridCoverage2D coverage, ScalingType scaling, Interpolation spatialInterpolation, double[] preAppliedScale, Hints hints) {
        Utilities.ensureNonNull((String)"interpolation", (Object)spatialInterpolation);
        if (scaling == null) {
            if (spatialInterpolation instanceof InterpolationNearest) {
                return coverage;
            }
            Operation operation = CoverageProcessor.getInstance().getOperation("Warp");
            ParameterValueGroup parameters = operation.getParameters();
            parameters.parameter("Source").setValue((Object)coverage);
            parameters.parameter("warp").setValue((Object)new WarpAffine(AffineTransform.getScaleInstance(1.0, 1.0)));
            parameters.parameter("interpolation").setValue((Object)(spatialInterpolation != null ? spatialInterpolation : InterpolationPolicy.getDefaultPolicy().getInterpolation()));
            parameters.parameter("backgroundValues").setValue((Object)CoverageUtilities.getBackgroundValues((GridCoverage2D)coverage));
            return (GridCoverage2D)CoverageProcessor.getInstance().doOperation(parameters, hints);
        }
        ScalingPolicy scalingPolicy = ScalingPolicy.getPolicy(scaling);
        if (!Double.isNaN(preAppliedScale[0]) && !Double.isNaN(preAppliedScale[1])) {
            Double[] scale = new Double[]{preAppliedScale[0], preAppliedScale[1]};
            hints.add((RenderingHints)new Hints((RenderingHints.Key)PRE_APPLIED_SCALE, (Object)scale));
        }
        return scalingPolicy.scale(coverage, scaling, spatialInterpolation, hints, this.wcs);
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return new DecimalFormat("#.##").format((double)bytes / 1024.0) + "KB";
        }
        return new DecimalFormat("#.##").format((double)bytes / 1024.0 / 1024.0) + "MB";
    }

    static {
        processor = CoverageProcessor.getInstance((Hints)HINTS);
        List delegates = GeoServerExtensions.extensions(CoverageResponseDelegate.class);
        mdFormats = new HashSet<String>();
        for (CoverageResponseDelegate delegate : delegates) {
            if (!(delegate instanceof MultidimensionalCoverageResponse)) continue;
            List formats = delegate.getOutputFormats();
            for (String format : formats) {
                mdFormats.add(delegate.getMimeType(format));
            }
        }
        LOGGER = Logging.getLogger(GetCoverage.class);
        PRE_APPLIED_SCALE = new Hints.Key(Double[].class);
    }

    static class ImageSizeRecorder {
        private long incrementalSize = 0L;
        private final long limit;
        private final boolean input;

        ImageSizeRecorder(long limit, boolean input) {
            this.limit = limit;
            this.input = input;
        }

        public void addSize(GridCoverage2D coverage) {
            this.incrementalSize += ImageSizeRecorder.getCoverageSize(coverage.getGridGeometry().getGridRange2D(), coverage.getRenderedImage().getSampleModel());
            this.isSizeExceeded();
        }

        public long finalSize() {
            return this.incrementalSize;
        }

        private void isSizeExceeded() {
            if (this.limit > 0L && this.incrementalSize > this.limit) {
                throw new WcsException("This request is trying to " + (this.input ? "read" : "generate") + " too much data, the limit is " + GetCoverage.formatBytes(this.limit) + " but the actual amount of bytes to be " + (this.input ? "read" : "written") + " is " + GetCoverage.formatBytes(this.incrementalSize));
            }
        }

        public void reset() {
            this.incrementalSize = 0L;
        }

        private static long getCoverageSize(GridEnvelope2D envelope, SampleModel sm) {
            long pixelsNumber = ImageSizeRecorder.computePixelsNumber(envelope);
            long pixelSize = 0L;
            int numBands = sm.getNumBands();
            for (int i = 0; i < numBands; ++i) {
                pixelSize += (long)sm.getSampleSize(i);
            }
            return pixelsNumber * pixelSize / 8L;
        }

        private static long computePixelsNumber(GridEnvelope2D rasterEnvelope) {
            long pixelsNumber = 1L;
            int dimensions = rasterEnvelope.getDimension();
            for (int i = 0; i < dimensions; ++i) {
                pixelsNumber *= (long)rasterEnvelope.getSpan(i);
            }
            return pixelsNumber;
        }
    }
}

