/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs2_0.response.GMLTransformer;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geotools.coverage.grid.GridCoverage2D;
import org.vfny.geoserver.wcs.WcsException;

public class GMLCoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final String FILE_EXTENSION = "gml";
    private static final String MIME_TYPE = "application/gml+xml";
    private EnvelopeAxesLabelsMapper envelopeDimensionsMapper;

    public GMLCoverageResponseDelegate(EnvelopeAxesLabelsMapper envelopeDimensionsMapper, GeoServer geoserver) {
        super(geoserver, List.of(FILE_EXTENSION, MIME_TYPE), Map.ofEntries(Map.entry(MIME_TYPE, FILE_EXTENSION), Map.entry(FILE_EXTENSION, FILE_EXTENSION)), Map.ofEntries(Map.entry(MIME_TYPE, MIME_TYPE), Map.entry(FILE_EXTENSION, MIME_TYPE)));
        this.envelopeDimensionsMapper = envelopeDimensionsMapper;
    }

    public void encode(GridCoverage2D coverage, String outputFormat, Map<String, String> econdingParameters, OutputStream output) throws ServiceException, IOException {
        GMLTransformer transformer = new GMLTransformer(this.envelopeDimensionsMapper);
        transformer.setIndentation(4);
        try {
            transformer.transform(coverage, output);
        }
        catch (TransformerException e) {
            throw new WcsException((Throwable)e);
        }
    }
}

