/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockFeatureTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData systemTestData) throws Exception {
        this.getServiceDescriptor10().getOperations().add("ReleaseLock");
    }

    @Test
    public void testLockActionSomeAlreadyLocked() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"cdf:Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>    </ogc:Filter>  </wfs:Lock></wfs:LockFeature>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"WFS_LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getElementsByTagName("LockId").item(0).getFirstChild().getNodeValue();
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  lockAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>    </ogc:Filter>  </wfs:Lock></wfs:LockFeature>";
        dom = this.postAsDOM("wfs", (String)xml);
        this.get("wfs?request=ReleaseLock&version=1.0.0&lockId=" + lockId);
        Assert.assertEquals((Object)"WFS_LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("FeaturesNotLocked").getLength());
    }

    @Test
    public void testDeleteWithoutLockId() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"cdf:Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>    </ogc:Filter>  </wfs:Lock></wfs:LockFeature>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"WFS_LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getElementsByTagName("LockId").item(0).getFirstChild().getNodeValue();
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Delete typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>    </ogc:Filter>  </wfs:Delete></wfs:Transaction>";
        dom = this.postAsDOM("wfs", (String)xml);
        this.get("wfs?request=ReleaseLock&version=1.0.0&lockId=" + lockId);
        Assert.assertTrue(("ServiceExceptionReport".equals(dom.getDocumentElement().getNodeName()) || dom.getElementsByTagName("wfs:FAILED").getLength() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateWithLockId() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"cdf:Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>    </ogc:Filter>  </wfs:Lock></wfs:LockFeature>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"WFS_LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getElementsByTagName("LockId").item(0).getFirstChild().getNodeValue();
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:LockId>" + lockId + "</wfs:LockId>  <wfs:Update typeName=\"cdf:Locks\">    <wfs:Property>      <wfs:Name>cdf:id</wfs:Name>      <wfs:Value>lfbt0002</wfs:Value>    </wfs:Property>    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>    </ogc:Filter>  </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", (String)xml);
        this.get("wfs?request=ReleaseLock&version=1.0.0&lockId=" + lockId);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>    </ogc:Filter>  </wfs:Lock></wfs:LockFeature>";
        dom = this.postAsDOM("cdf/wfs", (String)xml);
        Assert.assertEquals((Object)"WFS_LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getElementsByTagName("LockId").item(0).getFirstChild().getNodeValue();
        this.get("wfs?request=ReleaseLock&version=1.0.0&lockId=" + lockId);
    }

    @Test
    public void testLayerQualified() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>    </ogc:Filter>  </wfs:Lock></wfs:LockFeature>";
        dom = this.postAsDOM("cdf/Fifteen/wfs", (String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)dom);
        dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        Assert.assertEquals((Object)"WFS_LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getElementsByTagName("LockId").item(0).getFirstChild().getNodeValue();
        this.get("wfs?request=ReleaseLock&version=1.0.0&lockId=" + lockId);
    }
}

