/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Arrays;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.security.DisabledServiceResourceFilter;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.w3c.dom.Document;

public class WFSDisabledTest
extends WFSTestSupport {
    @Rule
    public final EnvironmentVariables enviromentVariables = new EnvironmentVariables();

    @Before
    public void resetConfiguration() {
        this.getGeoServer().reset();
    }

    @Test
    public void testDisabledServiceResponse() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.setEnabled(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testEnabledServiceResponse() throws Exception {
        this.enableWFS();
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testLayerDisabledServiceResponse() throws Exception {
        this.enableWFS();
        String layerName = "cite:RoadSegments";
        FeatureTypeInfo ftinfo = this.getCatalog().getFeatureTypeByName(layerName);
        ftinfo.setServiceConfiguration(true);
        ftinfo.setDisabledServices(new ArrayList<String>(Arrays.asList("WFS")));
        this.getCatalog().save((ResourceInfo)ftinfo);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + layerName + "&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getNodeName());
        doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
        XMLAssert.assertXpathNotExists((String)("//wfs:FeatureTypeList/wfs:FeatureType/wfs:Name[.='" + layerName + "']"), (Document)doc);
    }

    @Test
    public void testLayerEnvDisabledServiceResponse() throws Exception {
        this.enableWFS();
        this.enviromentVariables.set(DisabledServiceResourceFilter.PROPERTY, "WFS,WPS");
        String layerName = "cite:RoadSegments";
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + layerName + "&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getNodeName());
        doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
        XMLAssert.assertXpathNotExists((String)("//wfs:FeatureTypeList/wfs:FeatureType/wfs:Name[.='" + layerName + "']"), (Document)doc);
    }

    @After
    public void clearEnviromentVariables() {
        this.enviromentVariables.clear(new String[]{DisabledServiceResourceFilter.PROPERTY});
    }

    @Test
    public void testLayerEnabledServiceResponse() throws Exception {
        this.enableWFS();
        String layerName = "cite:RoadSegments";
        FeatureTypeInfo ftinfo = this.getCatalog().getFeatureTypeByName(layerName);
        ftinfo.setServiceConfiguration(false);
        ftinfo.setDisabledServices(new ArrayList());
        this.getCatalog().save((ResourceInfo)ftinfo);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + layerName + "&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
        XMLAssert.assertXpathExists((String)("//wfs:FeatureTypeList/wfs:FeatureType/wfs:Name[.='" + layerName + "']"), (Document)doc);
    }

    private void enableWFS() {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.setEnabled(true);
        this.getGeoServer().save((ServiceInfo)wfs);
    }
}

