/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import org.geoserver.wfs.json.RoundingUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RoundingUtilTest {
    @Test
    public void testSpecialCases() {
        for (int numDecimals = 0; numDecimals < 17; ++numDecimals) {
            MatcherAssert.assertThat((Object)Double.isNaN(RoundingUtil.round((double)Double.NaN, (int)numDecimals)), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)RoundingUtil.round((double)Double.NEGATIVE_INFINITY, (int)numDecimals), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Double.NEGATIVE_INFINITY)));
            MatcherAssert.assertThat((Object)RoundingUtil.round((double)Double.POSITIVE_INFINITY, (int)numDecimals), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Double.POSITIVE_INFINITY)));
        }
    }

    @Test
    public void testSpecificCases() {
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)0.0, (int)0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)0.1, (int)0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)0.1, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.1)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)0.1, (int)2), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.1)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)0.05, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.1)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)-0.05, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0E-7, (int)5), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0000001, (int)7), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0000001)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.00000015, (int)7), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0000002)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)0.001, (int)7), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.001)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0E-4, (int)3), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0E-10, (int)10), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0E-10)));
    }

    @Test
    public void testNoRoundingWhenPrecisionWouldBeExceeded() {
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012346E12, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012E12)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012346E12, (int)2), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.01234567890123E12)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012346E13, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.01234567890123E13)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012346E13, (int)2), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.012345678901235E13)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012345E14, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.012345678901235E14)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012345E14, (int)2), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012345E14)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012345E15, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012345E15)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012345E15, (int)2), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012345E15)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012346E16, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012346E16)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012346E16, (int)2), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012346E16)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012346E17, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012346E17)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012346E18, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012346E18)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)1.0123456789012345E19, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0123456789012345E19)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)Double.MIN_VALUE, (int)15), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
        MatcherAssert.assertThat((Object)RoundingUtil.round((double)Double.MAX_VALUE, (int)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Double.MAX_VALUE)));
    }

    @Test
    public void testRandomRoundingVsBigDecimal() {
        Random r = new Random();
        for (int i = 0; i < 10000; ++i) {
            double value = r.nextDouble();
            for (int numDecimals = 0; numDecimals <= 8; ++numDecimals) {
                double expected = new BigDecimal(Double.toString(value)).setScale(numDecimals, RoundingMode.HALF_UP).doubleValue();
                double actual = RoundingUtil.round((double)value, (int)numDecimals);
                MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
            }
        }
    }
}

