/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.outputformat;

import java.util.Collections;
import org.easymock.EasyMock;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Request;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.outputformat.WFSOutputFormatCallback;
import org.junit.Assert;
import org.junit.Test;

public class WFSOutputFormatCallbackTest {
    @Test(expected=ServiceException.class)
    public void testOperationDispatchedNoPermission() {
        WFSInfo wfs = (WFSInfo)EasyMock.createNiceMock(WFSInfo.class);
        EasyMock.expect((Object)wfs.isGetFeatureOutputTypeCheckingEnabled()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)wfs.getGetFeatureOutputTypes()).andReturn(Collections.singleton("text/xml; subtype=gml/2.0")).anyTimes();
        EasyMock.replay((Object[])new Object[]{wfs});
        GeoServer geoServer = (GeoServer)EasyMock.createNiceMock(GeoServer.class);
        EasyMock.expect((Object)geoServer.getCatalog()).andReturn(null).anyTimes();
        EasyMock.expect((Object)((WFSInfo)geoServer.getService(WFSInfo.class))).andReturn((Object)wfs).anyTimes();
        EasyMock.replay((Object[])new Object[]{geoServer});
        WFSOutputFormatCallback wfsOutputFormatCallback = new WFSOutputFormatCallback(geoServer);
        Request request = new Request();
        request.setService("WFS");
        request.setRequest("GetFeature");
        request.setOutputFormat("text/xml; subtype=gml/3.2");
        Service service = new Service("wfs", null, null, null);
        Operation operationIn = new Operation("GetFeature", service, null, null);
        wfsOutputFormatCallback.operationDispatched(request, operationIn);
    }

    @Test
    public void testOperationDispatchedWithPermission() {
        WFSInfo wfs = (WFSInfo)EasyMock.createNiceMock(WFSInfo.class);
        EasyMock.expect((Object)wfs.isGetFeatureOutputTypeCheckingEnabled()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)wfs.getGetFeatureOutputTypes()).andReturn(Collections.singleton("text/xml; subtype=gml/3.2")).anyTimes();
        EasyMock.replay((Object[])new Object[]{wfs});
        GeoServer geoServer = (GeoServer)EasyMock.createNiceMock(GeoServer.class);
        EasyMock.expect((Object)geoServer.getCatalog()).andReturn(null).anyTimes();
        EasyMock.expect((Object)((WFSInfo)geoServer.getService(WFSInfo.class))).andReturn((Object)wfs).anyTimes();
        EasyMock.replay((Object[])new Object[]{geoServer});
        WFSOutputFormatCallback wfsOutputFormatCallback = new WFSOutputFormatCallback(geoServer);
        Request request = new Request();
        request.setService("WFS");
        request.setRequest("GetFeature");
        request.setOutputFormat("text/xml; subtype=gml/3.2");
        Service service = new Service("wfs", null, null, null);
        Operation operationIn = new Operation("GetFeature", service, null, null);
        Operation operation = wfsOutputFormatCallback.operationDispatched(request, operationIn);
        Assert.assertEquals((Object)"GetFeature", (Object)operation.getId());
    }
}

