/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.util.Map;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.w3c.dom.Document;

public class WFS20TestSupport
extends WFSTestSupport {
    @Before
    public void beforeTest() {
        this.setGmlMimeTypeOverride(null);
    }

    protected void setGmlMimeTypeOverride(String mimeTypeToForce) {
        WFSInfo info = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        GMLInfo gmlInfo = (GMLInfo)info.getGML().get(WFSInfo.Version.V_20);
        gmlInfo.setMimeTypeToForce(mimeTypeToForce);
        this.getGeoServer().save((ServiceInfo)info);
    }

    @Override
    protected void setUpNamespaces(Map<String, String> namespaces) {
        namespaces.put("wfs", "http://www.opengis.net/wfs/2.0");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("fes", "http://www.opengis.net/fes/2.0");
        namespaces.put("gml", "http://www.opengis.net/gml/3.2");
    }

    protected Service getServiceDescriptor20() {
        return (Service)GeoServerExtensions.bean((String)"wfsService-2.0");
    }

    protected void assertGML32(Document doc) {
        Assert.assertEquals((Object)"http://www.opengis.net/wfs/2.0", (Object)doc.getDocumentElement().getAttribute("xmlns:wfs"));
        String schemaLocation = doc.getDocumentElement().getAttribute("xsi:schemaLocation");
        Assert.assertTrue((boolean)schemaLocation.contains("http://www.opengis.net/wfs/2.0"));
        String[] parts = schemaLocation.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equals("http://www.opengis.net/wfs/2.0")) continue;
            Assert.assertTrue((boolean)parts[i + 1].endsWith("2.0/wfs.xsd"));
        }
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
    }
}

