/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.easymock.EasyMock;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gml2.GML;
import org.geotools.xsd.Schemas;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class FeatureTypeInfoSchemaBuilderTest
extends WFSTestSupport {
    protected QName UUID_TEST = new QName(MockData.CITE_URI, "uuid", MockData.CITE_PREFIX);
    protected XpathEngine xpath;

    @Test
    public void testBuildGml2() throws Exception {
        FeatureTypeSchemaBuilder.GML2 builder = new FeatureTypeSchemaBuilder.GML2(this.getGeoServer());
        FeatureTypeInfo lines = this.getFeatureTypeInfo(SystemTestData.LINES);
        XSDSchema schema = builder.build(new FeatureTypeInfo[]{lines}, null);
        Assert.assertNotNull((Object)schema);
        XSDElementDeclaration element = Schemas.getElementDeclaration((XSDSchema)schema, (QName)SystemTestData.LINES);
        Assert.assertNotNull((Object)element);
        Assert.assertTrue((boolean)(element.getType() instanceof XSDComplexTypeDefinition));
        XSDElementDeclaration id = Schemas.getChildElementDeclaration((XSDElementDeclaration)element, (QName)new QName(SystemTestData.CGF_URI, "id"));
        Assert.assertNotNull((Object)id);
        XSDElementDeclaration lineStringProperty = Schemas.getChildElementDeclaration((XSDElementDeclaration)element, (QName)new QName(SystemTestData.CGF_URI, "lineStringProperty"));
        Assert.assertNotNull((Object)lineStringProperty);
        XSDTypeDefinition lineStringPropertyType = lineStringProperty.getType();
        Assert.assertEquals((Object)"http://www.opengis.net/gml", (Object)lineStringPropertyType.getTargetNamespace());
        Assert.assertEquals((Object)GML.LineStringPropertyType.getLocalPart(), (Object)lineStringPropertyType.getName());
        XSDTypeDefinition geometryAssociationType = lineStringPropertyType.getBaseType();
        Assert.assertNotNull((Object)geometryAssociationType);
        Assert.assertEquals((Object)"http://www.opengis.net/gml", (Object)geometryAssociationType.getTargetNamespace());
        Assert.assertEquals((Object)GML.GeometryAssociationType.getLocalPart(), (Object)geometryAssociationType.getName());
    }

    @Override
    protected void setUpInternal(SystemTestData testData) throws Exception {
        super.setUpInternal(testData);
        testData.addVectorLayer(this.UUID_TEST, null, FeatureTypeInfoSchemaBuilderTest.class, this.getCatalog());
    }

    @Before
    public void setXPath() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Test
    public void testUUID() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=1.1.0&request=DescribeFeatureType&typeName=" + this.getLayerId(this.UUID_TEST));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//xsd:element[@name='uuid' and @type='xsd:string'])", dom));
    }

    @Test
    public void testDocumentation() throws Exception {
        DataStoreInfoImpl dataStore = new DataStoreInfoImpl(this.getCatalog());
        dataStore.setEnabled(false);
        dataStore.setName(this.UUID_TEST.getPrefix());
        dataStore.setType("dataStore-Type");
        dataStore.setDescription("dataStore-Description");
        dataStore.setWorkspace(this.getCatalog().getDefaultWorkspace());
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        AttributeDescriptor ad = ab.binding(String.class).nillable(false).description("comments").buildDescriptor("name");
        tb.add(ad);
        tb.setName(this.UUID_TEST.getLocalPart());
        SimpleFeatureType ft = tb.buildFeatureType();
        FeatureTypeInfo ftInfo = (FeatureTypeInfo)EasyMock.mock(FeatureTypeInfo.class);
        EasyMock.expect((Object)ftInfo.getNamespace()).andReturn((Object)this.getCatalog().getDefaultNamespace()).anyTimes();
        EasyMock.expect((Object)ftInfo.getStore()).andReturn((Object)dataStore).anyTimes();
        EasyMock.expect((Object)ftInfo.getFeatureType()).andReturn((Object)ft).anyTimes();
        EasyMock.expect((Object)ftInfo.getName()).andReturn((Object)this.UUID_TEST.getLocalPart()).anyTimes();
        EasyMock.expect((Object)ftInfo.isCircularArcPresent()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{ftInfo});
        FeatureTypeSchemaBuilder.GML2 builder = new FeatureTypeSchemaBuilder.GML2(this.getGeoServer());
        XSDSchema xsdSchema = builder.build(ftInfo, null);
        this.print(xsdSchema.getDocument());
        Assert.assertEquals((Object)"comments", (Object)this.xpath.evaluate("//xsd:documentation", xsdSchema.getDocument()));
    }
}

