/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Map;
import net.opengis.wfs.GetFeatureWithLockType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.NativeType;
import net.opengis.wfs.PropertyType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Test;

public class XMLParsingTest
extends WFSTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Test
    public void testNativeType() throws Exception {
        Parser p = new Parser((Configuration)this.getXmlConfiguration11());
        NativeType nativ = (NativeType)p.parse((InputStream)new ByteArrayInputStream("<wfs:Native safeToIgnore='true' xmlns:wfs='http://www.opengis.net/wfs'>here is some text</wfs:Native>".getBytes()));
        Assert.assertEquals((Object)"here is some text", (Object)nativ.getValue());
    }

    @Test
    public void testGetFeatureWithLock() throws Exception {
        Parser p = new Parser((Configuration)this.getXmlConfiguration11());
        String request = "<wfs:GetFeatureWithLock xmlns:wfs=\"http://www.opengis.net/wfs\" expiry=\"10\" service=\"WFS\" \noutputFormat=\"text/xml; subtype=gml/3.1.1\" version=\"1.1.0\"\nxsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<wfs:Query typeName=\"topp:states\" srsName=\"EPSG:4326\" xmlns:topp=\"http://www.openplans.org/topp\">\n  <ogc:Filter xmlns:ogc=\"http://www.opengis.net/ogc\">\n<ogc:FeatureId fid=\"states.1\"/>\n</ogc:Filter>\n</wfs:Query>\n</wfs:GetFeatureWithLock>";
        GetFeatureWithLockType gf = (GetFeatureWithLockType)p.parse((InputStream)new ByteArrayInputStream(request.getBytes()));
        Assert.assertEquals((Object)"WFS", (Object)gf.getService());
        Assert.assertEquals((Object)"1.1.0", (Object)gf.getVersion());
        Assert.assertEquals((Object)"text/xml; subtype=gml/3.1.1", (Object)gf.getOutputFormat());
        Assert.assertEquals((Object)BigInteger.valueOf(10L), (Object)gf.getExpiry());
    }

    @Test
    public void testUpdate() throws Exception {
        WFSConfiguration xmlConfiguration11 = this.getXmlConfiguration11();
        Parser p = new Parser((Configuration)xmlConfiguration11);
        p.setHandleMixedContent(true);
        String request = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:topp=\"http://www.openplans.org/topp\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"><wfs:Update typeName=\"topp:tasmania_roads\"><wfs:Property><wfs:Name>TYPE</wfs:Name><wfs:Value><![CDATA[street\nline2\nline3\n]]></wfs:Value></wfs:Property><ogc:Filter><ogc:FeatureId fid=\"tasmania_roads.1\"/></ogc:Filter></wfs:Update></wfs:Transaction>";
        TransactionType obj = (TransactionType)p.parse((InputStream)new ByteArrayInputStream(request.getBytes()));
        UpdateElementType update = (UpdateElementType)obj.getUpdate().get(0);
        PropertyType property = (PropertyType)update.getProperty().get(0);
        Assert.assertEquals((Object)"street\nline2\nline3\n", (Object)property.getValue());
    }

    @Test
    public void testInsert() throws Exception {
        WFSConfiguration xmlConfiguration11 = this.getXmlConfiguration11();
        Parser p = new Parser((Configuration)xmlConfiguration11);
        p.setHandleMixedContent(true);
        String request = "<wfs:Transaction xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" service=\"WFS\" version=\"1.1.0\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd\"><wfs:Insert><feature:t2 xmlns:feature=\"http://test\"><feature:geom><gml:Point xmlns:gml=\"http://www.opengis.net/gml\"><gml:pos>0 0</gml:pos></gml:Point></feature:geom><feature:descr><![CDATA[1\n2\n3\n]]></feature:descr></feature:t2></wfs:Insert></wfs:Transaction>";
        TransactionType obj = (TransactionType)p.parse((InputStream)new ByteArrayInputStream(request.getBytes()));
        InsertElementType insert = (InsertElementType)obj.getInsert().get(0);
        SimpleFeature feature = (SimpleFeature)insert.getFeature().get(0);
        Map attr = (Map)feature.getAttribute("descr");
        String expected = "1\n2\n3\n";
        Assert.assertEquals((String)"new lines eaten", (Object)expected, (Object)attr.get(null).toString());
    }
}

