/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs20.StoredQueryDescriptionType;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.exception.GeoServerRuntimException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.WFSInfo;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;

public class StoredQueryProvider {
    public static String LANGUAGE_20_PRE = "urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression";
    public static String LANGUAGE_20 = "urn:ogc:def:queryLanguage:OGC-WFS::WFSQueryExpression";
    static Logger LOGGER = Logging.getLogger(StoredQueryProvider.class);
    Catalog catalog;
    GeoServerResourceLoader loader;
    final WFSInfo wfsInfo;
    final boolean allowPerWorkspace;
    final String workspaceName;

    public StoredQueryProvider(Catalog catalog) {
        this(catalog, null, false, null);
    }

    public StoredQueryProvider(Catalog catalog, WFSInfo wfsInfo, boolean allowPerWorkspace) {
        this(catalog, wfsInfo, allowPerWorkspace, null);
    }

    public StoredQueryProvider(Catalog catalog, WFSInfo wfsInfo, boolean allowPerWorkspace, String workspaceName) {
        this.catalog = catalog;
        this.loader = catalog.getResourceLoader();
        this.wfsInfo = wfsInfo;
        this.allowPerWorkspace = allowPerWorkspace;
        this.workspaceName = workspaceName;
    }

    public String getLanguage() {
        return LANGUAGE_20;
    }

    public List<StoredQuery> listStoredQueries() {
        ArrayList<StoredQuery> queries = new ArrayList<StoredQuery>();
        queries.add(StoredQuery.DEFAULT);
        Resource dir = this.storedQueryDir();
        List<StoredQuery> globalQueries = this.getStoredQueryByResource(dir);
        List<StoredQuery> localQueries = this.getLocalWorkspaceStoredQueries();
        if (this.shouldProcessGlobalQueries()) {
            globalQueries.stream().filter(q -> this.checkQueryNotExists((StoredQuery)q, localQueries)).forEach(q -> queries.add((StoredQuery)q));
        }
        queries.addAll(localQueries);
        return queries;
    }

    private boolean checkQueryNotExists(StoredQuery query, List<StoredQuery> localQueries) {
        return localQueries.stream().noneMatch(local -> Objects.equals(query.getName(), local.getName()));
    }

    private boolean shouldProcessGlobalQueries() {
        if (this.getLocalWorkspace() == null) {
            return true;
        }
        return this.isGlobalQueriesAllowedOnLocalWorkspace();
    }

    public StoredQuery createStoredQuery(StoredQueryDescriptionType query) {
        return this.createStoredQuery(query, true);
    }

    public StoredQuery createStoredQuery(StoredQueryDescriptionType query, boolean store) {
        StoredQuery sq = new StoredQuery(query, this.catalog);
        if (store) {
            this.putStoredQuery(sq);
        }
        return sq;
    }

    public void removeStoredQuery(StoredQuery query) {
        String filename = this.toFilename(query.getName());
        Resource resource = this.storedQueryDirByContext().get(filename);
        if (resource.getType() == Resource.Type.RESOURCE) {
            resource.delete();
        } else if (this.localWorkspaceDir() != null && this.storedQueryDir().get(filename).getType() == Resource.Type.RESOURCE) {
            throw new GeoServerRuntimException("Global query can not be deleted from a virtual service.");
        }
    }

    public void removeAll() {
        for (Resource file : this.storedQueryDirByContext().list()) {
            file.delete();
        }
    }

    public StoredQuery getStoredQuery(String name) {
        if (StoredQuery.DEFAULT.getName().equals(name)) {
            return StoredQuery.DEFAULT;
        }
        try {
            Resource res = this.getResourceByContext(this.toFilename(name));
            if (res == null || res.getType() != Resource.Type.RESOURCE) {
                return null;
            }
            return this.parseStoredQuery(res);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing stored query: " + name, e);
        }
    }

    private Resource getResourceByContext(String filename) {
        Resource res = this.storedQueryDirByContext().get(filename);
        if (res.getType() == Resource.Type.RESOURCE) {
            return res;
        }
        if (this.getLocalWorkspace() != null && this.isGlobalQueriesAllowedOnLocalWorkspace() && (res = this.storedQueryDir().get(filename)).getType() == Resource.Type.RESOURCE) {
            return res;
        }
        return null;
    }

    public void putStoredQuery(StoredQuery query) {
        try {
            Resource dir = this.storedQueryDirByContext();
            Resource f = dir.get(this.toFilename(query.getName()));
            try (BufferedOutputStream bout = new BufferedOutputStream(f.out());){
                Encoder e = new Encoder((Configuration)new WFSConfiguration());
                e.setRootElementType(WFS.StoredQueryDescriptionType);
                e.encode((Object)query.getQuery(), WFS.StoredQueryDescription, (OutputStream)new BufferedOutputStream(bout));
                bout.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("i/o error listing stored queries", e);
        }
    }

    String toFilename(String name) {
        return name.replaceAll("\\W", "") + ".xml";
    }

    Resource storedQueryDir() {
        return this.loader.get("wfs/query");
    }

    StoredQuery parseStoredQuery(Resource file) throws Exception {
        return this.parseStoredQuery(file, new Parser((Configuration)new WFSConfiguration()));
    }

    StoredQuery parseStoredQuery(Resource file, Parser p) throws Exception {
        p.setRootElementType(WFS.StoredQueryDescriptionType);
        try (InputStream fin = file.in();){
            StoredQueryDescriptionType q = (StoredQueryDescriptionType)p.parse((InputStream)new BufferedInputStream(fin));
            StoredQuery storedQuery = this.createStoredQuery(q, false);
            return storedQuery;
        }
    }

    public boolean supportsLanguage(String language) {
        return LANGUAGE_20.equalsIgnoreCase(language) || LANGUAGE_20_PRE.equalsIgnoreCase(language);
    }

    private String getLocalWorkspace() {
        if (!this.allowPerWorkspace) {
            return null;
        }
        if (this.workspaceName != null) {
            return this.workspaceName;
        }
        return Optional.ofNullable(LocalWorkspace.get()).map(WorkspaceInfo::getName).orElse(null);
    }

    private List<StoredQuery> getLocalWorkspaceStoredQueries() {
        Resource dir = this.localWorkspaceStoredQueryDir();
        if (dir == null) {
            return Collections.emptyList();
        }
        return this.getStoredQueryByResource(dir);
    }

    private List<StoredQuery> getStoredQueryByResource(Resource dir) {
        Objects.requireNonNull(dir);
        Parser p = new Parser((Configuration)new WFSConfiguration());
        ArrayList<StoredQuery> queries = new ArrayList<StoredQuery>();
        for (Resource f : dir.list()) {
            try {
                queries.add(this.parseStoredQuery(f, p));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error occurred parsing stored query: " + f, e);
            }
        }
        return queries;
    }

    private String localWorkspaceDir() {
        String localWorkspace = this.getLocalWorkspace();
        if (StringUtils.isBlank((CharSequence)localWorkspace)) {
            return null;
        }
        return "workspaces/" + localWorkspace + "/wfs/query";
    }

    private Resource localWorkspaceStoredQueryDir() {
        String localWorkspaceDir = this.localWorkspaceDir();
        if (StringUtils.isBlank((CharSequence)localWorkspaceDir)) {
            return null;
        }
        return this.loader.get(localWorkspaceDir);
    }

    private Resource storedQueryDirByContext() {
        return Optional.ofNullable(this.localWorkspaceStoredQueryDir()).orElse(this.storedQueryDir());
    }

    private boolean isGlobalQueriesAllowedOnLocalWorkspace() {
        return this.wfsInfo == null ? true : this.wfsInfo.getAllowGlobalQueries();
    }
}

