/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.IdentifierGenerationOptionType;
import net.opengis.wfs.InsertElementType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.TransactionCallback;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTransactionException;
import org.geoserver.wfs.request.Delete;
import org.geoserver.wfs.request.Insert;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geotools.api.data.FeatureLockException;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.filter.FilterFactory;
import org.geotools.data.DefaultTransaction;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

public class Transaction {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    private static final int DELETE_BATCH_SIZE = Integer.getInteger("org.geoserver.wfs.deleteBatchSize", 100);
    protected WFSInfo wfs;
    protected Catalog catalog;
    protected FilterFactory filterFactory;
    protected org.geotools.api.data.Transaction transaction;
    protected List<TransactionElementHandler> transactionElementHandlers = new ArrayList<TransactionElementHandler>();
    protected List<TransactionListener> transactionListeners = new ArrayList<TransactionListener>();
    protected List<TransactionCallback> transactionCallbacks = new ArrayList<TransactionCallback>();

    public Transaction(WFSInfo wfs, Catalog catalog, ApplicationContext context) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.transactionElementHandlers.addAll(GeoServerExtensions.extensions(TransactionElementHandler.class));
        this.transactionListeners.addAll(GeoServerExtensions.extensions(TransactionListener.class));
        this.transactionCallbacks.addAll(GeoServerExtensions.extensions(TransactionCallback.class));
        this.transactionListeners.removeAll(this.transactionCallbacks);
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public TransactionResponse transaction(TransactionRequest request) throws WFSException {
        if (!this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
            throw new WFSException((RequestObject)request, "Transaction support is not enabled");
        }
        try {
            return this.execute(request);
        }
        catch (WFSException e) {
            this.abort(request);
            throw e;
        }
        catch (Throwable t) {
            this.abort(request);
            throw new WFSException((RequestObject)request, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionResponse execute(TransactionRequest request) throws Exception {
        if (request.getReleaseAction() == null) {
            request.setReleaseActionAll();
        }
        request = this.fireBeforeTransaction(request);
        TransactionListenerMux multiplexer = new TransactionListenerMux();
        this.transaction = this.getDatastoreTransaction(request);
        request.setTransaction(this.transaction);
        HashMap<QName, FeatureStore> stores = new HashMap<QName, FeatureStore>();
        HashMap<CallSite, FeatureSource> stores2 = new HashMap<CallSite, FeatureSource>();
        Map<TransactionElement, TransactionElementHandler> elementHandlers = this.gatherElementHandlers(request);
        Iterator<Map.Entry<TransactionElement, TransactionElementHandler>> iterator = elementHandlers.entrySet().iterator();
        while (iterator.hasNext()) {
            String msg;
            Map.Entry<TransactionElement, TransactionElementHandler> elementTransactionElementHandlerEntry;
            Map.Entry<TransactionElement, TransactionElementHandler> entry = elementTransactionElementHandlerEntry = iterator.next();
            TransactionElement element = entry.getKey();
            TransactionElementHandler handler = entry.getValue();
            HashMap<QName, FeatureTypeInfo> featureTypeInfos = new HashMap<QName, FeatureTypeInfo>();
            QName[] typeNames = handler.getTypeNames(request, element);
            for (QName typeName : typeNames) {
                String name = typeName.getLocalPart();
                String namespaceURI = typeName.getNamespaceURI() != null ? typeName.getNamespaceURI() : this.catalog.getDefaultNamespace().getURI();
                LOGGER.fine("Locating FeatureSource uri:'" + namespaceURI + "' name:'" + name + "'");
                FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(namespaceURI, name);
                if (meta == null) {
                    msg = "Feature type '" + name + "' is not available";
                    throw new WFSTransactionException(msg, "InvalidParameterValue", element.getHandle());
                }
                featureTypeInfos.put(typeName, meta);
            }
            handler.checkValidity(element, featureTypeInfos);
            for (FeatureTypeInfo meta : featureTypeInfos.values()) {
                String typeRef = meta.getStore().getName() + ":" + meta.getName();
                String URI2 = meta.getNamespace().getURI();
                QName elementName = new QName(URI2, meta.getName(), meta.getNamespace().getPrefix());
                QName elementNameDefault = null;
                if (this.catalog.getDefaultNamespace().getURI().equals(URI2)) {
                    elementNameDefault = new QName(meta.getName());
                }
                LOGGER.fine("located FeatureType w/ typeRef '" + typeRef + "' and elementName '" + elementName + "'");
                if (stores.containsKey(elementName)) continue;
                try {
                    FeatureSource source = meta.getFeatureSource(null, null);
                    if (source instanceof FeatureStore) {
                        FeatureStore store = (FeatureStore)source;
                        store.setTransaction(this.transaction);
                        stores.put(elementName, (FeatureStore)source);
                        if (elementNameDefault != null) {
                            stores.put(elementNameDefault, (FeatureStore)source);
                        }
                        stores2.put((CallSite)((Object)typeRef), source);
                        continue;
                    }
                    msg = elementName + " is read-only";
                    throw new WFSTransactionException(msg, (String)null, element.getHandle());
                }
                catch (IOException ioException) {
                    msg = elementName + " is not available: " + ioException.getLocalizedMessage();
                    throw new WFSTransactionException(msg, (Throwable)ioException, element.getHandle());
                }
            }
        }
        String authorizationID = request.getLockId();
        if (authorizationID != null) {
            if (!this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                throw new WFSException((RequestObject)request, "Lock support is not enabled");
            }
            LOGGER.finer("got lockId: " + authorizationID);
            if (!this.lockExists(authorizationID)) {
                String mesg = "Attempting to use a lockID that does not exist, it has either expired or was entered wrong.";
                throw new WFSException((RequestObject)request, mesg, "InvalidParameterValue");
            }
            try {
                this.transaction.addAuthorization(authorizationID);
            }
            catch (IOException ioException) {
                throw new WFSException((RequestObject)request, "Authorization ID '" + authorizationID + "' not useable", (Throwable)ioException);
            }
        }
        TransactionResponse result = request.createResponse();
        result.setHandle(request.getHandle());
        WFSException exception = null;
        try {
            BatchManager batchManager = this.createBatchManager(request, multiplexer, stores, elementHandlers, result);
            batchManager.run();
        }
        catch (WFSTransactionException e) {
            LOGGER.log(Level.SEVERE, "Transaction failed", (Throwable)((Object)e));
            if (Dispatcher.isSecurityException((Throwable)e.getCause())) {
                throw e;
            }
            exception = e;
            if (request.getVersion().startsWith("2") && e.getCause() instanceof FeatureLockException && request.getLockId() == null) {
                exception = new WFSTransactionException(e.getMessage(), (Throwable)((Object)e), "MissingParameterValue");
            }
            result.addAction(e.getCode() != null ? e.getCode() : "InvalidParameterValue", e.getLocator(), e.getMessage());
        }
        boolean committed = false;
        try {
            if (exception != null) {
                this.transaction.rollback();
            } else {
                this.fireBeforeCommit(request);
                this.transaction.commit();
                committed = true;
                String lockId = request.getLockId();
                if (lockId != null) {
                    if (request.isReleaseActionAll()) {
                        this.lockRelease(lockId);
                    } else if (request.isReleaseActionSome()) {
                        this.lockRefresh(lockId);
                    }
                }
            }
        }
        finally {
            this.transaction.close();
            this.transaction = null;
            request.setTransaction(null);
        }
        this.fireAfterTransaction(request, result, committed);
        if (exception != null && request.getVersion() != null && request.getVersion().startsWith("2")) {
            if (!(exception instanceof WFSException) || ((WFSException)exception).getCode() == null) {
                exception = new WFSException((RequestObject)request, (Throwable)((Object)exception));
            }
            throw exception;
        }
        List insertedFeatures = result.getInsertedFeatures();
        if (insertedFeatures != null && insertedFeatures.isEmpty()) {
            result.addInsertedFeature(null, this.filterFactory.featureId("none"));
        }
        return result;
    }

    protected BatchManager createBatchManager(TransactionRequest request, TransactionListenerMux multiplexer, Map<QName, FeatureStore> stores, Map<TransactionElement, TransactionElementHandler> elementHandlers, TransactionResponse result) {
        return new BatchManager(request, multiplexer, stores, result, elementHandlers, DELETE_BATCH_SIZE);
    }

    private TransactionRequest fireBeforeTransaction(TransactionRequest request) {
        for (TransactionCallback tp : this.transactionCallbacks) {
            request = tp.beforeTransaction(request);
        }
        return request;
    }

    private void fireAfterTransaction(TransactionRequest request, TransactionResponse result, boolean committed) {
        for (TransactionCallback tp : this.transactionCallbacks) {
            tp.afterTransaction(request, result, committed);
        }
    }

    private void fireBeforeCommit(TransactionRequest request) {
        for (TransactionCallback tp : this.transactionCallbacks) {
            tp.beforeCommit(request);
        }
    }

    private Map<TransactionElement, TransactionElementHandler> gatherElementHandlers(TransactionRequest request) throws WFSTransactionException {
        LinkedHashMap<TransactionElement, TransactionElementHandler> map = new LinkedHashMap<TransactionElement, TransactionElementHandler>();
        List<TransactionElement> elements = request.getElements();
        for (TransactionElement element : elements) {
            map.put(element, this.findElementHandler(element.getClass()));
        }
        return map;
    }

    protected final TransactionElementHandler findElementHandler(Class<?> type) throws WFSTransactionException {
        ArrayList<TransactionElementHandler> matches = new ArrayList<TransactionElementHandler>();
        for (TransactionElementHandler handler : this.transactionElementHandlers) {
            if (!handler.getElementClass().isAssignableFrom(type)) continue;
            matches.add(handler);
        }
        if (matches.isEmpty()) {
            String msg = "No transaction element handler for : ( " + type + " )";
            throw new WFSTransactionException(msg);
        }
        if (matches.size() > 1) {
            Comparator comparator = (h1, h2) -> {
                if (h2.getElementClass().isAssignableFrom(h1.getElementClass())) {
                    return -1;
                }
                return 1;
            };
            Collections.sort(matches, comparator);
        }
        return (TransactionElementHandler)matches.get(0);
    }

    protected DefaultTransaction getDatastoreTransaction(TransactionRequest request) throws IOException {
        DefaultTransaction transaction = new DefaultTransaction();
        Map extendedProperties = request.getExtendedProperties();
        if (extendedProperties != null) {
            for (Map.Entry e : extendedProperties.entrySet()) {
                Object propKey = e.getKey();
                Object propValue = e.getValue();
                transaction.putProperty(propKey, propValue);
            }
        }
        return transaction;
    }

    public void abort(TransactionRequest request) {
        if (this.transaction == null) {
            return;
        }
        try {
            this.transaction.rollback();
            this.transaction.close();
        }
        catch (IOException ioException) {
            LOGGER.log(Level.SEVERE, "Failed trying to rollback a transaction:" + ioException);
        }
        String lockId = request.getLockId();
        if (lockId != null) {
            if (request.isReleaseActionSome()) {
                try {
                    this.lockRefresh(lockId);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured refreshing lock", e);
                }
            } else if (request.isReleaseActionAll()) {
                try {
                    this.lockRelease(lockId);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured releasing lock", e);
                }
            }
        }
    }

    void lockRelease(String lockId) throws WFSException {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.release(lockId);
    }

    private boolean lockExists(String lockId) throws Exception {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        return lockFeature.exists(lockId);
    }

    private void lockRefresh(String lockId) throws Exception {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.refresh(lockId, false);
    }

    protected static class BatchManager {
        private TransactionRequest request;
        private TransactionListener multiplexer;
        private Map<QName, FeatureStore> stores;
        private TransactionResponse result;
        private Map<TransactionElement, TransactionElementHandler> elementHandlers;
        private int maxDeleteCount;
        private TransactionElement aggrTargetElement;
        private TransactionElementHandler aggrTargetHandler;
        private int aggrDeleteCount = 0;

        public BatchManager(TransactionRequest request, TransactionListener multiplexer, Map<QName, FeatureStore> stores, TransactionResponse result, Map<TransactionElement, TransactionElementHandler> elementHandlers, int maxDeleteCount) {
            this.request = request;
            this.multiplexer = multiplexer;
            this.stores = stores;
            this.result = result;
            this.elementHandlers = elementHandlers;
            this.maxDeleteCount = maxDeleteCount;
        }

        public void run() {
            Set<Map.Entry<TransactionElement, TransactionElementHandler>> lEntries = this.elementHandlers.entrySet();
            for (Map.Entry<TransactionElement, TransactionElementHandler> lEntry : lEntries) {
                TransactionElement lCurrentElem = lEntry.getKey();
                TransactionElementHandler lCurrentHandler = lEntry.getValue();
                if (this.aggrTargetElement == null) {
                    this.aggrTargetElement = lCurrentElem;
                    this.aggrTargetHandler = lCurrentHandler;
                    continue;
                }
                if (this.canAggregate(lCurrentElem)) {
                    this.aggregate(lCurrentElem);
                    continue;
                }
                this.runAggregated();
                this.aggrTargetElement = lCurrentElem;
                this.aggrTargetHandler = lCurrentHandler;
            }
            if (this.aggrTargetElement != null) {
                this.runAggregated();
            }
        }

        private boolean canAggregate(TransactionElement pElem) {
            if (this.aggrTargetElement instanceof Insert && pElem instanceof Insert) {
                return this.idGenEquals(this.getIdGen((Insert)this.aggrTargetElement), this.getIdGen((Insert)pElem));
            }
            if (this.aggrTargetElement instanceof Delete && pElem instanceof Delete) {
                if (this.aggrDeleteCount >= this.maxDeleteCount - 1) {
                    return false;
                }
                Delete lTarget = (Delete)this.aggrTargetElement;
                Delete lElem = (Delete)pElem;
                QName lTargetType = lTarget.getTypeName();
                QName lElemType = lElem.getTypeName();
                if (lTargetType != null && lTargetType.equals(lElemType)) {
                    return true;
                }
            }
            return false;
        }

        private IdentifierGenerationOptionType getIdGen(Insert insert) {
            EObject adaptee = insert.getAdaptee();
            if (adaptee instanceof InsertElementType) {
                return ((InsertElementType)adaptee).getIdgen();
            }
            return null;
        }

        private boolean idGenEquals(IdentifierGenerationOptionType i1, IdentifierGenerationOptionType i2) {
            return i1 == i2 || i1 == IdentifierGenerationOptionType.GENERATE_NEW_LITERAL && i2 == null || i2 == IdentifierGenerationOptionType.GENERATE_NEW_LITERAL && i1 == null;
        }

        private void aggregate(TransactionElement pElem) {
            boolean lRemoveFromRequest = false;
            if (this.aggrTargetElement instanceof Insert) {
                Insert lTarget = (Insert)this.aggrTargetElement;
                Insert lElem = (Insert)pElem;
                lTarget.addFeatures(lElem.getFeatures());
                lRemoveFromRequest = true;
            } else if (this.aggrTargetElement instanceof Delete) {
                Delete lTarget = (Delete)this.aggrTargetElement;
                Delete lElem = (Delete)pElem;
                lTarget.addFilter(lElem.getFilter());
                ++this.aggrDeleteCount;
                lRemoveFromRequest = true;
            }
            if (lRemoveFromRequest) {
                this.request.remove(pElem);
            }
        }

        private void runAggregated() {
            this.aggrTargetHandler.execute(this.aggrTargetElement, this.request, this.stores, this.result, this.multiplexer);
            this.aggrDeleteCount = 0;
        }
    }

    class TransactionListenerMux
    implements TransactionListener {
        TransactionListenerMux() {
        }

        public void dataStoreChange(List listeners, TransactionEvent event) throws WFSException {
            for (Object o : listeners) {
                TransactionListener listener = (TransactionListener)o;
                listener.dataStoreChange(event);
            }
        }

        @Override
        public void dataStoreChange(TransactionEvent event) throws WFSException {
            this.dataStoreChange(Transaction.this.transactionCallbacks, event);
            this.dataStoreChange(Transaction.this.transactionListeners, event);
        }
    }
}

