/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AliasTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData testData) throws Exception {
        this.setAliasedType(CiteTestData.FIFTEEN, "ft15", this.getCatalog());
    }

    private void setAliasedType(QName qName, String alias, Catalog catalog) throws IOException {
        String name = qName.getLocalPart();
        FeatureTypeInfo featureType = catalog.getFeatureTypeByName(name);
        featureType.setName(alias);
        this.getCatalog().save((ResourceInfo)featureType);
    }

    @Test
    public void testAliasFifteen() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:ft15&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertTrue((doc.getElementsByTagName("gml:featureMember").getLength() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((doc.getElementsByTagName("cdf:ft15").getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetByFeatureId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:ft15&version=1.0.0&featureId=ft15.1");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        NodeList features = doc.getElementsByTagName("cdf:ft15");
        Assert.assertEquals((long)1L, (long)features.getLength());
        Node feature = features.item(0);
        Node fidNode = feature.getAttributes().getNamedItem("fid");
        Assert.assertEquals((Object)"ft15.1", (Object)fidNode.getTextContent());
    }

    @Test
    public void testDescribeFeatureType() throws Exception {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&typename=cdf:ft15&version=1.0.0");
        this.print(doc);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"ft15", (String)"/xs:schema/xs:element/@name", (Document)doc);
    }
}

