/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.wfs.IdentifierGenerationOptionType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.DeleteType;
import net.opengis.wfs20.InsertType;
import net.opengis.wfs20.NativeType;
import net.opengis.wfs20.ReplaceType;
import net.opengis.wfs20.TransactionType;
import net.opengis.wfs20.UpdateType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.Transaction;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.request.Delete;
import org.geoserver.wfs.request.Insert;
import org.geoserver.wfs.request.Native;
import org.geoserver.wfs.request.Replace;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geoserver.wfs.request.Update;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Or;
import org.geotools.util.MapEntry;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BatchManagerTest {
    private TransactionListener transactionListener = (TransactionListener)Mockito.mock(TransactionListener.class);
    private TransactionResponse transactionResponse = (TransactionResponse)Mockito.mock(TransactionResponse.class);
    private SimpleFeature feature1 = (SimpleFeature)Mockito.mock(SimpleFeature.class);
    private SimpleFeature feature2 = (SimpleFeature)Mockito.mock(SimpleFeature.class);
    private SimpleFeature feature3 = (SimpleFeature)Mockito.mock(SimpleFeature.class);
    private SimpleFeature feature4 = (SimpleFeature)Mockito.mock(SimpleFeature.class);
    private QName type1Name = new QName("t1");
    private QName type2Name = new QName("t2");
    private Filter filter1 = (Filter)Mockito.mock(Filter.class);
    private Filter filter2 = (Filter)Mockito.mock(Filter.class);
    private Filter filter3 = (Filter)Mockito.mock(Filter.class);
    private Map<QName, FeatureStore> stores = Collections.emptyMap();

    @Test
    public void testAggregation() throws Exception {
        int lDeleteBatchSize = 100;
        this.testAggregationWithDeleteBatchSize(lDeleteBatchSize);
    }

    @Test
    public void testAggregationNoDeleteAgg() throws Exception {
        this.testAggregationWithDeleteBatchSize(1);
        this.testAggregationWithDeleteBatchSize(0);
        this.testAggregationWithDeleteBatchSize(-1);
    }

    @Test
    public void testLargeBatchDeletion() {
        int batchSizeForDeletion = 40;
        LinkedHashMap<Delete, TransactionElementHandler> element2Handlers = new LinkedHashMap<Delete, TransactionElementHandler>();
        Delete delete1 = this.newDelete(this.type1Name, this.filter1);
        TransactionElementHandler delete1Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        element2Handlers.put(delete1, delete1Handler);
        for (int i = 1; i < 40; ++i) {
            Delete delete = this.newDelete(this.type1Name, this.filter1);
            TransactionElementHandler deleteHandler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
            element2Handlers.put(delete, deleteHandler);
        }
        TransactionRequest lTransaction = this.transactionRequest(element2Handlers.keySet());
        Transaction.BatchManager sut = new Transaction.BatchManager(lTransaction, this.transactionListener, this.stores, this.transactionResponse, element2Handlers, 40);
        sut.run();
        String message = String.format("First %d DELETEs have been merged", 40);
        Assert.assertTrue((String)message, (boolean)(delete1.getFilter() instanceof Or));
        int lOrCount = ((Or)delete1.getFilter()).getChildren().size();
        Assert.assertEquals((String)message, (long)40L, (long)lOrCount);
        ((TransactionElementHandler)Mockito.verify((Object)delete1Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)delete1), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
    }

    @Test
    public void testAggregationWithDifferentIdGen() {
        Insert insertUseExisting1 = this.newUseExistingIDInsert(this.feature1);
        TransactionElementHandler insert1Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Insert insertUseExisting2 = this.newUseExistingIDInsert(this.feature2);
        TransactionElementHandler insert2Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Insert insertGenerateNew3 = this.newGenerateNewIDInsert(this.feature3);
        TransactionElementHandler insert3Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Insert insertUseExisting4 = this.newUseExistingIDInsert(this.feature4);
        TransactionElementHandler insert4Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Map element2Handlers = this.asMap(this.keyValue((TransactionElement)insertUseExisting1, insert1Handler), this.keyValue((TransactionElement)insertUseExisting2, insert2Handler), this.keyValue((TransactionElement)insertGenerateNew3, insert3Handler), this.keyValue((TransactionElement)insertUseExisting4, insert4Handler));
        TransactionRequest lTransaction = this.transactionRequestV11(element2Handlers.keySet());
        Transaction.BatchManager sut = new Transaction.BatchManager(lTransaction, this.transactionListener, this.stores, this.transactionResponse, element2Handlers, 100);
        sut.run();
        Assert.assertEquals((String)"First insert has two features", (long)2L, (long)insertUseExisting1.getFeatures().size());
        Assert.assertEquals((String)"Second insert has no added features", (long)1L, (long)insertUseExisting2.getFeatures().size());
        Assert.assertEquals((String)"Second feature has been added to insert1", insertUseExisting1.getFeatures().get(1), (Object)this.feature2);
        Assert.assertEquals((String)"Third INSERT have been not merged", (long)1L, (long)insertGenerateNew3.getFeatures().size());
        Assert.assertEquals((String)"Last INSERT have been not merged", (long)1L, (long)insertUseExisting4.getFeatures().size());
        ((TransactionElementHandler)Mockito.verify((Object)insert1Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)insertUseExisting1), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)insert2Handler, (VerificationMode)Mockito.times((int)0))).execute((TransactionElement)ArgumentMatchers.any(), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)insert3Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)insertGenerateNew3), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)insert4Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)insertUseExisting4), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
    }

    private void testAggregationWithDeleteBatchSize(int pDeleteBatchSize) {
        Insert insert1 = this.newInsert(this.feature1);
        TransactionElementHandler insert1Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Insert insert2 = this.newInsert(this.feature2);
        TransactionElementHandler insert2Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Update update1 = this.newUpdate();
        TransactionElementHandler update1Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Insert insert3 = this.newInsert(this.feature3);
        TransactionElementHandler insert3Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Delete delete1 = this.newDelete(this.type1Name, this.filter1);
        TransactionElementHandler delete1Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Delete delete2 = this.newDelete(this.type1Name, this.filter2);
        TransactionElementHandler delete2Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Delete delete3 = this.newDelete(this.type2Name, this.filter3);
        TransactionElementHandler delete3Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Replace replace1 = this.newReplace(this.feature4);
        TransactionElementHandler replace1Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Native native1 = this.newNative();
        TransactionElementHandler native1Handler = (TransactionElementHandler)Mockito.mock(TransactionElementHandler.class);
        Map element2Handlers = this.asMap(this.keyValue((TransactionElement)insert1, insert1Handler), this.keyValue((TransactionElement)insert2, insert2Handler), this.keyValue((TransactionElement)update1, update1Handler), this.keyValue((TransactionElement)insert3, insert3Handler), this.keyValue((TransactionElement)delete1, delete1Handler), this.keyValue((TransactionElement)delete2, delete2Handler), this.keyValue((TransactionElement)delete3, delete3Handler), this.keyValue((TransactionElement)replace1, replace1Handler), this.keyValue((TransactionElement)native1, native1Handler));
        TransactionRequest lTransaction = this.transactionRequest(element2Handlers.keySet());
        Transaction.BatchManager sut = new Transaction.BatchManager(lTransaction, this.transactionListener, this.stores, this.transactionResponse, element2Handlers, pDeleteBatchSize);
        sut.run();
        Assert.assertEquals((String)"First 2 INSERTs have been merged", (long)2L, (long)insert1.getFeatures().size());
        if (pDeleteBatchSize <= 1) {
            Assert.assertFalse((String)"First 2 DELETEs must not be merged", (boolean)(delete1.getFilter() instanceof Or));
        } else {
            Assert.assertTrue((String)"First 2 DELETEs have been merged", (boolean)(delete1.getFilter() instanceof Or));
            int lOrCount = ((Or)delete1.getFilter()).getChildren().size();
            Assert.assertEquals((String)"First 2 DELETEs have been merged", (long)2L, (long)lOrCount);
        }
        ((TransactionElementHandler)Mockito.verify((Object)insert1Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)insert1), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)insert2Handler, (VerificationMode)Mockito.times((int)0))).execute((TransactionElement)ArgumentMatchers.any(), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)update1Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)update1), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)insert3Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)insert3), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)delete1Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)delete1), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)delete2Handler, (VerificationMode)Mockito.times((int)(pDeleteBatchSize <= 1 ? 1 : 0)))).execute((TransactionElement)ArgumentMatchers.any(), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)delete3Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)delete3), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)replace1Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)replace1), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        ((TransactionElementHandler)Mockito.verify((Object)native1Handler, (VerificationMode)Mockito.times((int)1))).execute((TransactionElement)ArgumentMatchers.same((Object)native1), (TransactionRequest)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (TransactionResponse)ArgumentMatchers.any(), (TransactionListener)ArgumentMatchers.any());
        List lElements = lTransaction.getElements();
        if (pDeleteBatchSize <= 1) {
            Assert.assertEquals((long)8L, (long)lElements.size());
        } else {
            Assert.assertEquals((long)7L, (long)lElements.size());
        }
    }

    private TransactionRequest transactionRequest(Set<TransactionElement> pElems) {
        TransactionType lTransactionType = Wfs20Factory.eINSTANCE.createTransactionType();
        TransactionRequest lTransactionRequest = TransactionRequest.adapt((Object)lTransactionType);
        lTransactionRequest.setElements(new ArrayList<TransactionElement>(pElems));
        return lTransactionRequest;
    }

    private TransactionRequest transactionRequestV11(Set<TransactionElement> pElems) {
        net.opengis.wfs.TransactionType lTransactionType = WfsFactory.eINSTANCE.createTransactionType();
        TransactionRequest lTransactionRequest = TransactionRequest.adapt((Object)lTransactionType);
        lTransactionRequest.setElements(new ArrayList<TransactionElement>(pElems));
        return lTransactionRequest;
    }

    private MapEntry<TransactionElement, TransactionElementHandler> keyValue(TransactionElement pElement, TransactionElementHandler pElementHandler) {
        return new MapEntry((Object)pElement, (Object)pElementHandler);
    }

    @SafeVarargs
    private final <K, V> Map<K, V> asMap(MapEntry<K, V> ... pEntries) {
        LinkedHashMap<Object, Object> lResult = new LinkedHashMap<Object, Object>();
        for (MapEntry<K, V> mapEntry : pEntries) {
            lResult.put(mapEntry.getKey(), mapEntry.getValue());
        }
        return lResult;
    }

    private Native newNative() {
        NativeType lNativeType = Wfs20Factory.eINSTANCE.createNativeType();
        Native.WFS20 lNative = new Native.WFS20((EObject)lNativeType);
        return lNative;
    }

    private Replace newReplace(SimpleFeature pFeature) {
        ReplaceType lUpdateType = Wfs20Factory.eINSTANCE.createReplaceType();
        Replace.WFS20 lReplace = new Replace.WFS20((EObject)lUpdateType);
        return lReplace;
    }

    private Delete newDelete(QName pTypeName, Filter pFilter) {
        DeleteType lDeleteType = Wfs20Factory.eINSTANCE.createDeleteType();
        Delete.WFS20 lDelete = new Delete.WFS20((EObject)lDeleteType);
        lDelete.setTypeName(pTypeName);
        lDelete.setFilter(pFilter);
        return lDelete;
    }

    private Update newUpdate() {
        UpdateType lUpdateType = Wfs20Factory.eINSTANCE.createUpdateType();
        Update.WFS20 lUpdate = new Update.WFS20((EObject)lUpdateType);
        return lUpdate;
    }

    private Insert newInsert(SimpleFeature pFeature) {
        InsertType lInsertType = Wfs20Factory.eINSTANCE.createInsertType();
        Insert.WFS20 lInsert = new Insert.WFS20((EObject)lInsertType);
        lInsert.setFeatures(Arrays.asList(pFeature));
        return lInsert;
    }

    private Insert newUseExistingIDInsert(SimpleFeature pFeature) {
        InsertElementType lInsertType = WfsFactory.eINSTANCE.createInsertElementType();
        lInsertType.setIdgen(IdentifierGenerationOptionType.USE_EXISTING_LITERAL);
        Insert.WFS11 lInsert = new Insert.WFS11((EObject)lInsertType);
        lInsert.setFeatures(Arrays.asList(pFeature));
        return lInsert;
    }

    private Insert newGenerateNewIDInsert(SimpleFeature pFeature) {
        InsertElementType lInsertType = WfsFactory.eINSTANCE.createInsertElementType();
        lInsertType.setIdgen(IdentifierGenerationOptionType.GENERATE_NEW_LITERAL);
        Insert.WFS11 lInsert = new Insert.WFS11((EObject)lInsertType);
        lInsert.setFeatures(Arrays.asList(pFeature));
        return lInsert;
    }
}

