/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.data.test.CiteTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class GeometrylessWriteTest
extends WFSTestSupport {
    @Before
    public void revert() throws Exception {
        this.revertLayer(CiteTestData.GEOMETRYLESS);
    }

    @Test
    public void testUpdate() throws Exception {
        String update = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cite:Geometryless\" > <wfs:Property><wfs:Name>name</wfs:Name><wfs:Value>AnotherName</wfs:Value></wfs:Property><ogc:Filter><ogc:FeatureId fid=\"Geometryless.2\"/></ogc:Filter></wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", update);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.0.0&service=wfs&featureId=Geometryless.2");
        Assert.assertEquals((Object)"AnotherName", (Object)dom.getElementsByTagName("cite:name").item(0).getFirstChild().getNodeValue());
    }

    @Test
    public void testDelete() throws Exception {
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Delete typeName=\"cite:Geometryless\" > <ogc:Filter><ogc:FeatureId fid=\"Geometryless.2\"/></ogc:Filter></wfs:Delete></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", insert);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.0.0&service=wfs&featureId=Geometryless.2");
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("cite:Geometryless").getLength());
    }

    @Test
    public void testInsert() throws Exception {
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cite:Geometryless fid=\"Geometryless.4\"><cite:name>Gimbo</cite:name><cite:number>1000</cite:number></cite:Geometryless></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", insert);
        this.print(dom);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:InsertResult").getLength());
        dom = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.0.0&service=wfs");
        Assert.assertEquals((long)4L, (long)dom.getElementsByTagName("cite:Geometryless").getLength());
    }
}

