/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetFeatureBboxTest
extends WFSTestSupport {
    @Test
    public void testFeatureBoudingOn() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.0.0&service=wfs&propertyName=ADDRESS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:boundedBy/gml:Box)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//cite:Buildings/gml:boundedBy/gml:Box", doc).getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFeatureBoudingOff() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.0.0&service=wfs&propertyName=ADDRESS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wfs:FeatureCollection/gml:boundedBy/gml:Box)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//cite:Buildings/gml:boundedBy/gml:Box", doc).getLength());
    }
}

