/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.FeatureBoundsFeatureCollection;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.junit.Assert;
import org.junit.Test;

public class GetFeatureBoundedTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @Test
    public void testCloseIterators() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.POLYGONS));
        FeatureSource fs = fti.getFeatureSource(null, null);
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fs.getFeatures();
        final AtomicInteger openIterators = new AtomicInteger(0);
        DecoratingSimpleFeatureCollection decorated = new DecoratingSimpleFeatureCollection(fc){

            public SimpleFeatureIterator features() {
                openIterators.incrementAndGet();
                final SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)this.delegate);
                return new SimpleFeatureIterator(){

                    public SimpleFeature next() throws NoSuchElementException {
                        return f;
                    }

                    public boolean hasNext() {
                        return true;
                    }

                    public void close() {
                        openIterators.decrementAndGet();
                    }
                };
            }
        };
        FeatureBoundsFeatureCollection fbc = new FeatureBoundsFeatureCollection((SimpleFeatureCollection)decorated, (SimpleFeatureType)decorated.getSchema());
        SimpleFeatureIterator i = fbc.features();
        i.close();
        Assert.assertEquals((long)0L, (long)openIterators.get());
    }
}

